/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.restclient;

import io.dropwizard.client.JerseyClientBuilder;
import io.dropwizard.client.JerseyClientConfiguration;
import io.dropwizard.setup.Environment;
import java.net.ProxySelector;
import javax.inject.Provider;
import javax.ws.rs.client.Client;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import uk.gov.ida.configuration.JerseyClientWithRetryBackoffConfiguration;
import uk.gov.ida.restclient.TimeoutRequestRetryHandler;
import uk.gov.ida.restclient.TimeoutRequestRetryWithBackoffHandler;

public class ClientProvider
implements Provider<Client> {
    private final Client client;

    public ClientProvider(Environment environment, JerseyClientConfiguration jerseyClientConfiguration, boolean enableRetryTimeOutConnections, String clientName) {
        JerseyClientBuilder jerseyClientBuilder = new JerseyClientBuilder(environment).using(jerseyClientConfiguration).using(this.getHttpRequestRetryHandler(jerseyClientConfiguration, enableRetryTimeOutConnections)).using((HttpRoutePlanner)new SystemDefaultRoutePlanner(ProxySelector.getDefault()));
        this.client = jerseyClientBuilder.build(clientName);
    }

    public ClientProvider(Environment environment, JerseyClientWithRetryBackoffConfiguration jerseyClientConfiguration, boolean enableRetryTimeOutConnections, String clientName) {
        JerseyClientBuilder jerseyClientBuilder = new JerseyClientBuilder(environment).using((JerseyClientConfiguration)jerseyClientConfiguration).using(this.getHttpRequestRetryHandler(jerseyClientConfiguration, enableRetryTimeOutConnections)).using((HttpRoutePlanner)new SystemDefaultRoutePlanner(ProxySelector.getDefault()));
        this.client = jerseyClientBuilder.build(clientName);
    }

    private HttpRequestRetryHandler getHttpRequestRetryHandler(JerseyClientConfiguration jerseyClientConfiguration, boolean enableRetryTimeOutConnections) {
        TimeoutRequestRetryHandler retryHandler = enableRetryTimeOutConnections ? new TimeoutRequestRetryHandler(jerseyClientConfiguration.getRetries()) : new StandardHttpRequestRetryHandler(0, false);
        return retryHandler;
    }

    private HttpRequestRetryHandler getHttpRequestRetryHandler(JerseyClientWithRetryBackoffConfiguration jerseyClientConfiguration, boolean enableRetryTimeOutConnections) {
        Object retryHandler = enableRetryTimeOutConnections ? (jerseyClientConfiguration.getRetryExceptionNames() == null ? new TimeoutRequestRetryWithBackoffHandler(jerseyClientConfiguration.getRetries(), jerseyClientConfiguration.getRetryBackoffPeriod()) : new TimeoutRequestRetryWithBackoffHandler(jerseyClientConfiguration.getRetries(), jerseyClientConfiguration.getRetryBackoffPeriod(), jerseyClientConfiguration.getRetryExceptionNames())) : new StandardHttpRequestRetryHandler(0, false);
        return retryHandler;
    }

    public Client get() {
        return this.client;
    }
}

