/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.jerseyclient;

import com.codahale.metrics.Meter;
import java.util.function.Supplier;
import javax.ws.rs.ProcessingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryCommand<T> {
    private static final Logger LOG = LoggerFactory.getLogger(RetryCommand.class);
    private int retryCounter;
    private int maxRetries;
    private Class exceptionClass;
    private Meter retryMeter;

    public RetryCommand(int maxRetries) {
        this(maxRetries, Exception.class, null);
    }

    public RetryCommand(int maxRetries, Class exceptionClass) {
        this(maxRetries, exceptionClass, null);
    }

    public RetryCommand(int maxRetries, Meter retryMeter) {
        this(maxRetries, Exception.class, retryMeter);
    }

    public RetryCommand(int maxRetries, Class exceptionClass, Meter retryMeter) {
        this.exceptionClass = exceptionClass;
        this.retryMeter = retryMeter;
        this.retryCounter = 0;
        this.maxRetries = maxRetries;
    }

    public T execute(Supplier<T> function) {
        try {
            return function.get();
        }
        catch (Exception e) {
            if (!this.exceptionClass.isInstance(e)) {
                throw e;
            }
            if (this.retryCounter >= this.maxRetries) {
                return this.failAndStopRetry(e, function);
            }
            if (this.retryCounter == 0) {
                this.logInitialFail(e, function);
            } else {
                this.logRetryFail(e, function);
            }
            ++this.retryCounter;
            if (this.retryMeter != null) {
                this.retryMeter.mark();
            }
            return this.execute(function);
        }
    }

    private void logRetryFail(Exception e, Supplier<T> function) {
        LOG.warn(String.format("Command %s failed on retry %d of %d.", function.toString(), this.retryCounter, this.maxRetries), (Throwable)e);
    }

    private void logInitialFail(Exception e, Supplier<T> function) {
        LOG.warn(String.format("Command %s failed, will be retried %d times.", function.toString(), this.maxRetries), (Throwable)e);
    }

    private T failAndStopRetry(Exception e, Supplier<T> function) {
        LOG.warn("Max retries exceeded for " + function.toString());
        throw new ProcessingException(String.format("Command %s failed on all of %d retries.", function.toString(), this.maxRetries), (Throwable)e);
    }
}

