/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.jerseyclient;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import uk.gov.ida.common.ExceptionType;
import uk.gov.ida.exceptions.ApplicationException;
import uk.gov.ida.jerseyclient.RetryCommand;

public class ErrorHandlingClient {
    private final Client jerseyClient;
    private Integer numberOfRetries = 0;

    @Inject
    public ErrorHandlingClient(Client jerseyClient) {
        this.numberOfRetries = 0;
        this.jerseyClient = jerseyClient;
    }

    public ErrorHandlingClient(Client jerseyClient, Integer numberOfRetries) {
        this.numberOfRetries = numberOfRetries;
        this.jerseyClient = jerseyClient;
    }

    public Response get(URI uri) {
        return this.get(uri, Collections.emptyList(), Collections.emptyMap());
    }

    public Response get(URI uri, Map<String, String> headers) {
        return this.get(uri, Collections.emptyList(), headers);
    }

    public Response get(URI uri, List<Cookie> cookies, Map<String, String> headers) {
        try {
            Invocation.Builder requestBuilder = this.jerseyClient.target(uri).request();
            for (Cookie cookie : cookies) {
                requestBuilder = requestBuilder.cookie(cookie);
            }
            requestBuilder = this.addHeaders(headers, requestBuilder);
            Invocation.Builder client = requestBuilder.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
            if (this.numberOfRetries != 0) {
                RetryCommand<Response> retryCommand = new RetryCommand<Response>(this.numberOfRetries);
                return retryCommand.execute(() -> ((Invocation.Builder)client).get());
            }
            return client.get();
        }
        catch (ProcessingException e) {
            throw ApplicationException.createUnauditedException(ExceptionType.NETWORK_ERROR, UUID.randomUUID(), e, uri);
        }
    }

    public Response post(URI uri, Object postBody) {
        return this.post(uri, Collections.emptyMap(), postBody);
    }

    public Response post(URI uri, Map<String, String> headers, Object postBody) {
        try {
            Invocation.Builder request = this.jerseyClient.target(uri).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
            Invocation.Builder requestBuilder = this.addHeaders(headers, request);
            if (this.numberOfRetries != 0) {
                RetryCommand<Response> retryCommand = new RetryCommand<Response>(this.numberOfRetries);
                return retryCommand.execute(() -> requestBuilder.post(Entity.json((Object)postBody)));
            }
            return requestBuilder.post(Entity.json((Object)postBody));
        }
        catch (ProcessingException e) {
            throw ApplicationException.createUnauditedException(ExceptionType.NETWORK_ERROR, UUID.randomUUID(), e, uri);
        }
    }

    private Invocation.Builder addHeaders(Map<String, String> headers, Invocation.Builder requestBuilder) {
        for (Map.Entry<String, String> headerDetail : headers.entrySet()) {
            if (headerDetail.getValue() == null) continue;
            requestBuilder = requestBuilder.header(headerDetail.getKey(), (Object)headerDetail.getValue());
        }
        return requestBuilder;
    }
}

