/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.resources;

import java.io.IOException;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import uk.gov.ida.common.VersionInfoDto;

@Path(value="/internal/version-info")
@Produces(value={"application/json"})
public class VersionInfoResource {
    @GET
    public VersionInfoDto getVersionInfo() {
        Attributes manifest = this.getManifest();
        String buildNumber = manifest.getValue("Build-Number");
        String gitCommit = manifest.getValue("Git-Commit");
        String buildTimestamp = manifest.getValue("Build-Timestamp");
        return new VersionInfoDto(buildNumber, gitCommit, buildTimestamp);
    }

    private Attributes getManifest() {
        Manifest manifest;
        ClassLoader cl = this.getClass().getClassLoader();
        try {
            URL url = cl.getResource("META-INF/MANIFEST.MF");
            manifest = new Manifest(url.openStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return manifest.getMainAttributes();
    }
}

