/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.analytics;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.core.Cookie;
import org.apache.http.client.utils.URIBuilder;
import org.glassfish.jersey.server.ContainerRequest;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.ida.analytics.CustomVariable;
import uk.gov.ida.analytics.PiwikClient;
import uk.gov.ida.configuration.AnalyticsConfiguration;

public class AnalyticsReporter {
    private static final Logger LOG = LoggerFactory.getLogger(AnalyticsReporter.class);
    public static final String PIWIK_VISITOR_ID = "PIWIK_VISITOR_ID";
    public static final String REFERER = "Referer";
    private AnalyticsConfiguration analyticsConfiguration;
    private PiwikClient piwikClient;

    @Inject
    public AnalyticsReporter(PiwikClient piwikClient, AnalyticsConfiguration analyticsConfiguration) {
        this.piwikClient = piwikClient;
        this.analyticsConfiguration = analyticsConfiguration;
    }

    public void reportCustomVariable(String friendlyDescription, ContainerRequest context, CustomVariable customVariable) {
        this.reportToPiwik(friendlyDescription, context, Optional.of(customVariable));
    }

    public void report(String friendlyDescription, ContainerRequest context) {
        this.reportToPiwik(friendlyDescription, context, Optional.empty());
    }

    public void reportPageView(String pageTitle, ContainerRequest context, String uri) {
        if (this.analyticsConfiguration.getEnabled()) {
            try {
                this.piwikClient.report(this.generateCustomURI(pageTitle, uri, this.getVisitorId(context)), context);
            }
            catch (Exception e) {
                LOG.error("Analytics Reporting error", (Throwable)e);
            }
        }
    }

    private Optional<String> getVisitorId(ContainerRequest context) {
        return Optional.ofNullable((Cookie)context.getCookies().get(PIWIK_VISITOR_ID)).map(Cookie::getValue);
    }

    private URI generateCustomURI(String friendlyDescription, String url, Optional<String> visitorId) throws URISyntaxException {
        return this.buildAnalyticsURI(friendlyDescription, url, visitorId).build();
    }

    private URIBuilder buildBaseURI(Optional<String> visitorId) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(this.analyticsConfiguration.getPiwikServerSideUrl());
        if (visitorId.isPresent()) {
            uriBuilder.addParameter("_id", visitorId.get());
        }
        return uriBuilder.addParameter("idsite", this.analyticsConfiguration.getSiteId().toString()).addParameter("apiv", "1").addParameter("rec", "1");
    }

    private URIBuilder buildAnalyticsURI(String friendlyDescription, String url, Optional<String> visitorId) throws URISyntaxException {
        return this.buildBaseURI(visitorId).addParameter("action_name", friendlyDescription).addParameter("url", url).addParameter("cdt", DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss").print((ReadableInstant)DateTime.now())).addParameter("cookie", "false");
    }

    protected URI generateURI(String friendlyDescription, ContainerRequest request, Optional<CustomVariable> customVariable, Optional<String> visitorId) throws URISyntaxException {
        Optional<String> refererHeader;
        URIBuilder uriBuilder = this.buildAnalyticsURI(friendlyDescription, request.getRequestUri().toString(), visitorId);
        if (customVariable.isPresent()) {
            uriBuilder.addParameter("_cvar", customVariable.get().getJson());
        }
        if ((refererHeader = Optional.ofNullable(request.getHeaderString(REFERER))).isPresent()) {
            uriBuilder.addParameter("urlref", refererHeader.get());
            uriBuilder.addParameter("ref", refererHeader.get());
        }
        return uriBuilder.build();
    }

    private void reportToPiwik(String friendlyDescription, ContainerRequest context, Optional<CustomVariable> customVariable) {
        if (this.analyticsConfiguration.getEnabled()) {
            try {
                this.piwikClient.report(this.generateURI(friendlyDescription, context, customVariable, this.getVisitorId(context)), context);
            }
            catch (Exception e) {
                LOG.error("Analytics Reporting error", (Throwable)e);
            }
        }
    }
}

