/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.restclient;

import java.security.KeyManagementException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.ida.restclient.InsecureTrustManager;

public abstract class InsecureSSLSchemeRegistryBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(InsecureSSLSchemeRegistryBuilder.class);

    public static SchemeRegistry aConfigWithInsecureSSLSchemeRegistry(SSLContext sslContext, X509HostnameVerifier hostnameVerifier) {
        TrustManager[] trustManagers = InsecureSSLSchemeRegistryBuilder.getTrustManagers();
        try {
            sslContext.init(null, trustManagers, null);
        }
        catch (KeyManagementException e) {
            LOG.error("Error when trying to create SSL.", (Throwable)e);
            throw new RuntimeException(e);
        }
        Scheme http = new Scheme("http", 80, (SchemeSocketFactory)new PlainSocketFactory());
        Scheme https = new Scheme("https", 443, (SchemeSocketFactory)new SSLSocketFactory(sslContext, hostnameVerifier));
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(http);
        schemeRegistry.register(https);
        return schemeRegistry;
    }

    private static TrustManager[] getTrustManagers() {
        return new TrustManager[]{new InsecureTrustManager()};
    }
}

