/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.jerseyclient;

import io.dropwizard.util.Duration;
import java.util.ArrayList;
import java.util.List;
import uk.gov.ida.configuration.JerseyClientWithRetryBackoffConfiguration;

public class JerseyClientWithRetryBackoffHandlerConfigurationBuilder {
    private Duration timeout = Duration.microseconds((long)500L);
    private Duration backOffPeriod = Duration.microseconds((long)500L);
    private Duration connectionTimeout = Duration.microseconds((long)500L);
    private List<String> retryExceptions = new ArrayList<String>();
    private int numRetries = 0;
    private boolean chunkedEncodingEnabled = false;

    public static JerseyClientWithRetryBackoffHandlerConfigurationBuilder aJerseyClientWithRetryBackoffHandlerConfiguration() {
        return new JerseyClientWithRetryBackoffHandlerConfigurationBuilder();
    }

    public JerseyClientWithRetryBackoffConfiguration build() {
        return new TestJerseyClientWithRetryBackoffConfiguration(1, 128, this.timeout, this.connectionTimeout, Duration.hours((long)1L), 1024, 1024, this.numRetries, this.backOffPeriod, this.retryExceptions, this.chunkedEncodingEnabled);
    }

    public JerseyClientWithRetryBackoffHandlerConfigurationBuilder withTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public JerseyClientWithRetryBackoffHandlerConfigurationBuilder withRetryBackoffPeriod(Duration backOffPeriod) {
        this.backOffPeriod = backOffPeriod;
        return this;
    }

    public JerseyClientWithRetryBackoffHandlerConfigurationBuilder withRetryExceptionList(List<String> retryExceptions) {
        this.retryExceptions = retryExceptions;
        return this;
    }

    public JerseyClientWithRetryBackoffHandlerConfigurationBuilder withChunkedEncodingEnabled(boolean chunkedEncodingEnabled) {
        this.chunkedEncodingEnabled = chunkedEncodingEnabled;
        return this;
    }

    public JerseyClientWithRetryBackoffHandlerConfigurationBuilder withNumRetries(int numRetries) {
        this.numRetries = numRetries;
        return this;
    }

    public JerseyClientWithRetryBackoffHandlerConfigurationBuilder withConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    private static class TestJerseyClientWithRetryBackoffConfiguration
    extends JerseyClientWithRetryBackoffConfiguration {
        private TestJerseyClientWithRetryBackoffConfiguration(int minThreads, int maxThreads, Duration timeout, Duration connectionTimeout, Duration timeToLive, int maxConnections, int maxConnectionsPerRoute, int numRetries, Duration retryBackoffPeriod, List<String> exceptionNames, boolean chunkedEncodingEnabled) {
            this.setMinThreads(minThreads);
            this.setMaxThreads(maxThreads);
            this.setTimeout(timeout);
            this.setConnectionTimeout(connectionTimeout);
            this.setTimeToLive(timeToLive);
            this.setMaxConnections(maxConnections);
            this.setMaxConnectionsPerRoute(maxConnectionsPerRoute);
            this.setRetryBackoffPeriod(retryBackoffPeriod);
            this.setRetryExceptionNames(exceptionNames);
            this.setChunkedEncodingEnabled(chunkedEncodingEnabled);
            this.setRetries(numRetries);
        }
    }
}

