/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.cache;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.ida.cache.AssetCacheConfiguration;

public abstract class CacheControlFilter
implements Filter {
    private static final String CACHE_CONTROL_KEY = "Cache-Control";
    private static final String CACHE_CONTROL_NO_CACHE_VALUE = "no-cache, no-store";
    private static final String PRAGMA_KEY = "Pragma";
    private static final String PRAGMA_NO_CACHE_VALUE = "no-cache";
    private static final String MAX_AGE = "max-age";
    private static final Logger LOG = LoggerFactory.getLogger(CacheControlFilter.class);
    private final AssetCacheConfiguration configuration;

    public CacheControlFilter(AssetCacheConfiguration configuration) {
        this.configuration = configuration;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.configuration.shouldCacheAssets() && this.isCacheableAsset(((HttpServletRequest)request).getRequestURI())) {
            LOG.debug("Setting caching headers on " + ((HttpServletRequest)request).getServletPath());
            this.setCacheHeaders((HttpServletResponse)response);
        } else {
            LOG.debug("Setting no-cache headers on " + ((HttpServletRequest)request).getServletPath());
            this.setNoCacheHeaders((HttpServletResponse)response);
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    protected AssetCacheConfiguration getConfiguration() {
        return this.configuration;
    }

    protected abstract boolean isCacheableAsset(String var1);

    private void setCacheHeaders(HttpServletResponse response) {
        response.setHeader(CACHE_CONTROL_KEY, "max-age=" + this.configuration.getAssetsCacheDuration());
    }

    private void setNoCacheHeaders(HttpServletResponse response) {
        response.setHeader(CACHE_CONTROL_KEY, CACHE_CONTROL_NO_CACHE_VALUE);
        response.setHeader(PRAGMA_KEY, PRAGMA_NO_CACHE_VALUE);
    }
}

