/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.restclient;

import io.dropwizard.util.Duration;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.http.HttpRequest;
import org.apache.http.RequestLine;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.ida.restclient.TimeoutRequestRetryHandler;

public class TimeoutRequestRetryWithBackoffHandler
implements HttpRequestRetryHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TimeoutRequestRetryHandler.class);
    private final int numRetries;
    private final Duration retryBackoffPeriod;
    private final List<Class> defaultRetryExceptions = Arrays.asList(ConnectTimeoutException.class, SocketTimeoutException.class);
    private List<Class> retryExceptions;

    public TimeoutRequestRetryWithBackoffHandler(int numRetries, Duration retryBackoffPeriod) {
        this.numRetries = numRetries;
        this.retryBackoffPeriod = retryBackoffPeriod;
        this.retryExceptions = this.defaultRetryExceptions;
    }

    public TimeoutRequestRetryWithBackoffHandler(int numRetries, Duration retryBackoffPeriod, List<String> retryExceptionNames) {
        this(numRetries, retryBackoffPeriod);
        if (this.retryExceptions != null) {
            this.retryExceptions = new ArrayList<Class>();
            for (String className : retryExceptionNames) {
                try {
                    this.retryExceptions.add(Class.forName(className));
                }
                catch (ClassNotFoundException e) {
                    LOG.error(MessageFormat.format("Class {0} specified in exception class name list does not exist", className));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retryRequest(IOException e, int executionCount, HttpContext httpContext) {
        block4: {
            LOG.info("Retry request made.", (Throwable)e);
            if (!this.retryExceptions.contains(e.getClass()) || executionCount > this.numRetries) break block4;
            String uri = null;
            String httpMethod = null;
            try {
                HttpCoreContext coreContext = HttpCoreContext.adapt((HttpContext)httpContext);
                HttpRequest request = coreContext.getRequest();
                RequestLine requestLine = request.getRequestLine();
                uri = requestLine.getUri();
                httpMethod = requestLine.getMethod();
                LOG.info(MessageFormat.format("Backing off for {0} milliseconds before retry", this.retryBackoffPeriod));
                Thread.sleep((long)executionCount * this.retryBackoffPeriod.toMilliseconds());
            }
            catch (InterruptedException ex) {
                try {
                    LOG.error("Thread interrupted during backoff period");
                }
                catch (Throwable throwable) {
                    LOG.info(MessageFormat.format("Retrying {0} of {1}, to {2} / {3}", executionCount, this.numRetries, httpMethod, uri));
                    throw throwable;
                }
                LOG.info(MessageFormat.format("Retrying {0} of {1}, to {2} / {3}", executionCount, this.numRetries, httpMethod, uri));
            }
            LOG.info(MessageFormat.format("Retrying {0} of {1}, to {2} / {3}", executionCount, this.numRetries, httpMethod, uri));
            return true;
        }
        return false;
    }
}

