/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.restclient;

import java.io.IOException;
import java.text.MessageFormat;
import org.apache.http.HttpRequest;
import org.apache.http.RequestLine;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutRequestRetryHandler
implements HttpRequestRetryHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TimeoutRequestRetryHandler.class);
    private final int numRetries;

    public TimeoutRequestRetryHandler(int numRetries) {
        this.numRetries = numRetries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retryRequest(IOException e, int executionCount, HttpContext httpContext) {
        block2: {
            LOG.info("Retry request made.", (Throwable)e);
            if (!(e instanceof ConnectTimeoutException) || executionCount > this.numRetries) break block2;
            String uri = null;
            String httpMethod = null;
            try {
                HttpCoreContext coreContext = HttpCoreContext.adapt((HttpContext)httpContext);
                HttpRequest request = coreContext.getRequest();
                RequestLine requestLine = request.getRequestLine();
                uri = requestLine.getUri();
                httpMethod = requestLine.getMethod();
            }
            catch (Throwable throwable) {
                LOG.info(MessageFormat.format("Retrying {0} of {1}, to {2} / {3}", executionCount, this.numRetries, httpMethod, uri));
                throw throwable;
            }
            LOG.info(MessageFormat.format("Retrying {0} of {1}, to {2} / {3}", executionCount, this.numRetries, httpMethod, uri));
            return true;
        }
        return false;
    }
}

