/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.restclient;

import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SecureSSLSchemeRegistryBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(SecureSSLSchemeRegistryBuilder.class);
    public static final SecureRandom SECURE_RANDOM = new SecureRandom();

    public static SchemeRegistry aConfigWithSecureSSLSchemeRegistry(SSLContext sslContext, KeyStore trustStore, X509HostnameVerifier hostnameVerifier) {
        TrustManager[] trustManagers = SecureSSLSchemeRegistryBuilder.getTrustManagers(trustStore);
        try {
            sslContext.init(null, trustManagers, SECURE_RANDOM);
        }
        catch (KeyManagementException e) {
            LOG.error("Error when trying to create SSL.", (Throwable)e);
            throw new RuntimeException(e);
        }
        Scheme https = new Scheme("https", 443, (SchemeSocketFactory)new SSLSocketFactory(sslContext, hostnameVerifier));
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(https);
        return schemeRegistry;
    }

    private static TrustManager[] getTrustManagers(KeyStore trustStore) {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            return trustManagerFactory.getTrustManagers();
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

