/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.bundles;

import ch.qos.logback.classic.LoggerContext;
import io.dropwizard.Bundle;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import org.slf4j.LoggerFactory;
import uk.gov.ida.configuration.ServiceNameConfiguration;
import uk.gov.ida.dropwizard.logstash.LogstashBundle;
import uk.gov.ida.filters.ClearMdcAfterRequestFilter;

public class LoggingBundle
implements ConfiguredBundle<ServiceNameConfiguration> {
    public void initialize(Bootstrap<?> bootstrap) {
        bootstrap.addBundle((Bundle)new LogstashBundle());
    }

    public void run(ServiceNameConfiguration configuration, Environment environment) throws Exception {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        context.putProperty("service-name", configuration.getServiceName());
        environment.servlets().addFilter("fresh-mdc-filter", ClearMdcAfterRequestFilter.class).addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), false, new String[]{"/*"});
    }
}

