/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.dropwizard.logstash;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.net.SyslogOutputStream;
import java.io.IOException;
import uk.gov.ida.dropwizard.logstash.SyslogEventFormatter;

public class SyslogAppender
extends AppenderBase<ILoggingEvent> {
    private final SyslogEventFormatter eventFormatter;
    private final SyslogOutputStream outputStream;

    public SyslogAppender(SyslogEventFormatter eventFormatter, SyslogOutputStream outputStream) {
        this.eventFormatter = eventFormatter;
        this.outputStream = outputStream;
    }

    protected void append(ILoggingEvent eventObject) {
        if (!this.isStarted()) {
            return;
        }
        String formattedEvent = this.eventFormatter.format(eventObject);
        try {
            this.outputStream.write(formattedEvent.getBytes());
            this.outputStream.flush();
        }
        catch (IOException e) {
            this.addError("Failed to send message: " + formattedEvent, e);
        }
    }
}

