/*
 * Decompiled with CFR 0.152.
 */
package keystore;

import com.google.common.base.Throwables;
import helpers.ManagedFileResource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import keystore.CertificateEntry;
import keystore.KeyEntry;
import keystore.PrivateKeyFactory;
import keystore.X509CertificateFactory;

public class KeyStoreResource
implements ManagedFileResource {
    private static final String password = "password";
    private final File file;
    private final List<KeyEntry> keys;
    private final List<CertificateEntry> certificates;
    private KeyStore keyStore;

    public KeyStoreResource(File file, List<KeyEntry> keys, List<CertificateEntry> certificates) {
        this.file = file;
        this.keys = keys;
        this.certificates = certificates;
    }

    public String getPassword() {
        return password;
    }

    public File getFile() {
        return this.file;
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    @Override
    public void create() {
        this.loadKeyStore();
        this.setKeys();
        this.setCertificates();
        this.writeKeyStore();
    }

    @Override
    public void delete() {
        this.file.delete();
    }

    private KeyStore loadKeyStore() {
        try {
            this.keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            this.keyStore.load(null, null);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return this.keyStore;
    }

    private void setKeys() {
        X509CertificateFactory x509CertificateFactory = new X509CertificateFactory();
        PrivateKeyFactory privateKeyFactory = new PrivateKeyFactory();
        this.keys.stream().forEach(entry -> {
            Certificate[] x509Certificates = (X509Certificate[])Arrays.asList(entry.getCertificates()).stream().map(x509CertificateFactory::createCertificate).toArray(X509Certificate[]::new);
            PrivateKey key = privateKeyFactory.createPrivateKey(entry.getKey().getBytes());
            try {
                this.keyStore.setKeyEntry(entry.getAlias(), key, this.getPassword().toCharArray(), x509Certificates);
            }
            catch (KeyStoreException e) {
                throw Throwables.propagate((Throwable)e);
            }
        });
    }

    private void setCertificates() {
        X509CertificateFactory x509CertificateFactory = new X509CertificateFactory();
        this.certificates.stream().forEach(entry -> {
            X509Certificate x509Certificate = x509CertificateFactory.createCertificate(entry.getCertificate());
            try {
                this.keyStore.setCertificateEntry(entry.getAlias(), x509Certificate);
            }
            catch (KeyStoreException e) {
                throw Throwables.propagate((Throwable)e);
            }
        });
    }

    private void writeKeyStore() {
        try (FileOutputStream fos = new FileOutputStream(this.getFile());){
            this.keyStore.store(fos, this.getPassword().toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

