/*
 * Decompiled with CFR 0.152.
 */
package httpstub;

import com.google.common.base.Throwables;
import httpstub.ReceivedRequest;
import httpstub.RecordedRequest;
import httpstub.RegisteredResponse;
import httpstub.RequestAndResponse;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public abstract class StubHandler
extends AbstractHandler {
    protected void respondWith(Request baseRequest, HttpServletResponse response, RegisteredResponse registeredResponse) {
        response.setStatus(registeredResponse.getStatus());
        for (Map.Entry<String, String> headerEntry : registeredResponse.getHeaders().entrySet()) {
            response.setHeader(headerEntry.getKey(), headerEntry.getValue());
        }
        response.setContentType(registeredResponse.getContentType());
        try {
            response.getWriter().append(registeredResponse.getBody());
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        baseRequest.setHandled(true);
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
        RecordedRequest recordedRequest = new RecordedRequest(baseRequest);
        this.recordRequest(recordedRequest);
        this.findResponse(recordedRequest).ifPresent(requestAndResponse -> {
            requestAndResponse.addCall();
            this.respondWith(baseRequest, response, requestAndResponse.getResponse());
        });
    }

    protected abstract Optional<RequestAndResponse> findResponse(ReceivedRequest var1);

    protected abstract void recordRequest(RecordedRequest var1);
}

