/*
 * Decompiled with CFR 0.152.
 */
package httpstub;

import com.fasterxml.jackson.core.JsonProcessingException;
import httpstub.AbstractHttpStub;
import httpstub.ExpectedRequest;
import httpstub.HttpStub;
import httpstub.RecordedRequest;
import httpstub.RegisteredResponse;
import httpstub.RequestAndResponse;
import httpstub.builders.ExpectedRequestBuilder;
import java.net.URI;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class HttpStubRule
implements TestRule {
    private final AbstractHttpStub httpStub;

    public HttpStubRule() {
        this(new HttpStub());
    }

    protected HttpStubRule(AbstractHttpStub httpStub) {
        this.httpStub = httpStub;
        this.httpStub.start();
    }

    public int getPort() {
        return this.httpStub.getHttpPort();
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    base.evaluate();
                }
                finally {
                    HttpStubRule.this.httpStub.stop();
                }
            }
        };
    }

    public URI uri(String path) {
        return this.baseUri().path(path).build(new Object[0]);
    }

    public UriBuilder baseUri() {
        return UriBuilder.fromUri((String)"http://localhost").port(this.getPort());
    }

    public void register(String path, int responseStatus) {
        RequestAndResponse requestAndResponse = ExpectedRequestBuilder.expectRequest().withPath(path).andWillRespondWith().withStatus(responseStatus).build();
        this.register(requestAndResponse);
    }

    public void register(String path, int responseStatus, String contentType, String responseBody) throws JsonProcessingException {
        RequestAndResponse requestAndResponse = ExpectedRequestBuilder.expectRequest().withPath(path).andWillRespondWith().withStatus(responseStatus).withContentType(contentType).withBody(responseBody).build();
        this.register(requestAndResponse);
    }

    public void register(String path, int status, Object responseEntity) throws JsonProcessingException {
        RequestAndResponse requestAndResponse = ExpectedRequestBuilder.expectRequest().withPath(path).andWillRespondWith().withStatus(status).withBody(responseEntity).build();
        this.register(requestAndResponse);
    }

    public void register(String path, RegisteredResponse registeredResponse) {
        this.register(ExpectedRequestBuilder.expectRequest().withPath(path).build(), registeredResponse);
    }

    public void register(ExpectedRequest expectedRequest, RegisteredResponse registeredResponse) {
        RequestAndResponse requestAndResponse = new RequestAndResponse(expectedRequest, registeredResponse);
        this.register(requestAndResponse);
    }

    public void register(RequestAndResponse requestAndResponse) {
        this.httpStub.register(requestAndResponse);
    }

    public void reset() {
        this.httpStub.reset();
    }

    public int getCountOfRequestsTo(String path) {
        return this.httpStub.getCountOfRequestsTo(path);
    }

    public int getCountOfRequests() {
        return this.httpStub.getCountOfRequests();
    }

    public RecordedRequest getLastRequest() {
        return this.httpStub.getLastRequest();
    }

    public List<RecordedRequest> getRecordedRequest() {
        return this.httpStub.getRecordedRequests();
    }
}

