/*
 * Decompiled with CFR 0.152.
 */
package helpers;

import com.google.common.base.Throwables;
import helpers.TemporaryFileResource;
import java.io.File;
import java.io.IOException;

public class TemporaryFileResourceBuilder {
    private byte[] content;
    private File file;

    private TemporaryFileResourceBuilder() {
    }

    public static TemporaryFileResourceBuilder aTemporaryFileResource() {
        return new TemporaryFileResourceBuilder();
    }

    public TemporaryFileResourceBuilder file(File file) {
        this.file = file;
        return this;
    }

    public TemporaryFileResourceBuilder content(byte[] content) {
        this.content = content;
        return this;
    }

    public TemporaryFileResourceBuilder content(String content) {
        this.content = content.getBytes();
        return this;
    }

    public TemporaryFileResource build() {
        if (this.file == null) {
            try {
                this.file = File.createTempFile("test-file", null, null);
                this.file.deleteOnExit();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return new TemporaryFileResource(this.file, this.content);
    }
}

