/*
 * Decompiled with CFR 0.152.
 */
package stroom.proxy;

public enum StroomStatusCode {
    OK(200, 0, "OK", "Post of data successful"),
    FEED_MUST_BE_SPECIFIED(406, 100, "Feed must be specified", "You must provide Feed as a header argument in the request"),
    FEED_IS_NOT_DEFINED(406, 101, "Feed is not defined", "The feed you have provided is not known within Stroom"),
    FEED_IS_NOT_SET_TO_RECEIVED_DATA(406, 110, "Feed is not set to receive data", "The feed you have provided has not been setup to receive data"),
    UNKNOWN_COMPRESSION(406, 200, "Unknown compression", "Compression argument must be one of ZIP, GZIP and NONE"),
    CLIENT_CERTIFICATE_REQUIRED(401, 300, "Client Certificate Required", "The feed you have provided requires a client HTTPS certificate to send data"),
    CLIENT_CERTIFICATE_NOT_AUTHORISED(403, 310, "Client Certificate not authorised", "The feed you have provided does not allow your client certificate to send data"),
    COMPRESSED_STREAM_INVALID(500, 400, "Compressed stream invalid", "The stream of data sent does not form a valid compressed file.  Maybe it terminated unexpectedly or is corrupt."),
    UNKNOWN_ERROR(500, 999, "Unknown error", "An unknown unexpected error occurred");

    private final String message;
    private final String reason;
    private final int code;
    private final int httpCode;

    public static StroomStatusCode getStroomStatusCode(int code) {
        for (StroomStatusCode stroomStatusCode : StroomStatusCode.values()) {
            if (stroomStatusCode.getCode() != code) continue;
            return stroomStatusCode;
        }
        return UNKNOWN_ERROR;
    }

    private StroomStatusCode(int httpCode, int code, String message, String reason) {
        this.httpCode = httpCode;
        this.code = code;
        this.message = message;
        this.reason = reason;
    }

    public int getHttpCode() {
        return this.httpCode;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getReason() {
        return this.reason;
    }

    public String toString() {
        return this.httpCode + " - " + this.code + " - " + this.message;
    }

    public static void main(String[] args) {
        System.out.println("{| class=\"wikitable\"");
        System.out.println("!HTTP Status!!Stroom-Status!!Message!!Reason");
        for (StroomStatusCode stroomStatusCode : StroomStatusCode.values()) {
            System.out.println("|-");
            System.out.println("|" + stroomStatusCode.getHttpCode() + "||" + stroomStatusCode.getCode() + "||" + stroomStatusCode.getMessage() + "||" + stroomStatusCode.getReason());
        }
        System.out.println("|}");
    }
}

