/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.dwp.tls;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SealedObject;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.dwp.crypto.SecureStrings;
import uk.gov.dwp.tls.TLSGeneralException;

public class TLSConnectionBuilder {
    private static final Logger LOG = LoggerFactory.getLogger((String)TLSConnectionBuilder.class.getName());
    private final SecureStrings secureCipher = new SecureStrings();
    private String trustStoreFile;
    private SealedObject trustStorePassword;
    private SealedObject keyStorePassword;
    private String keyStoreFile;

    public TLSConnectionBuilder(String trustStoreFilename, String trustStorePassword, String keyStoreFilename, String keyStorePassword) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IOException, IllegalBlockSizeException {
        this.trustStorePassword = this.secureCipher.sealString(trustStorePassword);
        this.keyStorePassword = this.secureCipher.sealString(keyStorePassword);
        this.trustStoreFile = trustStoreFilename;
        this.keyStoreFile = keyStoreFilename;
    }

    public TLSConnectionBuilder(String trustStoreFilename, String trustStorePassword) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IOException, IllegalBlockSizeException {
        this.trustStorePassword = this.secureCipher.sealString(trustStorePassword);
        this.trustStoreFile = trustStoreFilename;
    }

    public SSLContext createAndPopulateContext() throws NoSuchAlgorithmException, KeyStoreException, TLSGeneralException, IOException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        TrustManagerFactory trustStoreManager = null;
        KeyManagerFactory keyStoreManager = null;
        KeyStore clientKeyStore = null;
        KeyStore trustStore = null;
        if (this.getTrustStoreFile() != null && this.getTrustStoreFile().trim().length() > 0) {
            trustStoreManager = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(new FileInputStream(this.checkFile(this.getTrustStoreFile())), this.getTrustStorePassword().toCharArray());
            trustStoreManager.init(trustStore);
        } else {
            LOG.info("Cannot use TRUSTSTORE, proceeding without trust anchors.  It is blank or null");
        }
        if (this.getKeyStoreFile() != null && this.getKeyStoreFile().trim().length() > 0) {
            keyStoreManager = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            clientKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            clientKeyStore.load(new FileInputStream(this.checkFile(this.getKeyStoreFile())), this.getKeyStorePassword().toCharArray());
            keyStoreManager.init(clientKeyStore, this.getKeyStorePassword().toCharArray());
        } else {
            LOG.info("Cannot use KEYSTORE, proceeding without keystore.  It is blank or null");
        }
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(clientKeyStore == null ? null : keyStoreManager.getKeyManagers(), trustStore == null ? null : trustStoreManager.getTrustManagers(), new SecureRandom());
        return sslContext;
    }

    public CloseableHttpClient configureSSLConnection() throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, TLSGeneralException {
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setSSLContext(this.createAndPopulateContext());
        return builder.build();
    }

    private File checkFile(String fileName) throws TLSGeneralException {
        File fileObject = new File(fileName);
        if (!fileObject.exists()) {
            throw new TLSGeneralException(String.format("%s does not exist", fileName));
        }
        return fileObject;
    }

    public String getTrustStoreFile() {
        return this.trustStoreFile;
    }

    public String getTrustStorePassword() {
        return this.secureCipher.revealString(this.trustStorePassword);
    }

    public String getKeyStorePassword() {
        return this.secureCipher.revealString(this.keyStorePassword);
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }
}

