/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.dstl.json.serialization.pattern;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.regex.Pattern;

public class PatternSerializer
extends StdSerializer<Pattern> {
    public PatternSerializer() {
        this(null);
    }

    protected PatternSerializer(Class<Pattern> t) {
        super(t);
    }

    public void serialize(Pattern pattern, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (this.checkFlagSet(pattern.flags(), 1)) {
            sb.append('d');
        }
        if (this.checkFlagSet(pattern.flags(), 2)) {
            sb.append('i');
        }
        if (this.checkFlagSet(pattern.flags(), 4)) {
            sb.append('x');
        }
        if (this.checkFlagSet(pattern.flags(), 8)) {
            sb.append('m');
        }
        if (this.checkFlagSet(pattern.flags(), 32)) {
            sb.append('s');
        }
        if (this.checkFlagSet(pattern.flags(), 64)) {
            sb.append('u');
        }
        if (sb.length() > 0) {
            jsonGenerator.writeString("(?" + sb.toString() + ")" + pattern.pattern().replaceAll("\\(\\?[dixmsu]+\\)", ""));
        } else {
            jsonGenerator.writeString(pattern.pattern());
        }
    }

    private boolean checkFlagSet(int flags, int flag) {
        return (flags & flag) == flag;
    }
}

