/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.dstl.json.serialization.pattern;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternDeserializer
extends StdDeserializer<Pattern> {
    public PatternDeserializer() {
        this(null);
    }

    protected PatternDeserializer(Class<?> vc) {
        super(vc);
    }

    public Pattern deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        int flags = 0;
        String jsonString = jsonParser.getText();
        Matcher m = Pattern.compile("\\(\\?([dixmsu]+)\\)").matcher(jsonString);
        while (m.find()) {
            String sFlags = m.group(1);
            if (sFlags.contains("d") && !this.checkFlagSet(flags, 1)) {
                ++flags;
            }
            if (sFlags.contains("i") && !this.checkFlagSet(flags, 2)) {
                flags += 2;
            }
            if (sFlags.contains("x") && !this.checkFlagSet(flags, 4)) {
                flags += 4;
            }
            if (sFlags.contains("m") && !this.checkFlagSet(flags, 8)) {
                flags += 8;
            }
            if (sFlags.contains("s") && !this.checkFlagSet(flags, 32)) {
                flags += 32;
            }
            if (!sFlags.contains("u") || this.checkFlagSet(flags, 64)) continue;
            flags += 64;
        }
        return Pattern.compile(jsonString.replaceAll("\\(\\?[dixmsu]+\\)", ""), flags);
    }

    private boolean checkFlagSet(int flags, int flag) {
        return (flags & flag) == flag;
    }
}

