/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.dstl.baleen.utils;

import io.annot8.api.pipelines.NoOpOrderer;
import io.annot8.api.pipelines.PipelineOrderer;
import uk.gov.dstl.baleen.exceptions.BadRequestException;
import uk.gov.dstl.baleen.exceptions.ComponentNotFoundException;

public class Annot8Utils {
    public static PipelineOrderer getOrderer(String ordererClass) {
        if (NoOpOrderer.class.getName().equals(ordererClass)) {
            return NoOpOrderer.getInstance();
        }
        try {
            Class<?> clazz = Class.forName(ordererClass);
            return (PipelineOrderer)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new ComponentNotFoundException(ordererClass);
        }
        catch (ClassCastException e) {
            throw new BadRequestException("Class is not an instance of PipelineOrderer");
        }
        catch (NoSuchMethodException e) {
            throw new BadRequestException("Unable to instantiate Orderer - must have a no argument constructor");
        }
        catch (Exception e) {
            throw new BadRequestException("Unable to instantiate Orderer", e);
        }
    }
}

