/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.dstl.baleen.services;

import io.annot8.api.components.Annot8ComponentDescriptor;
import io.annot8.api.data.Content;
import io.annot8.api.pipelines.PipelineOrderer;
import io.annot8.implementations.reference.stores.DefaultAnnotationStore;
import io.annot8.implementations.reference.stores.DefaultGroupStore;
import io.annot8.implementations.support.factories.ContentBuilderFactory;
import io.annot8.implementations.support.registries.Annot8ComponentRegistry;
import io.annot8.implementations.support.registries.ContentBuilderFactoryRegistry;
import io.annot8.implementations.support.registries.SimpleContentBuilderFactoryRegistry;
import io.annot8.implementations.support.stores.AnnotationStoreFactory;
import io.annot8.implementations.support.stores.GroupStoreFactory;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class Annot8ComponentService {
    private Annot8ComponentRegistry registry;
    private ContentBuilderFactoryRegistry contentBuilderFactoryRegistry;
    private Set<Class<? extends PipelineOrderer>> orderers;
    private static final AnnotationStoreFactory annotationStoreFactory = DefaultAnnotationStore::new;
    private static final GroupStoreFactory groupStoreFactory = DefaultGroupStore::new;
    private static final Logger LOGGER = LoggerFactory.getLogger(Annot8ComponentService.class);

    @PostConstruct
    public void scan() {
        LOGGER.info("Performing scan for Annot8 components");
        HashSet components = new HashSet();
        this.contentBuilderFactoryRegistry = new SimpleContentBuilderFactoryRegistry();
        this.orderers = new HashSet<Class<? extends PipelineOrderer>>();
        try (ScanResult scanResult = new ClassGraph().enableClassInfo().enableAnnotationInfo().scan();){
            scanResult.getClassesImplementing(Annot8ComponentDescriptor.class.getName()).filter(cif -> !cif.isAbstract()).loadClasses().forEach(c -> components.add(c));
            scanResult.getClassesImplementing(PipelineOrderer.class.getName()).filter(cif -> !cif.isAbstract()).loadClasses().forEach(c -> this.orderers.add((Class<? extends PipelineOrderer>)c));
            ArrayList content = new ArrayList();
            scanResult.getClassesImplementing(Content.class.getName()).filter(ClassInfo::isInterface).loadClasses().forEach(c -> content.add(c));
            scanResult.getClassesImplementing(ContentBuilderFactory.class.getName()).filter(cif -> !cif.isAbstract()).loadClasses().forEach(c -> {
                ContentBuilderFactory cbf;
                try {
                    cbf = this.instantiateContentBuilderFactory((Class<? extends ContentBuilderFactory>)c);
                }
                catch (Exception e) {
                    LOGGER.warn("Unable to instantiate ContentBuilderFactory {}", (Object)c.getName(), (Object)e);
                    return;
                }
                for (Class cc : content) {
                    if (!cc.isAssignableFrom(cbf.getContentClass())) continue;
                    LOGGER.info("Registering {} as a factory for {}", (Object)c.getName(), (Object)cc.getName());
                    this.contentBuilderFactoryRegistry.register(cc, cbf);
                }
            });
        }
        this.registry = new Annot8ComponentRegistry(components);
    }

    public Annot8ComponentRegistry getRegistry() {
        return this.registry;
    }

    public ContentBuilderFactoryRegistry getContentBuilderFactoryRegistry() {
        return this.contentBuilderFactoryRegistry;
    }

    public Set<Class<? extends PipelineOrderer>> getOrderers() {
        return this.orderers;
    }

    private ContentBuilderFactory instantiateContentBuilderFactory(Class<? extends ContentBuilderFactory> c) throws Exception {
        ArrayList<Object> availableParameters = new ArrayList<Object>();
        availableParameters.add(annotationStoreFactory);
        availableParameters.add(groupStoreFactory);
        Constructor<?> bestConstructor = null;
        List bestParameters = Collections.emptyList();
        for (Constructor<?> constructor : c.getConstructors()) {
            if (constructor.getParameterCount() == 0 && bestConstructor == null) {
                bestConstructor = constructor;
                bestParameters = Collections.emptyList();
                continue;
            }
            if (bestConstructor != null && constructor.getParameterCount() <= bestConstructor.getParameterCount()) continue;
            ArrayList parameters = new ArrayList();
            for (Class<?> parameterType : constructor.getParameterTypes()) {
                boolean matchFound = false;
                for (Object e : availableParameters) {
                    if (!parameterType.isInstance(e)) continue;
                    parameters.add(e);
                    matchFound = true;
                    break;
                }
                if (!matchFound) break;
            }
            if (parameters.size() != constructor.getParameterCount()) continue;
            bestConstructor = constructor;
            bestParameters = parameters;
        }
        if (bestConstructor == null) {
            throw new NoSuchMethodException("Could not find a suitable constructor");
        }
        LOGGER.debug("Using constructor {} to instantiate class {}", bestConstructor, (Object)c.getName());
        return (ContentBuilderFactory)bestConstructor.newInstance(bestParameters.toArray());
    }
}

