/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.dstl.baleen.logging;

import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;
import uk.gov.dstl.baleen.logging.BaleenLogEntry;

public class BaleenLogger
implements Logger {
    private final String name;
    private final Logger logger;
    private final Collection<BaleenLogEntry> logEntries;

    public BaleenLogger(String name, Collection<BaleenLogEntry> logEntries) {
        this.name = name;
        this.logger = LoggerFactory.getLogger((String)name);
        this.logEntries = logEntries;
    }

    public String getName() {
        return this.name;
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public void trace(String msg) {
        if (this.isTraceEnabled()) {
            this.logger.trace(msg);
            this.logEntries.add(new BaleenLogEntry(Level.TRACE, msg, this.name));
        }
    }

    public void trace(String format, Object arg) {
        if (this.isTraceEnabled()) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
            this.logger.trace(ft.getMessage(), ft.getThrowable());
            this.logEntries.add(new BaleenLogEntry(Level.TRACE, ft, this.name));
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.logger.trace(ft.getMessage(), ft.getThrowable());
            this.logEntries.add(new BaleenLogEntry(Level.TRACE, ft, this.name));
        }
    }

    public void trace(String format, Object ... arguments) {
        if (this.isTraceEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
            this.logger.trace(ft.getMessage(), ft.getThrowable());
            this.logEntries.add(new BaleenLogEntry(Level.TRACE, ft, this.name));
        }
    }

    public void trace(String msg, Throwable t) {
        if (this.isTraceEnabled()) {
            this.logger.trace(msg, t);
            this.logEntries.add(new BaleenLogEntry(Level.TRACE, msg, t, this.name));
        }
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.logger.isTraceEnabled(marker);
    }

    public void trace(Marker marker, String msg) {
        if (this.isTraceEnabled(marker)) {
            this.logger.trace(marker, msg);
            this.logEntries.add(new BaleenLogEntry(Level.TRACE, msg, this.name));
        }
    }

    public void trace(Marker marker, String format, Object arg) {
        if (this.isTraceEnabled(marker)) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
            this.logger.trace(marker, ft.getMessage(), ft.getThrowable());
            this.logEntries.add(new BaleenLogEntry(Level.TRACE, ft, this.name));
        }
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled(marker)) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.logger.trace(marker, ft.getMessage(), ft.getThrowable());
            this.logEntries.add(new BaleenLogEntry(Level.TRACE, ft, this.name));
        }
    }

    public void trace(Marker marker, String format, Object ... arguments) {
        if (this.isTraceEnabled(marker)) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
            this.logger.trace(marker, ft.getMessage(), ft.getThrowable());
            this.logEntries.add(new BaleenLogEntry(Level.TRACE, ft, this.name));
        }
    }

    public void trace(Marker marker, String msg, Throwable t) {
        if (this.isTraceEnabled(marker)) {
            this.logger.trace(marker, msg);
            this.logEntries.add(new BaleenLogEntry(Level.TRACE, msg, t, this.name));
        }
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            this.logger.debug(msg);
            this.logEntries.add(new BaleenLogEntry(Level.DEBUG, msg, this.name));
        }
    }

    public void debug(String format, Object arg) {
        if (this.isDebugEnabled()) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
            this.logger.debug(ft.getMessage(), ft.getThrowable());
            this.logEntries.add(new BaleenLogEntry(Level.DEBUG, ft, this.name));
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.logger.debug(ft.getMessage(), ft.getThrowable());
            this.logEntries.add(new BaleenLogEntry(Level.DEBUG, ft, this.name));
        }
    }

    public void debug(String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
            this.logger.debug(ft.getMessage(), ft.getThrowable());
            this.logEntries.add(new BaleenLogEntry(Level.DEBUG, ft, this.name));
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.isDebugEnabled()) {
            this.logger.debug(msg, t);
            this.logEntries.add(new BaleenLogEntry(Level.DEBUG, msg, t, this.name));
        }
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.logger.isDebugEnabled(marker);
    }

    public void debug(Marker marker, String msg) {
        if (this.isDebugEnabled()) {
            this.logger.debug(marker, msg);
            this.logEntries.add(new BaleenLogEntry(Level.DEBUG, msg, this.name));
        }
    }

    public void debug(Marker marker, String format, Object arg) {
        if (this.isDebugEnabled()) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
            this.logger.debug(marker, ft.getMessage(), ft.getThrowable());
            this.logEntries.add(new BaleenLogEntry(Level.DEBUG, ft, this.name));
        }
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.logger.debug(marker, ft.getMessage(), ft.getThrowable());
            this.logEntries.add(new BaleenLogEntry(Level.DEBUG, ft, this.name));
        }
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
            this.logger.debug(marker, ft.getMessage(), ft.getThrowable());
            this.logEntries.add(new BaleenLogEntry(Level.DEBUG, ft, this.name));
        }
    }

    public void debug(Marker marker, String msg, Throwable t) {
        if (this.isDebugEnabled()) {
            this.logger.debug(marker, msg, t);
            this.logEntries.add(new BaleenLogEntry(Level.DEBUG, msg, t, this.name));
        }
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void info(String msg) {
        if (this.isInfoEnabled()) {
            this.logger.info(msg);
            this.logEntries.add(new BaleenLogEntry(Level.INFO, msg, this.name));
        }
    }

    public void info(String format, Object arg) {
        if (this.isInfoEnabled()) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
            this.logger.info(ft.getMessage(), ft.getThrowable());
            this.logEntries.add(new BaleenLogEntry(Level.INFO, ft, this.name));
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.logger.info(ft.getMessage(), ft.getThrowable());
            this.logEntries.add(new BaleenLogEntry(Level.INFO, ft, this.name));
        }
    }

    public void info(String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
            this.logger.info(ft.getMessage(), ft.getThrowable());
            this.logEntries.add(new BaleenLogEntry(Level.INFO, ft, this.name));
        }
    }

    public void info(String msg, Throwable t) {
        if (this.isInfoEnabled()) {
            this.logger.info(msg, t);
            this.logEntries.add(new BaleenLogEntry(Level.INFO, msg, t, this.name));
        }
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.logger.isInfoEnabled(marker);
    }

    public void info(Marker marker, String msg) {
        if (this.isInfoEnabled()) {
            this.logger.info(marker, msg);
            this.logEntries.add(new BaleenLogEntry(Level.INFO, msg, this.name));
        }
    }

    public void info(Marker marker, String format, Object arg) {
        if (this.isInfoEnabled()) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
            this.logger.info(marker, ft.getMessage(), ft.getThrowable());
            this.logEntries.add(new BaleenLogEntry(Level.INFO, ft, this.name));
        }
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.logger.info(marker, ft.getMessage(), ft.getThrowable());
            this.logEntries.add(new BaleenLogEntry(Level.INFO, ft, this.name));
        }
    }

    public void info(Marker marker, String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
            this.logger.info(marker, ft.getMessage(), ft.getThrowable());
            this.logEntries.add(new BaleenLogEntry(Level.INFO, ft, this.name));
        }
    }

    public void info(Marker marker, String msg, Throwable t) {
        if (this.isInfoEnabled()) {
            this.logger.info(marker, msg, t);
            this.logEntries.add(new BaleenLogEntry(Level.INFO, msg, t, this.name));
        }
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public void warn(String msg) {
        if (this.isWarnEnabled()) {
            this.logger.warn(msg);
            this.logEntries.add(new BaleenLogEntry(Level.WARN, msg, this.name));
        }
    }

    public void warn(String format, Object arg) {
        if (this.isWarnEnabled()) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
            this.logger.warn(ft.getMessage(), ft.getThrowable());
            this.logEntries.add(new BaleenLogEntry(Level.WARN, ft, this.name));
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.logger.warn(ft.getMessage(), ft.getThrowable());
            this.logEntries.add(new BaleenLogEntry(Level.WARN, ft, this.name));
        }
    }

    public void warn(String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
            this.logger.warn(ft.getMessage(), ft.getThrowable());
            this.logEntries.add(new BaleenLogEntry(Level.WARN, ft, this.name));
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            this.logger.warn(msg, t);
            this.logEntries.add(new BaleenLogEntry(Level.WARN, msg, t, this.name));
        }
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.logger.isWarnEnabled(marker);
    }

    public void warn(Marker marker, String msg) {
        if (this.isWarnEnabled()) {
            this.logger.warn(marker, msg);
            this.logEntries.add(new BaleenLogEntry(Level.WARN, msg, this.name));
        }
    }

    public void warn(Marker marker, String format, Object arg) {
        if (this.isWarnEnabled()) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
            this.logger.warn(marker, ft.getMessage(), ft.getThrowable());
            this.logEntries.add(new BaleenLogEntry(Level.WARN, ft, this.name));
        }
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.logger.warn(marker, ft.getMessage(), ft.getThrowable());
            this.logEntries.add(new BaleenLogEntry(Level.WARN, ft, this.name));
        }
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
            this.logger.warn(marker, ft.getMessage(), ft.getThrowable());
            this.logEntries.add(new BaleenLogEntry(Level.WARN, ft, this.name));
        }
    }

    public void warn(Marker marker, String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            this.logger.warn(marker, msg, t);
            this.logEntries.add(new BaleenLogEntry(Level.WARN, msg, t, this.name));
        }
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public void error(String msg) {
        if (this.isErrorEnabled()) {
            this.logger.error(msg);
            this.logEntries.add(new BaleenLogEntry(Level.ERROR, msg, this.name));
        }
    }

    public void error(String format, Object arg) {
        if (this.isErrorEnabled()) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
            this.logger.error(ft.getMessage(), ft.getThrowable());
            this.logEntries.add(new BaleenLogEntry(Level.ERROR, ft, this.name));
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.logger.error(ft.getMessage(), ft.getThrowable());
            this.logEntries.add(new BaleenLogEntry(Level.ERROR, ft, this.name));
        }
    }

    public void error(String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
            this.logger.error(ft.getMessage(), ft.getThrowable());
            this.logEntries.add(new BaleenLogEntry(Level.ERROR, ft, this.name));
        }
    }

    public void error(String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            this.logger.error(msg, t);
            this.logEntries.add(new BaleenLogEntry(Level.ERROR, msg, t, this.name));
        }
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.logger.isErrorEnabled(marker);
    }

    public void error(Marker marker, String msg) {
        if (this.isErrorEnabled()) {
            this.logger.error(marker, msg);
            this.logEntries.add(new BaleenLogEntry(Level.ERROR, msg, this.name));
        }
    }

    public void error(Marker marker, String format, Object arg) {
        if (this.isErrorEnabled()) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
            this.logger.error(marker, ft.getMessage(), ft.getThrowable());
            this.logEntries.add(new BaleenLogEntry(Level.ERROR, ft, this.name));
        }
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.logger.error(marker, ft.getMessage(), ft.getThrowable());
            this.logEntries.add(new BaleenLogEntry(Level.ERROR, ft, this.name));
        }
    }

    public void error(Marker marker, String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
            this.logger.error(marker, ft.getMessage(), ft.getThrowable());
            this.logEntries.add(new BaleenLogEntry(Level.ERROR, ft, this.name));
        }
    }

    public void error(Marker marker, String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            this.logger.error(marker, msg, t);
            this.logEntries.add(new BaleenLogEntry(Level.ERROR, msg, t, this.name));
        }
    }
}

