/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.dstl.baleen.logging;

import io.swagger.v3.oas.annotations.media.Schema;
import java.time.LocalDateTime;
import javax.annotation.Nullable;
import org.slf4j.event.Level;
import org.slf4j.helpers.FormattingTuple;

@Schema(name="Baleen Log Entry", description="Log entry captured by Baleen from Annot8")
public class BaleenLogEntry {
    private final Level level;
    private final String message;
    private final String name;
    private final LocalDateTime timestamp;
    @Nullable
    private final Throwable throwable;

    public BaleenLogEntry(Level level, FormattingTuple formattingTuple, String name) {
        this.level = level;
        this.message = formattingTuple.getMessage();
        this.name = name;
        this.timestamp = LocalDateTime.now();
        this.throwable = formattingTuple.getThrowable();
    }

    public BaleenLogEntry(Level level, String message, String name) {
        this.level = level;
        this.message = message;
        this.name = name;
        this.timestamp = LocalDateTime.now();
        this.throwable = null;
    }

    public BaleenLogEntry(Level level, String message, Throwable throwable, String name) {
        this.level = level;
        this.message = message;
        this.name = name;
        this.timestamp = LocalDateTime.now();
        this.throwable = throwable;
    }

    @Schema(description="Priority level associated with this log message")
    public Level getLevel() {
        return this.level;
    }

    @Schema(description="Log message")
    public String getMessage() {
        return this.message;
    }

    @Schema(description="Name of the class that produced this log message")
    public String getName() {
        return this.name;
    }

    @Schema(description="Timestamp at which this log message was created")
    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    @Schema(description="Any Throwable (stack trace) associated with this message, may be empty")
    public Throwable getThrowable() {
        return this.throwable;
    }
}

