/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.dstl.baleen.data;

import io.micrometer.core.instrument.Measurement;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.TreeMap;
import javax.json.bind.annotation.JsonbTransient;
import uk.gov.dstl.baleen.data.MetricsMeasurements;

@Schema(name="Metrics Container", description="Holds all the classes that have metrics associated with them, and their associated measurements")
public class MetricsContainer
extends TreeMap<String, MetricsMeasurements> {
    @JsonbTransient
    public MetricsMeasurements getMeasurements(String clazz) {
        return (MetricsMeasurements)this.get(clazz);
    }

    public void addMeasurement(String clazz, String name, Measurement measurement) {
        this.computeIfAbsent(clazz, k -> new MetricsMeasurements()).addMeasurement(name, measurement);
    }

    public void addMeasurement(String id, Measurement measurement) {
        String[] idParts = id.split("-", 3);
        if (idParts.length == 3) {
            this.addMeasurement(idParts[1], idParts[2], measurement);
        } else {
            this.addMeasurement(id, "value", measurement);
        }
    }
}

