/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.dstl.baleen.controllers.rest;

import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import io.annot8.api.pipelines.ErrorConfiguration;
import io.annot8.api.pipelines.PipelineDescriptor;
import io.annot8.conventions.PathUtils;
import io.annot8.implementations.pipeline.InMemoryPipelineRunner;
import io.annot8.implementations.pipeline.SimplePipelineDescriptor;
import io.micrometer.core.instrument.Measurement;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import uk.gov.dstl.annot8.baleen.SubmittedData;
import uk.gov.dstl.baleen.data.MetricsContainer;
import uk.gov.dstl.baleen.data.MetricsMeasurements;
import uk.gov.dstl.baleen.data.PipelineComponents;
import uk.gov.dstl.baleen.data.PipelineMetadata;
import uk.gov.dstl.baleen.exceptions.AlreadyExistsException;
import uk.gov.dstl.baleen.exceptions.BadRequestException;
import uk.gov.dstl.baleen.exceptions.InternalServerErrorException;
import uk.gov.dstl.baleen.exceptions.PipelineNotFoundException;
import uk.gov.dstl.baleen.exceptions.UnsupportedMediaTypeException;
import uk.gov.dstl.baleen.logging.BaleenLogEntry;
import uk.gov.dstl.baleen.services.PipelineService;
import uk.gov.dstl.baleen.utils.Annot8Utils;

@RestController
@RequestMapping(value={"/api/v3/pipelines"})
@Tag(name="pipelines", description="Query and control pipelines")
public class PipelineController {
    private static final String SUCCESS = "Successful";
    private static final String PIPELINE_NOT_FOUND = "Pipeline not found";
    private static final String MIME_TEXT_URI_LIST = "text/uri-list";
    private static final Logger LOGGER = LoggerFactory.getLogger(PipelineController.class);
    @Autowired
    private PipelineService pipelineService;

    @GetMapping(produces={"application/json"})
    @Operation(description="List all current pipelines")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful")})
    public List<PipelineMetadata> getPipelines() {
        return this.pipelineService.getPipelinesMetadata();
    }

    @GetMapping(value={"/{name}"}, produces={"application/json"})
    @Operation(description="Retrieve information about a specific pipeline")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful"), @ApiResponse(responseCode="404", description="Pipeline not found")})
    public PipelineDescriptor getPipeline(@PathVariable(value="name") @Parameter(description="Name of pipeline", required=true) String name) {
        return this.pipelineService.getPipeline(name).getDescriptor();
    }

    @GetMapping(value={"/{name}/finished"}, produces={"application/json"})
    @Operation(description="Determine whether the pipeline has finished processing")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful"), @ApiResponse(responseCode="404", description="Pipeline not found")})
    public boolean getPipelineFinished(@PathVariable(value="name") @Parameter(description="Name of pipeline", required=true) String name) {
        try {
            return !((InMemoryPipelineRunner)this.pipelineService.getPipeline(name).getPipelineRunner()).isRunning();
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @GetMapping(value={"/{name}/running"}, produces={"application/json"})
    @Operation(description="Determine whether the pipeline is currently running")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful"), @ApiResponse(responseCode="404", description="Pipeline not found")})
    public boolean getPipelineRunning(@PathVariable(value="name") @Parameter(description="Name of pipeline", required=true) String name) {
        return this.pipelineService.getPipeline(name).isRunning();
    }

    @PostMapping(value={"/{name}"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(description="Create a new pipeline")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Pipeline has been created"), @ApiResponse(responseCode="400", description="Unable to create pipeline"), @ApiResponse(responseCode="409", description="Pipeline already exists")})
    public void createPipeline(@PathVariable(value="name") @Parameter(description="Name of pipeline", required=true) String name, @RequestParam(value="description", defaultValue="") @Parameter(description="Description of the pipeline") String description, @org.springframework.web.bind.annotation.RequestBody @Parameter(description="Pipeline configuration", required=true) PipelineComponents configuration, @RequestParam(value="orderer", defaultValue="io.annot8.api.pipelines.NoOpOrderer") @Parameter(description="Class name of the pipeline orderer") String orderer, @RequestParam(value="onSourceError", required=false) @Parameter(description="Action to take if a Source error occurs") ErrorConfiguration.OnSourceError onSourceError, @RequestParam(value="onProcessorError", required=false) @Parameter(description="Action to take if a Processor error occurs") ErrorConfiguration.OnProcessingError onProcessorError, @RequestParam(value="onItemError", required=false) @Parameter(description="Action to take if an Item error occurs") ErrorConfiguration.OnProcessingError onItemError, @RequestParam(value="persist", defaultValue="true") @Parameter(description="Persist the pipeline to disk") boolean persistPipeline) {
        if (this.pipelineService.pipelineExists(name)) {
            throw new AlreadyExistsException("Pipeline " + name + " already exists");
        }
        SimplePipelineDescriptor.Builder builder = new SimplePipelineDescriptor.Builder().withName(name).withDescription(description);
        if (configuration.getSources() != null) {
            builder = builder.withSources(configuration.getSources());
        }
        if (configuration.getProcessors() != null) {
            builder = builder.withProcessors(configuration.getProcessors());
        }
        if (orderer != null) {
            builder = builder.withOrderer(Annot8Utils.getOrderer(orderer));
        }
        ErrorConfiguration errorConfiguration = new ErrorConfiguration();
        if (onSourceError != null) {
            errorConfiguration.setOnSourceError(onSourceError);
        }
        if (onProcessorError != null) {
            errorConfiguration.setOnProcessorError(onProcessorError);
        }
        if (onItemError != null) {
            errorConfiguration.setOnItemError(onItemError);
        }
        builder = builder.withErrorConfiguration(errorConfiguration);
        PipelineDescriptor descriptor = builder.build();
        if (persistPipeline) {
            if (!this.pipelineService.save(descriptor)) {
                throw new InternalServerErrorException("Could not persist pipeline");
            }
            this.pipelineService.detectChanges();
        } else {
            this.pipelineService.createPipeline(descriptor);
        }
    }

    @PostMapping(value={"/{name}/submit"}, consumes={"text/plain", "application/octet-stream", "text/uri-list"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    @Operation(description="Submit data to a pipeline for processing")
    @ApiResponses(value={@ApiResponse(responseCode="202", description="Data has been sent to pipeline for processing"), @ApiResponse(responseCode="400", description="Pipeline is not configured to accept data via REST"), @ApiResponse(responseCode="404", description="Pipeline not found"), @ApiResponse(responseCode="415", description="Pipeline can not handle the submitted data format")})
    @RequestBody(description="Data to process", required=true, content={@Content(mediaType="text/plain"), @Content(mediaType="application/octet-stream"), @Content(mediaType="text/uri-list")})
    public List<String> submitData(@PathVariable(value="name") @Parameter(description="Name of pipeline", required=true) String name, @RequestParam(value="id", required=false) @Parameter(description="User defined ID of item") String id, HttpServletRequest request) {
        ArrayList<Object> dataList;
        block11: {
            if (!this.pipelineService.pipelineExists(name)) {
                throw new PipelineNotFoundException();
            }
            dataList = new ArrayList<Object>();
            try {
                Object data;
                if ("text/plain".equals(request.getContentType())) {
                    data = CharStreams.toString((Readable)new InputStreamReader((InputStream)request.getInputStream(), request.getCharacterEncoding()));
                    LOGGER.info("{} characters of {} data received over REST API for processing by {}", new Object[]{((String)data).length(), "text/plain", name});
                    dataList.add(data);
                    break block11;
                }
                if ("application/octet-stream".equals(request.getContentType())) {
                    data = ByteStreams.toByteArray((InputStream)request.getInputStream());
                    LOGGER.info("{} bytes of {} data received over REST API for processing by {}", new Object[]{((Object)data).length, "application/octet-stream", name});
                    dataList.add(data);
                    break block11;
                }
                if (MIME_TEXT_URI_LIST.equals(request.getContentType())) {
                    data = CharStreams.toString((Readable)new InputStreamReader((InputStream)request.getInputStream(), request.getCharacterEncoding()));
                    int urlCount = 0;
                    for (String line : ((String)data).split("\\r?\\n")) {
                        String trimmedLine = line.trim();
                        if (trimmedLine.isEmpty()) continue;
                        try {
                            dataList.add(new URI(trimmedLine));
                            ++urlCount;
                        }
                        catch (URISyntaxException e) {
                            LOGGER.warn("Invalid URL ({}) received and will not be processed", (Object)trimmedLine);
                        }
                    }
                    LOGGER.info("{} characters of {} data ({} valid urls) received over REST API for processing by {}", new Object[]{((String)data).length(), MIME_TEXT_URI_LIST, urlCount, name});
                    break block11;
                }
                throw new UnsupportedMediaTypeException();
            }
            catch (IOException e) {
                throw new BadRequestException("Unable to read request body", e);
            }
        }
        ArrayList<String> ids = new ArrayList<String>(dataList.size());
        ids.add(id == null ? UUID.randomUUID().toString() : id);
        for (int i = 1; i < dataList.size(); ++i) {
            ids.add(UUID.randomUUID().toString());
        }
        Instant time = Instant.now();
        for (int i = 0; i < dataList.size(); ++i) {
            Object data = dataList.get(i);
            String itemId = (String)ids.get(i);
            SubmittedData submittedData = new SubmittedData(data, itemId);
            request.getHeaderNames().asIterator().forEachRemaining(s -> submittedData.addProperty(PathUtils.join((String[])new String[]{"http", s}), request.getHeader(s)));
            submittedData.addProperty("source", "Baleen 3 REST API");
            submittedData.addProperty("accessedAt", time);
            this.pipelineService.submitData(name, submittedData);
        }
        return ids;
    }

    @GetMapping(value={"/{name}/status/{id}"}, produces={"application/json"})
    @Operation(description="Check on the status of an item submitted via the REST API")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful"), @ApiResponse(responseCode="404", description="Pipeline not found")})
    public Map<String, Object> getItemStatus(@PathVariable(value="name") @Parameter(description="Name of pipeline", required=true) String name, @PathVariable(value="id") @Parameter(description="ID of Item", required=true) String id) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("id", id);
        m.put("status", (Object)this.pipelineService.getItemStatus(name, id));
        return m;
    }

    @PostMapping(value={"/{name}/start"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(description="Starts a specific pipeline, if it's not already running")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Pipeline has been started"), @ApiResponse(responseCode="404", description="Pipeline not found")})
    public void startPipeline(@PathVariable(value="name") @Parameter(description="Name of pipeline", required=true) String name) {
        this.pipelineService.startPipeline(name);
    }

    @PostMapping(value={"/{name}/stop"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(description="Stops a specific pipeline")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Pipeline has been stopped"), @ApiResponse(responseCode="404", description="Pipeline not found")})
    public void stopPipeline(@PathVariable(value="name") @Parameter(description="Name of pipeline", required=true) String name) {
        this.pipelineService.stopPipeline(name);
    }

    @PostMapping(value={"/{name}/restart"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(description="Restarts a specific pipeline, first stopping it (if it is currently running) and then starting it")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Pipeline has been restarted"), @ApiResponse(responseCode="404", description="Pipeline not found")})
    public void restartPipeline(@PathVariable(value="name") @Parameter(description="Name of pipeline", required=true) String name) {
        this.pipelineService.stopPipeline(name);
        this.pipelineService.startPipeline(name);
    }

    @DeleteMapping(value={"/{name}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(description="Delete a specific pipeline")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Pipeline has been deleted"), @ApiResponse(responseCode="404", description="Pipeline not found")})
    public void deletePipeline(@PathVariable(value="name") @Parameter(description="Name of pipeline", required=true) String name) {
        this.pipelineService.deletePipeline(name);
    }

    @GetMapping(value={"/{name}/metrics"}, produces={"application/json"})
    @Operation(description="Retrieve metrics from this pipeline")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful"), @ApiResponse(responseCode="404", description="Pipeline not found")})
    public MetricsContainer getMetrics(@PathVariable(value="name") @Parameter(description="Name of pipeline", required=true) String name) {
        MetricsContainer container = new MetricsContainer();
        this.pipelineService.getPipeline(name).getMeterRegistry().forEachMeter(m -> m.measure().forEach(me -> container.addMeasurement(m.getId().getName(), (Measurement)me)));
        return container;
    }

    @GetMapping(value={"/{name}/metrics/{class}"}, produces={"application/json"})
    @Operation(description="Retrieve metrics from this pipeline, filtered to a single class")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful"), @ApiResponse(responseCode="404", description="Pipeline not found")})
    public MetricsMeasurements getMetrics(@PathVariable(value="name") @Parameter(description="Name of pipeline", required=true) String name, @PathVariable(value="class") @Parameter(description="Name of class", required=true) String clazz) {
        return this.getMetrics(name).getMeasurements(clazz);
    }

    @GetMapping(value={"/{name}/logs"}, produces={"application/json"})
    @Operation(description="Retrieve logs from this pipeline")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful"), @ApiResponse(responseCode="404", description="Pipeline not found")})
    public Collection<BaleenLogEntry> getLogs(@PathVariable(value="name") @Parameter(description="Name of pipeline", required=true) String name, @RequestParam(value="max", required=false) @Parameter(description="Maximum number of log entries to return", example="500") Integer max, @RequestParam(value="minLevel", required=false, defaultValue="INFO") @Parameter(description="Minimum Log level to return") Level minLevel) {
        return this.filterLogs(name, null, max, minLevel);
    }

    @GetMapping(value={"/{name}/logs/{class}"}, produces={"application/json"})
    @Operation(description="Retrieve logs from this pipeline, filtered to a single class")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful"), @ApiResponse(responseCode="404", description="Pipeline not found")})
    public Collection<BaleenLogEntry> getLogs(@PathVariable(value="name") @Parameter(description="Name of pipeline", required=true) String name, @PathVariable(value="class") @Parameter(description="Name of class", required=true) String clazz, @RequestParam(value="max", required=false) @Parameter(description="Maximum number of log entries to return", example="500") Integer max, @RequestParam(value="minLevel", required=false, defaultValue="INFO") @Parameter(description="Minimum Log level to return") Level minLevel) {
        return this.filterLogs(name, clazz, max, minLevel);
    }

    private Collection<BaleenLogEntry> filterLogs(String pipeline, String logName, Integer maxEntries, Level minLevel) {
        return PipelineController.filterLogs(this.pipelineService.getPipeline(pipeline).getLogEntries().stream(), logName, maxEntries, minLevel).collect(Collectors.toList());
    }

    protected static Stream<BaleenLogEntry> filterLogs(Stream<BaleenLogEntry> logs, String logName, Integer maxEntries, Level minLevel) {
        Stream<BaleenLogEntry> filteredStream = logs;
        if (logName != null) {
            filteredStream = filteredStream.filter(ble -> logName.equals(ble.getName()));
        }
        if (minLevel != null) {
            filteredStream = filteredStream.filter(ble -> ble.getLevel().toInt() >= minLevel.toInt());
        }
        if (maxEntries != null) {
            List filteredLogs = filteredStream.collect(Collectors.toList());
            filteredStream = filteredLogs.subList(Math.max(filteredLogs.size() - maxEntries, 0), filteredLogs.size()).stream();
        }
        return filteredStream;
    }
}

