/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.dstl.baleen.controllers.rest;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.ConfigFunction;
import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.MethodScope;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.google.common.collect.Streams;
import io.annot8.api.components.ProcessorDescriptor;
import io.annot8.api.components.SourceDescriptor;
import io.annot8.api.components.annotations.ComponentTags;
import io.annot8.api.settings.Description;
import io.annot8.api.settings.Settings;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import uk.gov.dstl.baleen.configuration.JacksonConfiguration;
import uk.gov.dstl.baleen.data.Annot8ComponentInfo;
import uk.gov.dstl.baleen.data.SettingsSchema;
import uk.gov.dstl.baleen.exceptions.BadRequestException;
import uk.gov.dstl.baleen.exceptions.ComponentNotFoundException;
import uk.gov.dstl.baleen.exceptions.InternalServerErrorException;
import uk.gov.dstl.baleen.exceptions.SettingsNotFoundException;
import uk.gov.dstl.baleen.services.Annot8ComponentService;
import uk.gov.dstl.baleen.utils.Annot8Utils;

@RestController
@RequestMapping(value={"/api/v3/annot8"})
@Tag(name="annot8", description="Query the current Annot8 environment")
public class Annot8Controller {
    @Autowired
    private Annot8ComponentService annot8Components;
    @Autowired
    private JacksonConfiguration jacksonConfiguration;
    @Autowired
    private ObjectMapper objectMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(Annot8Controller.class);

    @GetMapping(value={"/orderers"}, produces={"application/json"})
    @Operation(description="List of all available pipeline orderers")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful")})
    public Collection<String> getOrderers() {
        return this.annot8Components.getOrderers().stream().map(Class::getName).collect(Collectors.toList());
    }

    @PostMapping(value={"/orderers/{orderer}/processors"}, produces={"application/json"})
    @Operation(description="Order the given processors using the specified orderer, returning the ordered processors")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful")})
    public Collection<ProcessorDescriptor> orderProcessors(@PathVariable(value="orderer") @Parameter(description="Full class name of the orderer", required=true) String orderer, @RequestBody @Parameter(description="Processors with configuration", required=true) Collection<ProcessorDescriptor> processors) {
        return Annot8Utils.getOrderer(orderer).orderProcessors(processors);
    }

    @PostMapping(value={"/orderers/{orderer}/sources"}, produces={"application/json"})
    @Operation(description="Order the given sources using the specified orderer, returning the ordered sources")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful")})
    public Collection<SourceDescriptor> orderSources(@PathVariable(value="orderer") @Parameter(description="Full class name of the orderer", required=true) String orderer, @RequestBody @Parameter(description="Sources with configuration", required=true) Collection<SourceDescriptor> sources) {
        return Annot8Utils.getOrderer(orderer).orderSources(sources);
    }

    @GetMapping(value={"/sources"}, produces={"application/json"})
    @Operation(description="Information about all available Annot8 Sources")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful")})
    public List<Annot8ComponentInfo> getSources() {
        return this.annot8Components.getRegistry().getSources().map(Annot8ComponentInfo::fromDescriptor).collect(Collectors.toList());
    }

    @GetMapping(value={"/sources/{source}"}, produces={"application/json"})
    @Operation(description="Information about a specific Annot8 Source")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful")})
    public Annot8ComponentInfo getSource(@PathVariable(value="source") @Parameter(description="Full class name of the Source descriptor") String name) {
        Optional<Class> source = this.annot8Components.getRegistry().getSources().filter(c -> c.getName().equals(name)).findFirst();
        return Annot8ComponentInfo.fromDescriptor(source.orElseThrow(() -> new ComponentNotFoundException(name)));
    }

    @GetMapping(value={"/sources/tags"}, produces={"application/json"})
    @Operation(description="List of all available Source tags, with counts")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful")})
    public Map<String, Long> getSourceTags() {
        return this.annot8Components.getRegistry().getSources().filter(c -> !c.getName().startsWith("uk.gov.dstl.annot8.baleen.")).flatMap(c -> {
            ComponentTags ct = c.getAnnotation(ComponentTags.class);
            if (ct == null) {
                return Stream.empty();
            }
            return Stream.of(ct.value()).distinct();
        }).collect(Collectors.groupingBy(s -> s, Collectors.counting()));
    }

    @GetMapping(value={"/sources/tags/{tag}"}, produces={"application/json"})
    @Operation(description="Information about Annot8 Sources with the given tag(s)")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful")})
    public List<Annot8ComponentInfo> getSourcesByTag(@PathVariable(value="tag") @Parameter(description="Tag or tags (comma separated) to that sources must have") String tag) {
        List<String> tags = List.of(tag.split(","));
        return this.annot8Components.getRegistry().getSources().filter(c -> !c.getName().startsWith("uk.gov.dstl.annot8.baleen.")).filter(c -> {
            ComponentTags ct = c.getAnnotation(ComponentTags.class);
            if (ct == null) {
                return false;
            }
            List<String> cTags = List.of(ct.value());
            return cTags.stream().anyMatch(tags::contains);
        }).map(Annot8ComponentInfo::fromDescriptor).collect(Collectors.toList());
    }

    @GetMapping(value={"/processors"}, produces={"application/json"})
    @Operation(description="Information about all available Annot8 Processors")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful")})
    public List<Annot8ComponentInfo> getProcessors() {
        return this.annot8Components.getRegistry().getProcessors().filter(c -> !c.getName().startsWith("uk.gov.dstl.annot8.baleen.")).map(Annot8ComponentInfo::fromDescriptor).collect(Collectors.toList());
    }

    @GetMapping(value={"/processors/{processor}"}, produces={"application/json"})
    @Operation(description="Information about a specific Annot8 Processor")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful")})
    public Annot8ComponentInfo getProcessor(@PathVariable(value="processor") @Parameter(description="Full class name of the Processor descriptor") String name) {
        Optional<Class> processor = this.annot8Components.getRegistry().getProcessors().filter(c -> c.getName().equals(name)).findFirst();
        return Annot8ComponentInfo.fromDescriptor(processor.orElseThrow(() -> new ComponentNotFoundException(name)));
    }

    @GetMapping(value={"/processors/tags"}, produces={"application/json"})
    @Operation(description="List of all available Processor tags, with counts")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful")})
    public Map<String, Long> getProcessorTags() {
        return this.annot8Components.getRegistry().getProcessors().flatMap(c -> {
            ComponentTags ct = c.getAnnotation(ComponentTags.class);
            if (ct == null) {
                return Stream.empty();
            }
            return Stream.of(ct.value()).distinct();
        }).collect(Collectors.groupingBy(s -> s, Collectors.counting()));
    }

    @GetMapping(value={"/processors/tags/{tag}"}, produces={"application/json"})
    @Operation(description="Information about Annot8 Processors with the given tag(s)")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful")})
    public List<Annot8ComponentInfo> getProcessorsByTag(@PathVariable(value="tag") @Parameter(description="Tag or tags (comma separated) to that processors must have") String tag) {
        List<String> tags = List.of(tag.split(","));
        return this.annot8Components.getRegistry().getProcessors().filter(c -> {
            ComponentTags ct = c.getAnnotation(ComponentTags.class);
            if (ct == null) {
                return false;
            }
            List<String> cTags = List.of(ct.value());
            return cTags.stream().anyMatch(tags::contains);
        }).map(Annot8ComponentInfo::fromDescriptor).collect(Collectors.toList());
    }

    @GetMapping(value={"/tags"}, produces={"application/json"})
    @Operation(description="List of all available tags, with counts")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful")})
    public Map<String, Long> getTags() {
        return Stream.concat(this.getSourceTags().entrySet().stream(), this.getProcessorTags().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Long::sum));
    }

    @GetMapping(value={"/settings"}, produces={"application/schema+json"})
    @Operation(description="Return the JSON Schemas for all Settings classes")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful")})
    public Map<String, SettingsSchema> getSettings() {
        return Streams.concat((Stream[])new Stream[]{this.getProcessors().stream(), this.getSources().stream()}).map(Annot8ComponentInfo::getSettingsClass).distinct().filter(Objects::nonNull).map(this::createSettingsSchema).collect(Collectors.toMap(SettingsSchema::getName, Function.identity()));
    }

    private SettingsSchema createSettingsSchema(String className) {
        Class<? extends Settings> settings = this.getSettingsClass(className);
        return new SettingsSchema(className, this.getSettingsSchema(settings));
    }

    @GetMapping(value={"/settings/{settings}"}, produces={"application/schema+json"})
    @Operation(description="Return the JSON Schema for a Settings class")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful"), @ApiResponse(responseCode="400", description="Class is not a sub-class of Settings"), @ApiResponse(responseCode="404", description="Settings class can't be found")})
    public String getSettings(@PathVariable(value="settings") @Parameter(description="Full class name of the Settings class") String name) {
        Class<? extends Settings> settings = this.getSettingsClass(name);
        return this.getSettingsSchema(settings);
    }

    private String getSettingsSchema(Class<? extends Settings> settingsClass) {
        SchemaGeneratorConfigBuilder configBuilder = new SchemaGeneratorConfigBuilder(this.objectMapper, SchemaVersion.DRAFT_7, OptionPreset.PLAIN_JSON);
        configBuilder.forFields().withDescriptionResolver(fs -> {
            if (!fs.hasGetter()) {
                return null;
            }
            Description desc = this.getDescription((FieldScope)fs);
            if (desc == null) {
                return null;
            }
            return desc.value();
        }).withDefaultResolver(fs -> {
            if (!fs.hasGetter()) {
                return null;
            }
            Object ret = this.getDefaultValueFromAnnotation((FieldScope)fs);
            if (ret != null) {
                return ret;
            }
            LOGGER.debug("Default values not present in documentation for {}#{}, instantiating no-args instance of Settings to find them", (Object)settingsClass.getName(), (Object)fs.getSchemaPropertyName());
            try {
                return settingsClass.getMethod(fs.findGetter().getName(), new Class[0]).invoke((Object)this.getSettingsDefault(settingsClass), new Object[0]);
            }
            catch (Exception e) {
                LOGGER.debug("Unable to retrieve default values for {}#{} from no-args instance: {}", new Object[]{settingsClass.getName(), fs.getSchemaPropertyName(), e.getMessage()});
                return null;
            }
        });
        this.jacksonConfiguration.getSerializationBundles().forEach(bundle -> configBuilder.forFields().withTargetTypeOverridesResolver(this.createTargetTypeOverride(bundle.getType(), bundle.getTransformedType())));
        SchemaGenerator generator = new SchemaGenerator(configBuilder.build());
        ObjectNode jsonSchema = generator.generateSchema(settingsClass, new Type[0]);
        try {
            return this.objectMapper.writeValueAsString((Object)jsonSchema);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Unable to serialize Settings Schema for {}", settingsClass, (Object)e);
            return null;
        }
    }

    @GetMapping(value={"/settings/{settings}/default"}, produces={"application/json"})
    @Operation(description="Return a JSON representation of the default instance of a Settings class")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful"), @ApiResponse(responseCode="400", description="Class is not a sub-class of Settings, or doesn't have a no-args constructor"), @ApiResponse(responseCode="404", description="Settings class can't be found")})
    public Settings getSettingsDefault(@PathVariable(value="settings") @Parameter(description="Full class name of the Settings class") String name) {
        return this.getSettingsDefault(this.getSettingsClass(name));
    }

    private Settings getSettingsDefault(Class<? extends Settings> settings) {
        try {
            return settings.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException nsme) {
            throw new BadRequestException("Settings " + settings.getName() + " does not have a no-args constructor");
        }
        catch (Exception e) {
            throw new InternalServerErrorException("Unable to instantiate Settings " + settings.getName(), e);
        }
    }

    private Class<? extends Settings> getSettingsClass(String name) {
        Class<Settings> settings;
        try {
            settings = Class.forName(name).asSubclass(Settings.class);
        }
        catch (ClassNotFoundException e) {
            throw new SettingsNotFoundException(name);
        }
        catch (Exception e) {
            throw new BadRequestException("Class is not a subclass of Settings", e);
        }
        return settings;
    }

    private Description getDescription(FieldScope fieldScope) {
        MethodScope ms = fieldScope.findGetter();
        if (ms == null) {
            return null;
        }
        return (Description)ms.getAnnotation(Description.class);
    }

    private Object getDefaultValueFromAnnotation(FieldScope fieldScope) {
        Description desc = this.getDescription(fieldScope);
        if (desc == null) {
            return null;
        }
        String defaultValue = desc.defaultValue();
        if (defaultValue.isBlank()) {
            return null;
        }
        return Annot8Controller.parseValueAsType(fieldScope.getType(), defaultValue);
    }

    protected static Object parseValueAsType(ResolvedType type, String value) {
        if (type.isInstanceOf(Boolean.TYPE) || type.isInstanceOf(Boolean.class)) {
            return Boolean.parseBoolean(value);
        }
        if (type.isInstanceOf(Short.TYPE) || type.isInstanceOf(Short.class)) {
            try {
                return Short.parseShort(value);
            }
            catch (Exception exception) {
            }
        } else if (type.isInstanceOf(Integer.TYPE) || type.isInstanceOf(Integer.class)) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception exception) {
            }
        } else if (type.isInstanceOf(Long.TYPE) || type.isInstanceOf(Long.class)) {
            try {
                return Long.parseLong(value);
            }
            catch (Exception exception) {
            }
        } else if (type.isInstanceOf(Float.TYPE) || type.isInstanceOf(Float.class)) {
            try {
                return Float.valueOf(Float.parseFloat(value));
            }
            catch (Exception exception) {
            }
        } else if (type.isInstanceOf(Double.TYPE) || type.isInstanceOf(Double.class)) {
            try {
                return Double.parseDouble(value);
            }
            catch (Exception exception) {
            }
        } else if (type.isInstanceOf(Byte.TYPE) || type.isInstanceOf(Byte.class)) {
            try {
                return Byte.parseByte(value);
            }
            catch (Exception exception) {
            }
        } else if (type.isInstanceOf(Character.TYPE) || type.isInstanceOf(Character.class)) {
            try {
                return Character.valueOf(value.charAt(0));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    private ConfigFunction<FieldScope, List<ResolvedType>> createTargetTypeOverride(Class<?> declaredType, Class<?> alternativeType) {
        return field -> field.getType().getErasedType() == declaredType ? Collections.singletonList(field.getContext().resolve((Type)alternativeType, new Type[0])) : null;
    }
}

