/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.dstl.baleen.configuration;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.annot8.api.components.ProcessorDescriptor;
import io.annot8.api.components.SourceDescriptor;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import uk.gov.dstl.json.serialization.Annot8ComponentDescriptorMixIn;
import uk.gov.dstl.json.serialization.SerializationBundle;

@Configuration
public class JacksonConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(JacksonConfiguration.class);
    private final List<SerializationBundle> bundles = new ArrayList<SerializationBundle>();

    @PostConstruct
    public void getBundles() {
        try (ScanResult scanResult = new ClassGraph().enableClassInfo().scan();){
            scanResult.getClassesImplementing(SerializationBundle.class.getName()).filter(cif -> !cif.isAbstract()).loadClasses().forEach(c -> {
                try {
                    SerializationBundle sb = (SerializationBundle)c.getConstructor(new Class[0]).newInstance(new Object[0]);
                    this.bundles.add(sb);
                    LOGGER.info("Serialization bundle {} initialized", (Object)c.getName());
                }
                catch (Exception e) {
                    LOGGER.error("Unable to instantiate serialization bundle {}", (Object)c.getName(), (Object)e);
                }
            });
        }
    }

    public List<SerializationBundle> getSerializationBundles() {
        return this.bundles;
    }

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer addMixIns() {
        return jacksonObjectMapperBuilder -> jacksonObjectMapperBuilder.mixIn(SourceDescriptor.class, Annot8ComponentDescriptorMixIn.class).mixIn(ProcessorDescriptor.class, Annot8ComponentDescriptorMixIn.class);
    }

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer addCustomSerialization() {
        return jacksonObjectMapperBuilder -> {
            for (SerializationBundle bundle : this.bundles) {
                LOGGER.info("Adding serialization and de-serialization from bundle {} to configuration", (Object)bundle.getClass().getName());
                if (bundle.getSerializer() != null) {
                    jacksonObjectMapperBuilder.serializerByType(bundle.getType(), bundle.getSerializer());
                }
                if (bundle.getDeserializer() == null) continue;
                jacksonObjectMapperBuilder.deserializerByType(bundle.getType(), bundle.getDeserializer());
            }
        };
    }

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer configureJackson() {
        return jacksonObjectMapperBuilder -> jacksonObjectMapperBuilder.serializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

