/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.dstl.annot8.baleen;

import io.annot8.api.components.responses.SourceResponse;
import io.annot8.api.data.Content;
import io.annot8.api.data.ItemFactory;
import io.annot8.common.components.AbstractSource;
import io.annot8.common.data.content.InputStreamContent;
import io.annot8.common.data.content.Text;
import io.annot8.common.data.content.UriContent;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import uk.gov.dstl.annot8.baleen.RestApiQueue;
import uk.gov.dstl.annot8.baleen.SubmittedData;

public class RestApiSource
extends AbstractSource {
    private final RestApiQueue queue;

    public RestApiSource(RestApiQueue queue) {
        this.queue = queue;
    }

    public SourceResponse read(ItemFactory itemFactory) {
        if (this.queue.isEmpty()) {
            return SourceResponse.empty();
        }
        Optional<SubmittedData> opt = this.queue.readFromQueue();
        while (opt.isPresent()) {
            Content.Builder builder;
            SubmittedData submittedData = opt.get();
            String id = submittedData.getId().orElse(null);
            if (submittedData.getData() instanceof String) {
                this.log().debug("Creating Text content for string data");
                builder = itemFactory.create(id).createContent(Text.class).withData((Object)((String)submittedData.getData()));
            } else if (submittedData.getData() instanceof URI) {
                this.log().debug("Creating URI content for URI data");
                builder = itemFactory.create(id).createContent(UriContent.class).withData((Object)((URI)submittedData.getData()));
            } else if (submittedData.getData() instanceof byte[]) {
                this.log().debug("Creating InputStream content for byte array data");
                builder = itemFactory.create(id).createContent(InputStreamContent.class).withData(() -> new ByteArrayInputStream((byte[])submittedData.getData()));
            } else {
                this.log().warn("Unexpected data type ({}) retrieved from REST queue", submittedData.getData().getClass());
                return SourceResponse.sourceError((Exception[])new Exception[]{new IllegalArgumentException("Unexpected data type")});
            }
            builder = builder.withDescription("Data from REST API");
            for (Map.Entry<String, Object> e : submittedData.getProperties().entrySet()) {
                builder = (Content.Builder)builder.withProperty(e.getKey(), e.getValue());
            }
            builder.save();
            this.metrics().counter("items.created", new String[0]).increment();
            opt = this.queue.readFromQueue();
        }
        return SourceResponse.ok();
    }
}

