/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.golang;

import java.nio.ByteOrder;
import java.util.EnumMap;
import java.util.Map;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.util.ValidationUtil;

public class GolangUtil {
    private static final Map<PrimitiveType, String> PRIMITIVE_TYPE_STRING_ENUM_MAP = new EnumMap<PrimitiveType, String>(PrimitiveType.class);
    private static final Map<PrimitiveType, String> MARSHAL_TYPE_BY_PRIMITIVE_TYPE_MAP;

    public static String golangTypeName(PrimitiveType primitiveType) {
        return PRIMITIVE_TYPE_STRING_ENUM_MAP.get((Object)primitiveType);
    }

    public static String golangMarshalType(PrimitiveType primitiveType) {
        return MARSHAL_TYPE_BY_PRIMITIVE_TYPE_MAP.get((Object)primitiveType);
    }

    public static String toUpperFirstChar(String str) {
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public static String toLowerFirstChar(String str) {
        return Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }

    public static String formatPropertyName(String value) {
        String formattedValue = GolangUtil.toUpperFirstChar(value);
        if (ValidationUtil.isGolangKeyword(formattedValue)) {
            String keywordAppendToken = System.getProperty("sbe.keyword.append.token");
            if (null == keywordAppendToken) {
                throw new IllegalStateException("Invalid property name='" + formattedValue + "' please correct the schema or consider setting system property: " + "sbe.keyword.append.token");
            }
            formattedValue = formattedValue + keywordAppendToken;
        }
        return formattedValue;
    }

    public static String formatTypeName(String value) {
        return GolangUtil.toUpperFirstChar(value);
    }

    public static String formatByteOrderEncoding(ByteOrder byteOrder, PrimitiveType primitiveType) {
        switch (primitiveType.size()) {
            case 2: {
                return "binary.Write(buf, order, obj)";
            }
            case 4: {
                return "binary.Write(buf, order, obj)";
            }
            case 8: {
                return "binary.Write(buf, order, obj)";
            }
        }
        return "";
    }

    public static String closingBraces(int count) {
        return new String(new char[count]).replace("\u0000", "}\n");
    }

    static {
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.CHAR, "byte");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.INT8, "int8");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.INT16, "int16");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.INT32, "int32");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.INT64, "int64");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.UINT8, "uint8");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.UINT16, "uint16");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.UINT32, "uint32");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.UINT64, "uint64");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.FLOAT, "float32");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.DOUBLE, "float64");
        MARSHAL_TYPE_BY_PRIMITIVE_TYPE_MAP = new EnumMap<PrimitiveType, String>(PrimitiveType.class);
        MARSHAL_TYPE_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.CHAR, "Bytes");
        MARSHAL_TYPE_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.INT8, "Int8");
        MARSHAL_TYPE_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.INT16, "Int16");
        MARSHAL_TYPE_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.INT32, "Int32");
        MARSHAL_TYPE_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.INT64, "Int64");
        MARSHAL_TYPE_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.UINT8, "Uint8");
        MARSHAL_TYPE_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.UINT16, "Uint16");
        MARSHAL_TYPE_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.UINT32, "Uint32");
        MARSHAL_TYPE_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.UINT64, "Uint64");
        MARSHAL_TYPE_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.FLOAT, "Float32");
        MARSHAL_TYPE_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.DOUBLE, "Float64");
    }
}

