/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.json;

import java.nio.ByteBuffer;
import java.util.List;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.sbe.ir.Ir;
import uk.co.real_logic.sbe.ir.Token;
import uk.co.real_logic.sbe.json.JsonTokenListener;
import uk.co.real_logic.sbe.otf.OtfHeaderDecoder;
import uk.co.real_logic.sbe.otf.OtfMessageDecoder;

public class JsonPrinter {
    private final OtfHeaderDecoder headerDecoder;
    private final Ir ir;

    public JsonPrinter(Ir ir) {
        this.ir = ir;
        this.headerDecoder = new OtfHeaderDecoder(ir.headerStructure());
    }

    public void print(ByteBuffer encodedMessage, StringBuilder output) {
        UnsafeBuffer buffer = new UnsafeBuffer(encodedMessage);
        this.print(output, buffer, 0);
    }

    public void print(StringBuilder output, UnsafeBuffer buffer, int bufferOffset) {
        int templateId = this.headerDecoder.getTemplateId((DirectBuffer)buffer, bufferOffset);
        int schemaId = this.headerDecoder.getSchemaId((DirectBuffer)buffer, bufferOffset);
        int actingVersion = this.headerDecoder.getSchemaVersion((DirectBuffer)buffer, bufferOffset);
        int blockLength = this.headerDecoder.getBlockLength((DirectBuffer)buffer, bufferOffset);
        this.validateId(schemaId);
        this.validateVersion(schemaId, actingVersion);
        int messageOffset = bufferOffset + this.headerDecoder.encodedLength();
        List<Token> msgTokens = this.ir.getMessage(templateId);
        OtfMessageDecoder.decode((DirectBuffer)buffer, messageOffset, actingVersion, blockLength, msgTokens, new JsonTokenListener(output));
    }

    private void validateId(int schemaId) {
        if (schemaId != this.ir.id()) {
            throw new IllegalArgumentException(String.format("Required schema id %d but was actually %d", this.ir.id(), schemaId));
        }
    }

    private void validateVersion(int schemaId, int actingVersion) {
        if (actingVersion > this.ir.version()) {
            throw new IllegalArgumentException(String.format("Required schema id %d but was actually %d", this.ir.id(), schemaId));
        }
    }

    public String print(ByteBuffer encodedMessage) {
        StringBuilder sb = new StringBuilder();
        this.print(encodedMessage, sb);
        return sb.toString();
    }
}

