/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.xml;

import org.w3c.dom.Node;
import uk.co.real_logic.sbe.xml.Presence;
import uk.co.real_logic.sbe.xml.XmlSchemaParser;

public abstract class Type {
    private final String name;
    private final Presence presence;
    private final String description;
    private final int sinceVersion;
    private final int deprecated;
    private final String semanticType;
    private final String referencedName;
    private int offsetAttribute;

    public Type(Node node, String givenName, String referencedName) {
        this.name = null == givenName ? XmlSchemaParser.getAttributeValue(node, "name") : givenName;
        this.referencedName = referencedName;
        this.presence = Presence.get(XmlSchemaParser.getAttributeValue(node, "presence", "required"));
        this.description = XmlSchemaParser.getAttributeValueOrNull(node, "description");
        this.sinceVersion = Integer.parseInt(XmlSchemaParser.getAttributeValue(node, "sinceVersion", "0"));
        this.deprecated = Integer.parseInt(XmlSchemaParser.getAttributeValue(node, "deprecated", "0"));
        this.semanticType = XmlSchemaParser.getAttributeValueOrNull(node, "semanticType");
        this.offsetAttribute = Integer.parseInt(XmlSchemaParser.getAttributeValue(node, "offset", "-1"));
    }

    public Type(String name, Presence presence, String description, int sinceVersion, int deprecated, String semanticType) {
        this.name = name;
        this.presence = presence;
        this.description = description;
        this.sinceVersion = sinceVersion;
        this.deprecated = deprecated;
        this.semanticType = semanticType;
        this.offsetAttribute = -1;
        this.referencedName = null;
    }

    public String name() {
        return this.name;
    }

    public String referencedName() {
        return this.referencedName;
    }

    public Presence presence() {
        return this.presence;
    }

    public abstract int encodedLength();

    public String description() {
        return this.description;
    }

    public int sinceVersion() {
        return this.sinceVersion;
    }

    public int deprecated() {
        return this.deprecated;
    }

    public String semanticType() {
        return this.semanticType;
    }

    public abstract boolean isVariableLength();

    public int offsetAttribute() {
        return this.offsetAttribute;
    }

    public void offsetAttribute(int offsetAttribute) {
        this.offsetAttribute = offsetAttribute;
    }
}

