/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.ir.generated;

import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import uk.co.real_logic.sbe.ir.generated.FrameCodecDecoder;
import uk.co.real_logic.sbe.ir.generated.MessageHeaderEncoder;
import uk.co.real_logic.sbe.ir.generated.MetaAttribute;

public class FrameCodecEncoder {
    public static final int BLOCK_LENGTH = 12;
    public static final int TEMPLATE_ID = 1;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    private final FrameCodecEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    protected int offset;
    protected int limit;

    public int sbeBlockLength() {
        return 12;
    }

    public int sbeTemplateId() {
        return 1;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public FrameCodecEncoder wrap(MutableDirectBuffer buffer, int offset) {
        this.buffer = buffer;
        this.offset = offset;
        this.limit(offset + 12);
        return this;
    }

    public FrameCodecEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(12).templateId(1).schemaId(1).version(0);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int irIdEncodingOffset() {
        return 0;
    }

    public static int irIdEncodingLength() {
        return 4;
    }

    public static int irIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int irIdMinValue() {
        return -2147483647;
    }

    public static int irIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public FrameCodecEncoder irId(int value) {
        this.buffer.putInt(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int irVersionEncodingOffset() {
        return 4;
    }

    public static int irVersionEncodingLength() {
        return 4;
    }

    public static int irVersionNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int irVersionMinValue() {
        return -2147483647;
    }

    public static int irVersionMaxValue() {
        return Integer.MAX_VALUE;
    }

    public FrameCodecEncoder irVersion(int value) {
        this.buffer.putInt(this.offset + 4, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int schemaVersionEncodingOffset() {
        return 8;
    }

    public static int schemaVersionEncodingLength() {
        return 4;
    }

    public static int schemaVersionNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int schemaVersionMinValue() {
        return -2147483647;
    }

    public static int schemaVersionMaxValue() {
        return Integer.MAX_VALUE;
    }

    public FrameCodecEncoder schemaVersion(int value) {
        this.buffer.putInt(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int packageNameId() {
        return 4;
    }

    public static String packageNameCharacterEncoding() {
        return "UTF-8";
    }

    public static String packageNameMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int packageNameHeaderLength() {
        return 2;
    }

    public FrameCodecEncoder putPackageName(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public FrameCodecEncoder putPackageName(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public FrameCodecEncoder packageName(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public static int namespaceNameId() {
        return 5;
    }

    public static String namespaceNameCharacterEncoding() {
        return "UTF-8";
    }

    public static String namespaceNameMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int namespaceNameHeaderLength() {
        return 2;
    }

    public FrameCodecEncoder putNamespaceName(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public FrameCodecEncoder putNamespaceName(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public FrameCodecEncoder namespaceName(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public static int semanticVersionId() {
        return 6;
    }

    public static String semanticVersionCharacterEncoding() {
        return "UTF-8";
    }

    public static String semanticVersionMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int semanticVersionHeaderLength() {
        return 2;
    }

    public FrameCodecEncoder putSemanticVersion(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public FrameCodecEncoder putSemanticVersion(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public FrameCodecEncoder semanticVersion(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        FrameCodecDecoder writer = new FrameCodecDecoder();
        writer.wrap((DirectBuffer)this.buffer, this.offset, 12, 0);
        return writer.appendTo(builder);
    }
}

