/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.ir;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import uk.co.real_logic.sbe.ir.Signal;
import uk.co.real_logic.sbe.ir.Token;

public final class GenerationUtil {
    private GenerationUtil() {
    }

    public static int collectFields(List<Token> tokens, int index, List<Token> fields) {
        return GenerationUtil.collect(Signal.BEGIN_FIELD, tokens, index, fields);
    }

    public static int collectGroups(List<Token> tokens, int index, List<Token> groups) {
        return GenerationUtil.collect(Signal.BEGIN_GROUP, tokens, index, groups);
    }

    public static int collectVarData(List<Token> tokens, int index, List<Token> varData) {
        return GenerationUtil.collect(Signal.BEGIN_VAR_DATA, tokens, index, varData);
    }

    public static int collect(Signal signal, List<Token> tokens, int index, List<Token> collected) {
        Token token;
        int i = index;
        while (i < tokens.size() && signal == (token = tokens.get(i)).signal()) {
            int tokenCount = token.componentTokenCount();
            int limit = i + tokenCount;
            while (i < limit) {
                collected.add(tokens.get(i));
                ++i;
            }
        }
        return i;
    }

    public static List<Token> getMessageBody(List<Token> tokens) {
        return tokens.subList(1, tokens.size() - 1);
    }

    public static CharSequence concatEncodingTokens(List<Token> tokens, Function<Token, CharSequence> mapper) {
        return GenerationUtil.concatTokens(tokens, Signal.ENCODING, mapper);
    }

    public static CharSequence concatTokens(List<Token> tokens, Signal signal, Function<Token, CharSequence> mapper) {
        return tokens.stream().filter(token -> token.signal() == signal).map(mapper).collect(Collectors.joining());
    }

    public static int findEndSignal(List<Token> tokens, int startIndex, Signal signal, String name) {
        int result = tokens.size() - 1;
        int endIndex = tokens.size() - 1;
        for (int i = startIndex; i < endIndex; ++i) {
            Token token = tokens.get(i);
            if (signal != token.signal() || !name.equals(token.name())) continue;
            result = i;
            break;
        }
        return result;
    }
}

