/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.golang;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.agrona.Verify;
import org.agrona.generation.OutputManager;

public class GolangOutputManager
implements OutputManager {
    private final File outputDir;

    public GolangOutputManager(String baseDirectoryName, String namespaceName) throws IOException {
        Verify.notNull((Object)baseDirectoryName, (String)"baseDirectoryName");
        Verify.notNull((Object)namespaceName, (String)"applicableNamespace");
        String dirName = (baseDirectoryName.endsWith("" + File.separatorChar) ? baseDirectoryName : baseDirectoryName + File.separatorChar) + namespaceName.replace('.', '_');
        this.outputDir = new File(dirName);
        if (!this.outputDir.exists() && !this.outputDir.mkdirs()) {
            throw new IllegalStateException("Unable to create directory: " + dirName);
        }
    }

    public Writer createOutput(String name) throws IOException {
        File targetFile = new File(this.outputDir, name + ".go");
        return Files.newBufferedWriter(targetFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
    }
}

