/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.golang;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.TreeSet;
import org.agrona.Verify;
import org.agrona.generation.OutputManager;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.generation.CodeGenerator;
import uk.co.real_logic.sbe.generation.golang.GolangUtil;
import uk.co.real_logic.sbe.ir.Encoding;
import uk.co.real_logic.sbe.ir.GenerationUtil;
import uk.co.real_logic.sbe.ir.Ir;
import uk.co.real_logic.sbe.ir.Signal;
import uk.co.real_logic.sbe.ir.Token;

public class GolangGenerator
implements CodeGenerator {
    private final Ir ir;
    private final OutputManager outputManager;
    private TreeSet<String> imports;

    public GolangGenerator(Ir ir, OutputManager outputManager) throws IOException {
        Verify.notNull((Object)ir, (String)"ir");
        Verify.notNull((Object)outputManager, (String)"outputManager");
        this.ir = ir;
        this.outputManager = outputManager;
    }

    public void generateFileFromTemplate(String fileName, String templateName) throws IOException {
        try (Writer out = this.outputManager.createOutput(fileName);){
            out.append(this.generateFromTemplate(this.ir.namespaces(), templateName));
        }
    }

    public void generateTypeStubs() throws IOException {
        for (List<Token> tokens : this.ir.types()) {
            switch (tokens.get(0).signal()) {
                case BEGIN_ENUM: {
                    this.generateEnum(tokens);
                    break;
                }
                case BEGIN_SET: {
                    this.generateChoiceSet(tokens);
                    break;
                }
                case BEGIN_COMPOSITE: {
                    this.generateComposite(tokens, "");
                    break;
                }
                case BEGIN_MESSAGE: {
                    break;
                }
            }
        }
    }

    public void generateMessageHeaderStub() throws IOException {
        String messageHeader = "MessageHeader";
        try (Writer out = this.outputManager.createOutput("MessageHeader");){
            StringBuilder sb = new StringBuilder();
            List<Token> tokens = this.ir.headerStructure().tokens();
            this.imports = new TreeSet();
            this.imports.add("io");
            GolangGenerator.generateTypeDeclaration(sb, "MessageHeader");
            this.generateTypeBodyComposite(sb, "MessageHeader", tokens.subList(1, tokens.size() - 1));
            this.generateEncodeDecode(sb, "MessageHeader", tokens.subList(1, tokens.size() - 1), false, false);
            this.generateCompositePropertyElements(sb, "MessageHeader", tokens.subList(1, tokens.size() - 1));
            out.append(this.generateFileHeader(this.ir.namespaces()));
            out.append(sb);
        }
    }

    @Override
    public void generate() throws IOException {
        if (this.ir.byteOrder() == ByteOrder.LITTLE_ENDIAN) {
            this.generateFileFromTemplate("SbeMarshalling", "SbeMarshallingLittleEndian");
        } else {
            this.generateFileFromTemplate("SbeMarshalling", "SbeMarshallingBigEndian");
        }
        this.generateMessageHeaderStub();
        this.generateTypeStubs();
        for (List<Token> tokens : this.ir.messages()) {
            Token msgToken = tokens.get(0);
            String typeName = GolangUtil.formatTypeName(msgToken.name());
            Writer out = this.outputManager.createOutput(typeName);
            Throwable throwable = null;
            try {
                StringBuilder sb = new StringBuilder();
                this.imports = new TreeSet();
                this.imports.add("io");
                GolangGenerator.generateTypeDeclaration(sb, typeName);
                this.generateTypeBody(sb, typeName, tokens.subList(1, tokens.size() - 1));
                this.generateMessageCode(sb, typeName, tokens);
                List<Token> messageBody = tokens.subList(1, tokens.size() - 1);
                int i = 0;
                ArrayList<Token> fields = new ArrayList<Token>();
                i = GenerationUtil.collectFields(messageBody, i, fields);
                ArrayList<Token> groups = new ArrayList<Token>();
                i = GenerationUtil.collectGroups(messageBody, i, groups);
                ArrayList<Token> varData = new ArrayList<Token>();
                GenerationUtil.collectVarData(messageBody, i, varData);
                this.generateFields(sb, typeName, fields, "");
                this.generateGroups(sb, groups, typeName);
                this.generateGroupProperties(sb, groups, typeName);
                this.generateVarData(sb, typeName, varData, "");
                out.append(this.generateFileHeader(this.ir.namespaces()));
                out.append(sb);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                out.close();
            }
        }
    }

    private String generateEncodeOffset(int gap, String indent) {
        if (gap > 0) {
            return String.format("\n%1$s\tfor i := 0; i < %2$d; i++ {\n%1$s\t\tif err := _m.WriteUint8(_w, uint8(0)); err != nil {\n%1$s\t\t\treturn err\n%1$s\t\t}\n%1$s\t}\n", indent, gap);
        }
        return "";
    }

    private String generateDecodeOffset(int gap, String indent) {
        if (gap > 0) {
            this.imports.add("io");
            this.imports.add("io/ioutil");
            return String.format("%1$s\tio.CopyN(ioutil.Discard, _r, %2$d)\n", indent, gap);
        }
        return "";
    }

    private void generateCharacterEncodingRangeCheck(StringBuilder sb, String varName, Token token) {
        switch (token.encoding().characterEncoding()) {
            case "ASCII": {
                this.imports.add("fmt");
                sb.append(String.format("\tfor idx, ch := range %1$s {\n\t\tif ch > 127 {\n\t\t\treturn fmt.Errorf(\"%1$s[%%d]=%%d failed ASCII validation\", idx, ch)\n\t\t}\n\t}\n", varName));
                break;
            }
            case "UTF-8": {
                this.imports.add("errors");
                this.imports.add("unicode/utf8");
                sb.append(String.format("\tif !utf8.Valid(%1$s[:]) {\n\t\treturn errors.New(\"%1$s failed UTF-8 validation\")\n\t}\n", varName));
            }
        }
    }

    private void generateEncodePrimitive(StringBuilder sb, char varName, String propertyName, Token encodingToken) {
        PrimitiveType primitiveType = encodingToken.encoding().primitiveType();
        String marshalType = GolangUtil.golangMarshalType(primitiveType);
        if (primitiveType == PrimitiveType.CHAR || primitiveType == PrimitiveType.UINT8) {
            if (encodingToken.arrayLength() > 1) {
                sb.append(String.format("\tif err := _m.WriteBytes(_w, %1$s.%2$s[:]); err != nil {\n\t\treturn err\n\t}\n", Character.valueOf(varName), propertyName));
            } else {
                sb.append(String.format("\tif err := _m.WriteUint8(_w, %1$s.%2$s); err != nil {\n\t\treturn err\n\t}\n", Character.valueOf(varName), propertyName));
            }
        } else if (encodingToken.arrayLength() > 1) {
            sb.append(String.format("\tfor idx := 0; idx < %1$d; idx++ {\n\t\tif err := _m.Write%2$s(_w, %3$s.%4$s[idx]); err != nil {\n\t\t\treturn err\n\t\t}\n\t}\n", encodingToken.arrayLength(), marshalType, Character.valueOf(varName), propertyName));
        } else {
            sb.append(String.format("\tif err := _m.Write%1$s(_w, %2$s.%3$s); err != nil {\n\t\treturn err\n\t}\n", marshalType, Character.valueOf(varName), propertyName));
        }
    }

    private void generateDecodePrimitive(StringBuilder sb, String varName, Token token) {
        PrimitiveType primitiveType = token.encoding().primitiveType();
        String marshalType = GolangUtil.golangMarshalType(primitiveType);
        if (token.isConstantEncoding()) {
            if (primitiveType == PrimitiveType.CHAR) {
                if (token.encoding().constValue().size() > 1) {
                    sb.append(String.format("\tcopy(%1$s[:], \"%2$s\")\n", varName, token.encoding().constValue()));
                } else {
                    sb.append(String.format("\t%1$s[0] = %2$s\n", varName, token.encoding().constValue()));
                }
            } else {
                sb.append(String.format("\t%1$s = %2$s\n", varName, this.generateLiteral(primitiveType, token.encoding().constValue().toString())));
            }
        } else if (primitiveType == PrimitiveType.CHAR || primitiveType == PrimitiveType.UINT8) {
            if (token.arrayLength() > 1) {
                sb.append(String.format("\tif !%1$sInActingVersion(actingVersion) {\n\t\tfor idx := 0; idx < %2$s; idx++ {\n\t\t\t%1$s[idx] = %1$sNullValue()\n\t\t}\n\t} else {\n\t\tif err := _m.ReadBytes(_r, %1$s[:]); err != nil {\n\t\t\treturn err\n\t\t}\n\t}\n", varName, token.arrayLength()));
            } else {
                sb.append(String.format("\tif !%1$sInActingVersion(actingVersion) {\n\t\t%1$s = %1$sNullValue()\n\t} else {\n\t\tif err := _m.ReadUint8(_r, &%1$s); err != nil {\n\t\t\treturn err\n\t\t}\n\t}\n", varName));
            }
        } else if (token.arrayLength() > 1) {
            sb.append(String.format("\tif !%2$sInActingVersion(actingVersion) {\n\t\tfor idx := 0; idx < %1$d; idx++ {\n\t\t\t%2$s[idx] = %2$sNullValue()\n\t\t}\n\t} else {\n\t\tfor idx := 0; idx < %1$d; idx++ {\n\t\t\tif err := _m.Read%3$s(_r, &%2$s[idx]); err != nil {\n\t\t\t\treturn err\n\t\t\t}\n\t\t}\n\t}\n", token.arrayLength(), varName, marshalType));
        } else {
            sb.append(String.format("\tif !%1$sInActingVersion(actingVersion) {\n\t\t%1$s = %1$sNullValue()\n\t} else {\n\t\tif err := _m.Read%2$s(_r, &%1$s); err != nil {\n\t\t\treturn err\n\t\t}\n\t}\n", varName, marshalType));
        }
    }

    private void generateRangeCheckPrimitive(StringBuilder sb, String varName, Token token) {
        if (token.isConstantEncoding()) {
            return;
        }
        this.imports.add("fmt");
        if (token.arrayLength() > 1) {
            sb.append(String.format("\tif %1$sInActingVersion(actingVersion) {\n\t\tfor idx := 0; idx < %2$s; idx++ {\n\t\t\tif %1$s[idx] < %1$sMinValue() || %1$s[idx] > %1$sMaxValue() {\n\t\t\t\treturn fmt.Errorf(\"Range check failed on %1$s[%%d] (%%d < %%d > %%d)\", idx, %1$sMinValue(), %1$s[idx], %1$sMaxValue())\n\t\t\t}\n\t\t}\n\t}\n", varName, token.arrayLength()));
        } else {
            sb.append(String.format("\tif %1$sInActingVersion(actingVersion) {\n\t\tif %1$s < %1$sMinValue() || %1$s > %1$sMaxValue() {\n\t\t\treturn fmt.Errorf(\"Range check failed on %1$s (%%d < %%d > %%d)\", %1$sMinValue(), %1$s, %1$sMaxValue())\n\t\t}\n\t}\n", varName));
        }
        if (token.arrayLength() > 1 && token.encoding().primitiveType() == PrimitiveType.CHAR) {
            this.generateCharacterEncodingRangeCheck(sb, varName, token);
        }
    }

    private void generateInitPrimitive(StringBuilder sb, String varName, Token token) {
        if (token.isConstantEncoding()) {
            if (token.encoding().primitiveType() == PrimitiveType.CHAR) {
                if (token.encoding().constValue().size() > 1) {
                    sb.append(String.format("\tcopy(%1$s[:], \"%2$s\")\n", varName, token.encoding().constValue()));
                } else {
                    sb.append(String.format("\t%1$s[0] = %2$s\n", varName, token.encoding().constValue()));
                }
            } else {
                sb.append(String.format("\t%1$s = %2$s\n", varName, this.generateLiteral(token.encoding().primitiveType(), token.encoding().constValue().toString())));
            }
        }
    }

    private void generateEncodeDecodeOpen(StringBuilder encode, StringBuilder decode, StringBuilder rangeCheck, StringBuilder init, char varName, String typeName, Boolean isMessage, Boolean isExtensible) {
        this.generateEncodeHeader(encode, varName, typeName, isMessage);
        this.generateDecodeHeader(decode, varName, typeName, isMessage, isExtensible);
        this.generateRangeCheckHeader(rangeCheck, varName, typeName);
        this.generateInitHeader(init, varName, typeName);
    }

    private void generateEncodeDecodeClose(StringBuilder encode, StringBuilder decode, StringBuilder rangeCheck, StringBuilder init) {
        encode.append("\treturn nil\n}\n");
        decode.append("\treturn nil\n}\n");
        rangeCheck.append("\treturn nil\n}\n");
        init.append("\treturn\n}\n");
    }

    private void generateExtensionCheck(StringBuilder sb, char varName) {
        this.imports.add("io");
        this.imports.add("io/ioutil");
        sb.append(String.format("\tif actingVersion > %1$s.SbeSchemaVersion() && blockLength > %1$s.SbeBlockLength() {\n\t\tio.CopyN(ioutil.Discard, _r, int64(blockLength-%1$s.SbeBlockLength()))\n\t}\n", Character.valueOf(varName)));
    }

    private int generateEncodeDecode(StringBuilder sb, String typeName, List<Token> tokens, boolean isMessage, boolean isExtensible) {
        int gap;
        char varName = Character.toLowerCase(typeName.charAt(0));
        StringBuilder encode = new StringBuilder();
        StringBuilder decode = new StringBuilder();
        StringBuilder init = new StringBuilder();
        StringBuilder rangeCheck = new StringBuilder();
        StringBuilder nested = new StringBuilder();
        int currentOffset = 0;
        boolean extensionStarted = false;
        this.generateEncodeDecodeOpen(encode, decode, rangeCheck, init, varName, typeName, isMessage, isExtensible);
        block11: for (int i = 0; i < tokens.size(); ++i) {
            Token signalToken = tokens.get(i);
            String propertyName = GolangUtil.formatPropertyName(signalToken.name());
            switch (signalToken.signal()) {
                case BEGIN_MESSAGE: {
                    encode.append(String.format("\tif doRangeCheck {\n\t\tif err := %1$s.RangeCheck(%1$s.SbeSchemaVersion(), %1$s.SbeSchemaVersion()); err != nil {\n\t\t\treturn err\n\t\t}\n\t}\n", Character.valueOf(varName)));
                    continue block11;
                }
                case END_MESSAGE: {
                    if (isExtensible && !extensionStarted) {
                        this.generateExtensionCheck(decode, varName);
                        extensionStarted = true;
                    }
                    decode.append(String.format("\tif doRangeCheck {\n\t\tif err := %1$s.RangeCheck(actingVersion, %1$s.SbeSchemaVersion()); err != nil {\n\t\t\treturn err\n\t\t}\n\t}\n", Character.valueOf(varName)));
                    continue block11;
                }
                case BEGIN_ENUM: 
                case BEGIN_SET: {
                    currentOffset += this.generatePropertyEncodeDecode(signalToken, typeName, encode, decode, currentOffset);
                    i += signalToken.componentTokenCount() - 1;
                    continue block11;
                }
                case BEGIN_COMPOSITE: {
                    currentOffset += this.generatePropertyEncodeDecode(signalToken, typeName, encode, decode, currentOffset);
                    i += signalToken.componentTokenCount() - 1;
                    rangeCheck.append(String.format("\tif err := %1$s.%2$s.RangeCheck(actingVersion, schemaVersion); err != nil {\n\t\treturn err\n\t}\n", Character.valueOf(varName), propertyName));
                    continue block11;
                }
                case BEGIN_FIELD: {
                    if (tokens.size() < i + 1) continue block11;
                    currentOffset += this.generateFieldEncodeDecode(tokens.subList(i, tokens.size() - 1), varName, currentOffset, encode, decode, rangeCheck, init);
                    if (tokens.get(i + 1).signal() == Signal.ENCODING) {
                        ++i;
                        continue block11;
                    }
                    i += signalToken.componentTokenCount() - 1;
                    continue block11;
                }
                case ENCODING: {
                    gap = signalToken.offset() - currentOffset;
                    encode.append(this.generateEncodeOffset(gap, ""));
                    decode.append(this.generateDecodeOffset(gap, ""));
                    currentOffset += signalToken.encodedLength() + gap;
                    if (!signalToken.isConstantEncoding()) {
                        this.generateEncodePrimitive(encode, varName, GolangUtil.formatPropertyName(signalToken.name()), signalToken);
                    }
                    String primitive = Character.toString(varName) + "." + propertyName;
                    this.generateDecodePrimitive(decode, primitive, signalToken);
                    this.generateRangeCheckPrimitive(rangeCheck, primitive, signalToken);
                    this.generateInitPrimitive(init, primitive, signalToken);
                    continue block11;
                }
                case BEGIN_GROUP: {
                    if (isExtensible && !extensionStarted) {
                        this.generateExtensionCheck(decode, varName);
                        extensionStarted = true;
                    }
                    currentOffset += this.generateGroupEncodeDecode(tokens.subList(i, tokens.size() - 1), typeName, encode, decode, rangeCheck, currentOffset);
                    gap = Math.max(0, signalToken.encodedLength() - this.generateEncodeDecode(nested, typeName + GolangUtil.toUpperFirstChar(signalToken.name()), tokens.subList(i + 5, tokens.size() - 1), false, true));
                    encode.append(this.generateEncodeOffset(gap, "\t")).append("\t}\n");
                    decode.append(this.generateDecodeOffset(gap, "\t")).append("\t}\n");
                    i += signalToken.componentTokenCount() - 1;
                    continue block11;
                }
                case END_GROUP: {
                    if (isExtensible && !extensionStarted) {
                        this.generateExtensionCheck(decode, varName);
                        extensionStarted = true;
                    }
                    this.generateEncodeDecodeClose(encode, decode, rangeCheck, init);
                    sb.append((CharSequence)encode).append((CharSequence)decode).append((CharSequence)rangeCheck).append((CharSequence)init).append((CharSequence)nested);
                    return currentOffset;
                }
                case BEGIN_VAR_DATA: {
                    if (isExtensible && !extensionStarted) {
                        this.generateExtensionCheck(decode, varName);
                        extensionStarted = true;
                    }
                    currentOffset += this.generateVarDataEncodeDecode(tokens.subList(i, tokens.size() - 1), typeName, encode, decode, rangeCheck, currentOffset);
                    i += signalToken.componentTokenCount() - 1;
                }
            }
        }
        Token endToken = tokens.get(tokens.size() - 1);
        if (endToken.signal() == Signal.END_MESSAGE) {
            gap = endToken.encodedLength() - currentOffset;
            encode.append(this.generateEncodeOffset(gap, ""));
            decode.append(this.generateDecodeOffset(gap, ""));
        }
        this.generateEncodeDecodeClose(encode, decode, rangeCheck, init);
        sb.append((CharSequence)encode).append((CharSequence)decode).append((CharSequence)rangeCheck).append((CharSequence)init).append((CharSequence)nested);
        return currentOffset;
    }

    private void generateEnumEncodeDecode(StringBuilder sb, String enumName, Token token) {
        char varName = Character.toLowerCase(enumName.charAt(0));
        String typeName = GolangUtil.golangTypeName(token.encoding().primitiveType());
        String marshalType = token.encoding().primitiveType() == PrimitiveType.CHAR ? "Uint8" : GolangUtil.golangMarshalType(token.encoding().primitiveType());
        this.generateEncodeHeader(sb, varName, enumName + "Enum", false);
        sb.append(String.format("\tif err := _m.Write%1$s(_w, %2$s(%3$s)); err != nil {\n\t\treturn err\n\t}\n\treturn nil\n}\n", marshalType, typeName, Character.valueOf(varName)));
        this.generateDecodeHeader(sb, varName, enumName + "Enum", false, false);
        sb.append(String.format("\tif err := _m.Read%1$s(_r, (*%2$s)(%3$s)); err != nil {\n\t\treturn err\n\t}\n\treturn nil\n}\n", marshalType, typeName, Character.valueOf(varName)));
        this.imports.add("fmt");
        this.imports.add("reflect");
        this.generateRangeCheckHeader(sb, varName, enumName + "Enum");
        sb.append("\tif actingVersion > schemaVersion {\n\t\treturn nil\n\t}\n");
        sb.append(String.format("\tvalue := reflect.ValueOf(%2$s)\n\tfor idx := 0; idx < value.NumField(); idx++ {\n\t\tif %1$s == value.Field(idx).Interface() {\n\t\t\treturn nil\n\t\t}\n\t}\n\treturn fmt.Errorf(\"Range check failed on %2$s, unknown enumeration value %%d\", %1$s)\n}\n", Character.valueOf(varName), enumName));
    }

    private void generateChoiceEncodeDecode(StringBuilder sb, String choiceName, Token token) {
        char varName = Character.toLowerCase(choiceName.charAt(0));
        this.generateEncodeHeader(sb, varName, choiceName, false);
        sb.append(String.format("\tvar wireval uint%1$d = 0\n\tfor k, v := range %2$s {\n\t\tif v {\n\t\t\twireval |= (1 << uint(k))\n\t\t}\n\t}\n\treturn _m.WriteUint%1$d(_w, wireval)\n}\n", token.encodedLength() * 8, Character.valueOf(varName)));
        this.generateDecodeHeader(sb, varName, choiceName, false, false);
        sb.append(String.format("\tvar wireval uint%1$d\n\n\tif err := _m.ReadUint%1$d(_r, &wireval); err != nil {\n\t\treturn err\n\t}\n\n\tvar idx uint\n\tfor idx = 0; idx < %1$d; idx++ {\n\t\t%2$s[idx] = (wireval & (1 << idx)) > 0\n\t}\n", token.encodedLength() * 8, Character.valueOf(varName)));
        sb.append("\treturn nil\n}\n");
    }

    private void generateEncodeHeader(StringBuilder sb, char varName, String typeName, Boolean isMessage) {
        String messageArgs = "";
        if (isMessage.booleanValue()) {
            messageArgs = ", doRangeCheck bool";
        }
        sb.append(String.format("\nfunc (%1$s %2$s) Encode(_m *SbeGoMarshaller, _w io.Writer" + messageArgs + ") error {\n", Character.valueOf(varName), typeName));
    }

    private void generateDecodeHeader(StringBuilder sb, char varName, String typeName, Boolean isMessage, Boolean isExtensible) {
        String decodeArgs = "";
        String blockLengthType = GolangUtil.golangTypeName(this.ir.headerStructure().blockLengthType());
        if (isExtensible.booleanValue()) {
            decodeArgs = isMessage != false ? decodeArgs + ", blockLength " + blockLengthType : decodeArgs + ", blockLength uint";
        }
        if (isMessage.booleanValue()) {
            decodeArgs = decodeArgs + ", doRangeCheck bool";
        }
        sb.append(String.format("\nfunc (%1$s *%2$s) Decode(_m *SbeGoMarshaller, _r io.Reader, actingVersion uint16" + decodeArgs + ") error {\n", Character.valueOf(varName), typeName));
    }

    private void generateRangeCheckHeader(StringBuilder sb, char varName, String typeName) {
        sb.append(String.format("\nfunc (%1$s %2$s) RangeCheck(actingVersion uint16, schemaVersion uint16) error {\n", Character.valueOf(varName), typeName));
    }

    private void generateInitHeader(StringBuilder sb, char varName, String typeName) {
        sb.append(String.format("\nfunc %1$sInit(%2$s *%1$s) {\n", typeName, Character.valueOf(varName)));
    }

    private int generateFieldEncodeDecode(List<Token> tokens, char varName, int currentOffset, StringBuilder encode, StringBuilder decode, StringBuilder rc, StringBuilder init) {
        Token signalToken = tokens.get(0);
        Token encodingToken = tokens.get(1);
        String propertyName = GolangUtil.formatPropertyName(signalToken.name());
        int gap = 0;
        switch (encodingToken.signal()) {
            case BEGIN_ENUM: 
            case BEGIN_SET: 
            case BEGIN_COMPOSITE: {
                gap = signalToken.offset() - currentOffset;
                encode.append(this.generateEncodeOffset(gap, ""));
                decode.append(this.generateDecodeOffset(gap, ""));
                if (signalToken.isConstantEncoding()) {
                    decode.append(String.format("\t%1$s.%2$s = %3$s\n", Character.valueOf(varName), propertyName, signalToken.encoding().constValue()));
                    init.append(String.format("\t%1$s.%2$s = %3$s\n", Character.valueOf(varName), propertyName, signalToken.encoding().constValue()));
                } else {
                    encode.append(String.format("\tif err := %1$s.%2$s.Encode(_m, _w); err != nil {\n\t\treturn err\n\t}\n", Character.valueOf(varName), propertyName));
                    decode.append(String.format("\tif %1$s.%2$sInActingVersion(actingVersion) {\n\t\tif err := %1$s.%2$s.Decode(_m, _r, actingVersion); err != nil {\n\t\t\treturn err\n\t\t}\n\t}\n", Character.valueOf(varName), propertyName));
                }
                if (encodingToken.signal() != Signal.BEGIN_ENUM) break;
                rc.append(String.format("\tif err := %1$s.%2$s.RangeCheck(actingVersion, schemaVersion); err != nil {\n\t\treturn err\n\t}\n", Character.valueOf(varName), propertyName));
                break;
            }
            case ENCODING: {
                gap = encodingToken.offset() - currentOffset;
                encode.append(this.generateEncodeOffset(gap, ""));
                decode.append(this.generateDecodeOffset(gap, ""));
                if (!encodingToken.isConstantEncoding()) {
                    this.generateEncodePrimitive(encode, varName, GolangUtil.formatPropertyName(signalToken.name()), encodingToken);
                }
                String primitive = Character.toString(varName) + "." + propertyName;
                this.generateDecodePrimitive(decode, primitive, encodingToken);
                this.generateRangeCheckPrimitive(rc, primitive, encodingToken);
                this.generateInitPrimitive(init, primitive, encodingToken);
            }
        }
        return encodingToken.encodedLength() + gap;
    }

    private int generatePropertyEncodeDecode(Token token, String typeName, StringBuilder encode, StringBuilder decode, int currentOffset) {
        char varName = Character.toLowerCase(typeName.charAt(0));
        String propertyName = GolangUtil.formatPropertyName(token.name());
        int gap = token.offset() - currentOffset;
        encode.append(this.generateEncodeOffset(gap, ""));
        decode.append(this.generateDecodeOffset(gap, ""));
        encode.append(String.format("\tif err := %1$s.%2$s.Encode(_m, _w); err != nil {\n\t\treturn err\n\t}\n", Character.valueOf(varName), propertyName));
        decode.append(String.format("\tif %1$s.%2$sInActingVersion(actingVersion) {\n\t\tif err := %1$s.%2$s.Decode(_m, _r, actingVersion); err != nil {\n\t\t\treturn err\n\t\t}\n\t}\n", Character.valueOf(varName), propertyName));
        return token.encodedLength() + gap;
    }

    private int generateVarDataEncodeDecode(List<Token> tokens, String typeName, StringBuilder encode, StringBuilder decode, StringBuilder rc, int currentOffset) {
        Token signalToken = tokens.get(0);
        char varName = Character.toLowerCase(typeName.charAt(0));
        String propertyName = GolangUtil.formatPropertyName(signalToken.name());
        int gap = Math.max(signalToken.offset() - currentOffset, 0);
        encode.append(this.generateEncodeOffset(gap, ""));
        decode.append(this.generateDecodeOffset(gap, ""));
        String golangTypeForLength = GolangUtil.golangTypeName(tokens.get(2).encoding().primitiveType());
        String golangTypeForLengthMarshal = GolangUtil.golangMarshalType(tokens.get(2).encoding().primitiveType());
        String golangTypeForData = GolangUtil.golangTypeName(tokens.get(3).encoding().primitiveType());
        this.generateCharacterEncodingRangeCheck(rc, varName + "." + propertyName, tokens.get(3));
        encode.append(String.format("\tif err := _m.Write%1$s(_w, %2$s(len(%3$s.%4$s))); err != nil {\n\t\treturn err\n\t}\n\tif err := _m.WriteBytes(_w, %3$s.%4$s); err != nil {\n\t\treturn err\n\t}\n", golangTypeForLengthMarshal, golangTypeForLength, Character.valueOf(varName), propertyName));
        decode.append(String.format("\n\tif %1$c.%2$sInActingVersion(actingVersion) {\n\t\tvar %2$sLength %4$s\n\t\tif err := _m.Read%3$s(_r, &%2$sLength); err != nil {\n\t\t\treturn err\n\t\t}\n\t\tif cap(%1$c.%2$s) < int(%2$sLength) {\n\t\t\t%1$s.%2$s = make([]%5$s, %2$sLength)\n\t\t}\n\t\tif err := _m.ReadBytes(_r, %1$c.%2$s); err != nil {\n\t\t\treturn err\n\t\t}\n\t}\n", Character.valueOf(varName), propertyName, golangTypeForLengthMarshal, golangTypeForLength, golangTypeForData));
        return gap;
    }

    private int generateGroupEncodeDecode(List<Token> tokens, String typeName, StringBuilder encode, StringBuilder decode, StringBuilder rc, int currentOffset) {
        char varName = Character.toLowerCase(typeName.charAt(0));
        Token signalToken = tokens.get(0);
        String propertyName = GolangUtil.formatPropertyName(signalToken.name());
        String blockLengthType = GolangUtil.golangTypeName(tokens.get(2).encoding().primitiveType());
        String blockLengthMarshalType = GolangUtil.golangMarshalType(tokens.get(2).encoding().primitiveType());
        String numInGroupType = GolangUtil.golangTypeName(tokens.get(3).encoding().primitiveType());
        String numInGroupMarshalType = GolangUtil.golangMarshalType(tokens.get(3).encoding().primitiveType());
        int gap = Math.max(signalToken.offset() - currentOffset, 0);
        encode.append(this.generateEncodeOffset(gap, ""));
        decode.append(this.generateDecodeOffset(gap, ""));
        encode.append(String.format("\n\tvar %7$sBlockLength %1$s = %2$d\n\tvar %7$sNumInGroup %3$s = %3$s(len(%4$s.%5$s))\n\tif err := _m.Write%6$s(_w, %7$sBlockLength); err != nil {\n\t\treturn err\n\t}\n\tif err := _m.Write%8$s(_w, %7$sNumInGroup); err != nil {\n\t\treturn err\n\t}\n", blockLengthType, signalToken.encodedLength(), numInGroupType, Character.valueOf(varName), GolangUtil.toUpperFirstChar(signalToken.name()), blockLengthMarshalType, propertyName, numInGroupMarshalType));
        encode.append(String.format("\tfor _, prop := range %1$s.%2$s {\n\t\tif err := prop.Encode(_m, _w); err != nil {\n\t\t\treturn err\n\t\t}\n", Character.valueOf(varName), GolangUtil.toUpperFirstChar(signalToken.name())));
        decode.append(String.format("\n\tif %1$s.%2$sInActingVersion(actingVersion) {\n\t\tvar %2$sBlockLength %3$s\n\t\tvar %2$sNumInGroup %4$s\n\t\tif err := _m.Read%5$s(_r, &%2$sBlockLength); err != nil {\n\t\t\treturn err\n\t\t}\n\t\tif err := _m.Read%6$s(_r, &%2$sNumInGroup); err != nil {\n\t\t\treturn err\n\t\t}\n", Character.valueOf(varName), propertyName, blockLengthType, numInGroupType, blockLengthMarshalType, numInGroupMarshalType));
        decode.append(String.format("\t\tif cap(%1$c.%2$s) < int(%2$sNumInGroup) {\n\t\t\t%1$s.%2$s = make([]%3$s%2$s, %2$sNumInGroup)\n\t\t}\n\t\tfor i, _ := range %1$s.%2$s {\n\t\t\tif err := %1$s.%2$s[i].Decode(_m, _r, actingVersion, uint(%4$sBlockLength)); err != nil {\n\t\t\t\treturn err\n\t\t\t}\n\t\t}\n", Character.valueOf(varName), GolangUtil.toUpperFirstChar(signalToken.name()), typeName, propertyName));
        rc.append(String.format("\tfor _, prop := range %1$s.%2$s {\n\t\tif err := prop.RangeCheck(actingVersion, schemaVersion); err != nil {\n\t\t\treturn err\n\t\t}\n\t}\n", Character.valueOf(varName), GolangUtil.toUpperFirstChar(signalToken.name())));
        return gap;
    }

    private void generateGroupProperties(StringBuilder sb, List<Token> tokens, String prefix) {
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token token = tokens.get(i);
            if (token.signal() != Signal.BEGIN_GROUP) continue;
            String propertyName = GolangUtil.formatPropertyName(token.name());
            this.generateId(sb, prefix, propertyName, token);
            this.generateSinceActingDeprecated(sb, prefix, propertyName, token);
            this.generateExtensibilityMethods(sb, prefix + propertyName, token);
            this.generateGroupProperties(sb, tokens.subList(i + 1, i + token.componentTokenCount() - 1), prefix + propertyName);
            i += token.componentTokenCount() - 1;
        }
    }

    private void generateGroups(StringBuilder sb, List<Token> tokens, String prefix) {
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token groupToken = tokens.get(i);
            if (groupToken.signal() != Signal.BEGIN_GROUP) {
                throw new IllegalStateException("tokens must begin with BEGIN_GROUP: token=" + groupToken);
            }
            String groupName = prefix + GolangUtil.formatTypeName(groupToken.name());
            int groupHeaderTokenCount = tokens.get(++i).componentTokenCount();
            i += groupHeaderTokenCount;
            ArrayList<Token> fields = new ArrayList<Token>();
            i = GenerationUtil.collectFields(tokens, i, fields);
            this.generateFields(sb, groupName, fields, prefix);
            ArrayList<Token> groups = new ArrayList<Token>();
            i = GenerationUtil.collectGroups(tokens, i, groups);
            this.generateGroups(sb, groups, groupName);
            ArrayList<Token> varData = new ArrayList<Token>();
            i = GenerationUtil.collectVarData(tokens, i, varData);
            this.generateVarData(sb, GolangUtil.formatTypeName(groupName), varData, prefix);
        }
    }

    private void generateVarData(StringBuilder sb, String typeName, List<Token> tokens, String prefix) {
        Token token;
        int size = tokens.size();
        for (int i = 0; i < size; i += token.componentTokenCount()) {
            token = tokens.get(i);
            if (token.signal() != Signal.BEGIN_VAR_DATA) {
                throw new IllegalStateException("tokens must begin with BEGIN_VAR_DATA: token=" + token);
            }
            String propertyName = GolangUtil.toUpperFirstChar(token.name());
            String characterEncoding = tokens.get(i + 3).encoding().characterEncoding();
            Token lengthToken = tokens.get(i + 2);
            int lengthOfLengthField = lengthToken.encodedLength();
            GolangGenerator.generateFieldMetaAttributeMethod(sb, typeName, token, prefix);
            this.generateVarDataDescriptors(sb, token, typeName, propertyName, characterEncoding, lengthOfLengthField);
        }
    }

    private void generateVarDataDescriptors(StringBuilder sb, Token token, String typeName, String propertyName, String characterEncoding, Integer lengthOfLengthField) {
        char varName = Character.toLowerCase(typeName.charAt(0));
        this.generateSinceActingDeprecated(sb, typeName, propertyName, token);
        sb.append(String.format("\nfunc (%1$s %2$s) %3$sCharacterEncoding() string {\n\treturn \"%4$s\"\n}\n\nfunc (%1$s %2$s) %3$sHeaderLength() uint64 {\n\treturn %5$s\n}\n", Character.valueOf(varName), typeName, propertyName, characterEncoding, lengthOfLengthField));
    }

    private void generateChoiceSet(List<Token> tokens) throws IOException {
        Token choiceToken = tokens.get(0);
        String choiceName = GolangUtil.formatTypeName(choiceToken.applicableTypeName());
        char varName = Character.toLowerCase(choiceName.charAt(0));
        StringBuilder sb = new StringBuilder();
        try (Writer out = this.outputManager.createOutput(choiceName);){
            this.imports = new TreeSet();
            this.imports.add("io");
            this.generateChoiceDecls(sb, choiceName, tokens.subList(1, tokens.size() - 1), choiceToken);
            this.generateChoiceEncodeDecode(sb, choiceName, choiceToken);
            sb.append(String.format("\nfunc (%1$s %2$s) EncodedLength() int64 {\n\treturn %3$s\n}\n", Character.valueOf(varName), choiceName, choiceToken.encodedLength()));
            for (Token token : tokens.subList(1, tokens.size() - 1)) {
                this.generateSinceActingDeprecated(sb, choiceName, token.name(), token);
            }
            out.append(this.generateFileHeader(this.ir.namespaces()));
            out.append(sb);
        }
    }

    private void generateEnum(List<Token> tokens) throws IOException {
        Token enumToken = tokens.get(0);
        String enumName = GolangUtil.formatTypeName(tokens.get(0).applicableTypeName());
        char varName = Character.toLowerCase(enumName.charAt(0));
        StringBuilder sb = new StringBuilder();
        try (Writer out = this.outputManager.createOutput(enumName);){
            this.imports = new TreeSet();
            this.imports.add("io");
            this.generateEnumDecls(sb, enumName, GolangUtil.golangTypeName(tokens.get(0).encoding().primitiveType()), tokens.subList(1, tokens.size() - 1), enumToken);
            this.generateEnumEncodeDecode(sb, enumName, enumToken);
            sb.append(String.format("\nfunc (%1$s %2$sEnum) EncodedLength() int64 {\n\treturn %3$s\n}\n", Character.valueOf(varName), enumName, enumToken.encodedLength()));
            for (Token token : tokens.subList(1, tokens.size() - 1)) {
                this.generateSinceActingDeprecated(sb, enumName + "Enum", token.name(), token);
            }
            out.append(this.generateFileHeader(this.ir.namespaces()));
            out.append(sb);
        }
    }

    private void generateComposite(List<Token> tokens, String namePrefix) throws IOException {
        String compositeName = namePrefix + GolangUtil.formatTypeName(tokens.get(0).applicableTypeName());
        StringBuilder sb = new StringBuilder();
        try (Writer out = this.outputManager.createOutput(compositeName);){
            this.imports = new TreeSet();
            this.imports.add("io");
            GolangGenerator.generateTypeDeclaration(sb, compositeName);
            this.generateTypeBodyComposite(sb, compositeName, tokens.subList(1, tokens.size() - 1));
            this.generateEncodeDecode(sb, compositeName, tokens.subList(1, tokens.size() - 1), false, false);
            this.generateEncodedLength(sb, compositeName, tokens.get(0).encodedLength());
            this.generateCompositePropertyElements(sb, compositeName, tokens.subList(1, tokens.size() - 1));
            out.append(this.generateFileHeader(this.ir.namespaces()));
            out.append(sb);
        }
    }

    private void generateEnumDecls(StringBuilder sb, String enumName, String golangType, List<Token> tokens, Token encodingToken) {
        String nullValue = "NullValue";
        int longest = "NullValue".length();
        for (Token token : tokens) {
            longest = Math.max(longest, token.name().length());
        }
        sb.append(String.format("type %1$sEnum %2$s\ntype %1$sValues struct {\n", enumName, golangType));
        for (Token token : tokens) {
            sb.append(String.format("\t%1$s%2$s%3$sEnum\n", token.name(), String.format(String.format("%%%ds", longest - token.name().length() + 1), " "), enumName));
        }
        sb.append(String.format("\t%1$s%2$s%3$sEnum\n}\n", "NullValue", String.format(String.format("%%%ds", longest - "NullValue".length() + 1), " "), enumName));
        sb.append(String.format("\nvar %1$s = %1$sValues{", enumName));
        for (Token token : tokens) {
            sb.append(this.generateLiteral(token.encoding().primitiveType(), token.encoding().constValue().toString())).append(", ");
        }
        sb.append(encodingToken.encoding().applicableNullValue().toString()).append("}\n");
    }

    private void generateChoiceDecls(StringBuilder sb, String choiceName, List<Token> tokens, Token encodingToken) {
        int longest = 0;
        for (Token token : tokens) {
            longest = Math.max(longest, token.name().length());
        }
        sb.append(String.format("type %1$s [%2$d]bool\ntype %1$sChoiceValue uint8\ntype %1$sChoiceValues struct {\n", choiceName, encodingToken.encodedLength() * 8));
        for (Token token : tokens) {
            sb.append(String.format("\t%1$s%2$s%3$sChoiceValue\n", GolangUtil.toUpperFirstChar(token.name()), String.format(String.format("%%%ds", longest - token.name().length() + 1), " "), GolangUtil.toUpperFirstChar(encodingToken.applicableTypeName())));
        }
        sb.append("}\n");
        sb.append(String.format("\nvar %1$sChoice = %1$sChoiceValues{", choiceName));
        String comma = "";
        for (Token token : tokens) {
            sb.append(comma).append(this.generateLiteral(token.encoding().primitiveType(), token.encoding().constValue().toString()));
            comma = ", ";
        }
        sb.append("}\n");
    }

    private String namespacesToPackageName(CharSequence[] namespaces) {
        return String.join((CharSequence)"_", namespaces).toLowerCase().replace('.', '_').replace(' ', '_').replace('-', '_');
    }

    private StringBuilder generateFileHeader(CharSequence[] namespaces) {
        StringBuilder sb = new StringBuilder();
        sb.append("// Generated SBE (Simple Binary Encoding) message codec\n\n");
        sb.append(String.format("package %1$s\n\nimport (\n", this.namespacesToPackageName(namespaces)));
        for (String s : this.imports) {
            sb.append("\t\"").append(s).append("\"\n");
        }
        sb.append(")\n\n");
        return sb;
    }

    private String generateFromTemplate(CharSequence[] namespaces, String templateName) throws IOException {
        String jarFile = "golang/templates/" + templateName + ".go";
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(jarFile);
        Scanner s = new Scanner(inputStream).useDelimiter("\\A");
        String template = s.hasNext() ? s.next() : "";
        inputStream.close();
        return String.format(template, this.namespacesToPackageName(namespaces));
    }

    private static void generateTypeDeclaration(StringBuilder sb, String typeName) {
        sb.append(String.format("type %s struct {\n", typeName));
    }

    private void generateTypeBody(StringBuilder sb, String typeName, List<Token> tokens) {
        int longest = 0;
        block15: for (int i = 0; i < tokens.size(); ++i) {
            Token token = tokens.get(i);
            String propertyName = GolangUtil.formatPropertyName(token.name());
            switch (token.signal()) {
                case BEGIN_GROUP: 
                case BEGIN_VAR_DATA: {
                    longest = Math.max(longest, propertyName.length());
                    i += token.componentTokenCount() - 1;
                    continue block15;
                }
                case BEGIN_FIELD: {
                    longest = Math.max(longest, propertyName.length());
                    continue block15;
                }
                case END_GROUP: {
                    i = tokens.size();
                }
            }
        }
        StringBuilder nested = new StringBuilder();
        block16: for (int i = 0; i < tokens.size(); ++i) {
            Token signalToken = tokens.get(i);
            String propertyName = GolangUtil.formatPropertyName(signalToken.name());
            switch (signalToken.signal()) {
                case BEGIN_FIELD: {
                    if (tokens.size() <= i + 1) continue block16;
                    Token encodingToken = tokens.get(i + 1);
                    String arrayspec = "";
                    if (encodingToken.arrayLength() > 1) {
                        arrayspec = "[" + encodingToken.arrayLength() + "]";
                    }
                    switch (encodingToken.signal()) {
                        case BEGIN_ENUM: {
                            sb.append("\t").append(propertyName).append(String.format(String.format("%%%ds", longest - propertyName.length() + 1), " ")).append(arrayspec).append(encodingToken.applicableTypeName()).append("Enum\n");
                            break;
                        }
                        case BEGIN_SET: {
                            sb.append("\t").append(propertyName).append(String.format(String.format("%%%ds", longest - propertyName.length() + 1), " ")).append(arrayspec).append(encodingToken.applicableTypeName()).append("\n");
                            break;
                        }
                        default: {
                            String golangType = GolangUtil.golangTypeName(encodingToken.encoding().primitiveType());
                            if (golangType == null) {
                                golangType = GolangUtil.toUpperFirstChar(encodingToken.name());
                            }
                            if (encodingToken.isConstantEncoding() && encodingToken.encoding().primitiveType() == PrimitiveType.CHAR) {
                                arrayspec = "[" + encodingToken.encoding().constValue().size() + "]";
                            }
                            sb.append("\t").append(propertyName).append(String.format(String.format("%%%ds", longest - propertyName.length() + 1), " ")).append(arrayspec).append(golangType).append("\n");
                        }
                    }
                    ++i;
                    continue block16;
                }
                case BEGIN_GROUP: {
                    sb.append(String.format("\t%1$s%2$s[]%3$s%1$s\n", GolangUtil.toUpperFirstChar(signalToken.name()), String.format(String.format("%%%ds", longest - propertyName.length() + 1), " "), typeName));
                    GolangGenerator.generateTypeDeclaration(nested, typeName + GolangUtil.toUpperFirstChar(signalToken.name()));
                    this.generateTypeBody(nested, typeName + GolangUtil.toUpperFirstChar(signalToken.name()), tokens.subList(i + 1, tokens.size() - 1));
                    i += signalToken.componentTokenCount() - 1;
                    continue block16;
                }
                case END_GROUP: {
                    sb.append("}\n");
                    sb.append((CharSequence)nested);
                    return;
                }
                case BEGIN_VAR_DATA: {
                    sb.append(String.format("\t%1$s%2$s[]%3$s\n", GolangUtil.toUpperFirstChar(signalToken.name()), String.format(String.format("%%%ds", longest - propertyName.length() + 1), " "), GolangUtil.golangTypeName(tokens.get(i + 3).encoding().primitiveType())));
                    continue block16;
                }
            }
        }
        sb.append("}\n");
        sb.append((CharSequence)nested);
    }

    private void generateCompositePropertyElements(StringBuilder sb, String containingTypeName, List<Token> tokens) {
        block6: for (int i = 0; i < tokens.size(); i += tokens.get(i).componentTokenCount()) {
            Token token = tokens.get(i);
            String propertyName = GolangUtil.formatPropertyName(token.name());
            switch (token.signal()) {
                case ENCODING: {
                    this.generateMinMaxNull(sb, containingTypeName, propertyName, token);
                    this.generateCharacterEncoding(sb, containingTypeName, propertyName, token);
                    break;
                }
            }
            switch (token.signal()) {
                case BEGIN_ENUM: 
                case BEGIN_SET: 
                case BEGIN_COMPOSITE: 
                case ENCODING: {
                    this.generateSinceActingDeprecated(sb, containingTypeName, propertyName, token);
                    continue block6;
                }
            }
        }
    }

    private void generateMinMaxNull(StringBuilder sb, String typeName, String propertyName, Token token) {
        Encoding encoding = token.encoding();
        PrimitiveType primitiveType = encoding.primitiveType();
        String golangTypeName = GolangUtil.golangTypeName(primitiveType);
        CharSequence nullValueString = this.generateNullValueLiteral(primitiveType, encoding);
        CharSequence maxValueString = this.generateMaxValueLiteral(primitiveType, encoding);
        CharSequence minValueString = this.generateMinValueLiteral(primitiveType, encoding);
        sb.append(String.format("\nfunc (%1$s %2$s) %3$sMinValue() %4$s {\n\treturn %5$s\n}\n", Character.valueOf(Character.toLowerCase(typeName.charAt(0))), typeName, propertyName, golangTypeName, minValueString));
        sb.append(String.format("\nfunc (%1$s %2$s) %3$sMaxValue() %4$s {\n\treturn %5$s\n}\n", Character.valueOf(Character.toLowerCase(typeName.charAt(0))), typeName, propertyName, golangTypeName, maxValueString));
        sb.append(String.format("\nfunc (%1$s %2$s) %3$sNullValue() %4$s {\n\treturn %5$s\n}\n", Character.valueOf(Character.toLowerCase(typeName.charAt(0))), typeName, propertyName, golangTypeName, nullValueString));
    }

    private void generateCharacterEncoding(StringBuilder sb, String typeName, String propertyName, Token token) {
        if (token.encoding().primitiveType() == PrimitiveType.CHAR && token.arrayLength() > 1) {
            sb.append(String.format("\nfunc (%1$s %2$s) %3$sCharacterEncoding() string {\n\treturn \"%4$s\"\n}\n", Character.valueOf(Character.toLowerCase(typeName.charAt(0))), typeName, propertyName, token.encoding().characterEncoding()));
        }
    }

    private void generateId(StringBuilder sb, String typeName, String propertyName, Token token) {
        sb.append(String.format("\nfunc (%1$s %2$s) %3$sId() uint16 {\n\treturn %4$s\n}\n", Character.valueOf(Character.toLowerCase(typeName.charAt(0))), typeName, propertyName, token.id()));
    }

    private void generateSinceActingDeprecated(StringBuilder sb, String typeName, String propertyName, Token token) {
        sb.append(String.format("\nfunc (%1$s %2$s) %3$sSinceVersion() uint16 {\n\treturn %4$s\n}\n\nfunc (%1$s %2$s) %3$sInActingVersion(actingVersion uint16) bool {\n\treturn actingVersion >= %1$s.%3$sSinceVersion()\n}\n\nfunc (%1$s %2$s) %3$sDeprecated() uint16 {\n\treturn %5$s\n}\n", Character.valueOf(Character.toLowerCase(typeName.charAt(0))), typeName, propertyName, token.version(), token.deprecated()));
    }

    private void generateTypeBodyComposite(StringBuilder sb, String typeName, List<Token> tokens) throws IOException {
        String propertyName;
        Token token;
        int i;
        int longest = 0;
        block11: for (i = 0; i < tokens.size(); ++i) {
            token = tokens.get(i);
            propertyName = GolangUtil.formatPropertyName(token.name());
            switch (token.signal()) {
                case BEGIN_COMPOSITE: 
                case BEGIN_GROUP: 
                case BEGIN_VAR_DATA: {
                    longest = Math.max(longest, propertyName.length());
                    i += token.componentTokenCount() - 1;
                    continue block11;
                }
                case BEGIN_ENUM: 
                case BEGIN_SET: 
                case ENCODING: {
                    longest = Math.max(longest, propertyName.length());
                    continue block11;
                }
                case END_COMPOSITE: {
                    i = tokens.size();
                }
            }
        }
        block12: for (i = 0; i < tokens.size(); ++i) {
            token = tokens.get(i);
            propertyName = GolangUtil.formatPropertyName(token.name());
            String propertyType = GolangUtil.formatPropertyName(token.applicableTypeName());
            int arrayLength = token.arrayLength();
            switch (token.signal()) {
                case ENCODING: {
                    if (token.isConstantEncoding() && token.encoding().primitiveType() == PrimitiveType.CHAR) {
                        arrayLength = token.encoding().constValue().size();
                        sb.append("\t").append(propertyName).append(String.format(String.format("%%%ds", longest - propertyName.length() + 1), " ")).append("[").append(arrayLength).append("]").append(GolangUtil.golangTypeName(token.encoding().primitiveType())).append("\n");
                        continue block12;
                    }
                    sb.append("\t").append(propertyName).append(String.format(String.format("%%%ds", longest - propertyName.length() + 1), " ")).append(arrayLength > 1 ? "[" + arrayLength + "]" : "").append(GolangUtil.golangTypeName(token.encoding().primitiveType())).append("\n");
                    continue block12;
                }
                case BEGIN_ENUM: {
                    sb.append("\t").append(propertyName).append(String.format(String.format("%%%ds", longest - propertyName.length() + 1), " ")).append(arrayLength > 1 ? "[" + arrayLength + "]" : "").append(propertyType).append("Enum\n");
                    continue block12;
                }
                case BEGIN_SET: {
                    sb.append("\t").append(propertyName).append(String.format(String.format("%%%ds", longest - propertyName.length() + 1), " ")).append(arrayLength > 1 ? "[" + arrayLength + "]" : "").append(propertyType).append("\n");
                    continue block12;
                }
                case BEGIN_COMPOSITE: {
                    this.generateComposite(tokens.subList(i, tokens.size()), typeName);
                    i += token.componentTokenCount() - 2;
                    sb.append("\t").append(propertyName).append(String.format(String.format("%%%ds", longest - propertyName.length() + 1), " ")).append(arrayLength > 1 ? "[" + arrayLength + "]" : "").append(typeName).append(propertyName).append("\n");
                }
            }
        }
        sb.append("}\n");
    }

    private void generateEncodedLength(StringBuilder sb, String typeName, int size) {
        sb.append(String.format("\nfunc (%1$s %2$s) EncodedLength() int64 {\n\treturn %3$s\n}\n", Character.valueOf(Character.toLowerCase(typeName.charAt(0))), typeName, size));
    }

    private void generateMessageCode(StringBuilder sb, String typeName, List<Token> tokens) {
        Token token = tokens.get(0);
        String semanticType = token.encoding().semanticType() == null ? "" : token.encoding().semanticType();
        String blockLengthType = GolangUtil.golangTypeName(this.ir.headerStructure().blockLengthType());
        String templateIdType = GolangUtil.golangTypeName(this.ir.headerStructure().templateIdType());
        String schemaIdType = GolangUtil.golangTypeName(this.ir.headerStructure().schemaIdType());
        String schemaVersionType = GolangUtil.golangTypeName(this.ir.headerStructure().schemaVersionType());
        this.generateEncodeDecode(sb, typeName, tokens, true, true);
        sb.append(String.format("\nfunc (%1$s %2$s) SbeBlockLength() (blockLength %3$s) {\n\treturn %4$s\n}\n\nfunc (%1$s %2$s) SbeTemplateId() (templateId %5$s) {\n\treturn %6$s\n}\n\nfunc (%1$s %2$s) SbeSchemaId() (schemaId %7$s) {\n\treturn %8$s\n}\n\nfunc (%1$s %2$s) SbeSchemaVersion() (schemaVersion %9$s) {\n\treturn %10$s\n}\n\nfunc (%1$s %2$s) SbeSemanticType() (semanticType []byte) {\n\treturn []byte(\"%11$s\")\n}\n", Character.valueOf(Character.toLowerCase(typeName.charAt(0))), typeName, blockLengthType, this.generateLiteral(this.ir.headerStructure().blockLengthType(), Integer.toString(token.encodedLength())), templateIdType, this.generateLiteral(this.ir.headerStructure().templateIdType(), Integer.toString(token.id())), schemaIdType, this.generateLiteral(this.ir.headerStructure().schemaIdType(), Integer.toString(this.ir.id())), schemaVersionType, this.generateLiteral(this.ir.headerStructure().schemaVersionType(), Integer.toString(this.ir.version())), semanticType));
    }

    private void generateExtensibilityMethods(StringBuilder sb, String typeName, Token token) {
        sb.append(String.format("\nfunc (%1$s %2$s) SbeBlockLength() (blockLength uint) {\n\treturn %3$s\n}\n\nfunc (%1$s %2$s) SbeSchemaVersion() (schemaVersion %4$s) {\n\treturn %5$s\n}\n", Character.valueOf(Character.toLowerCase(typeName.charAt(0))), typeName, this.generateLiteral(this.ir.headerStructure().blockLengthType(), Integer.toString(token.encodedLength())), GolangUtil.golangTypeName(this.ir.headerStructure().schemaVersionType()), this.generateLiteral(this.ir.headerStructure().schemaVersionType(), Integer.toString(this.ir.version()))));
    }

    private void generateFields(StringBuilder sb, String containingTypeName, List<Token> tokens, String prefix) {
        int size = tokens.size();
        block6: for (int i = 0; i < size; ++i) {
            Token signalToken = tokens.get(i);
            if (signalToken.signal() != Signal.BEGIN_FIELD) continue;
            Token encodingToken = tokens.get(i + 1);
            String propertyName = GolangUtil.formatPropertyName(signalToken.name());
            this.generateId(sb, containingTypeName, propertyName, signalToken);
            this.generateSinceActingDeprecated(sb, containingTypeName, propertyName, signalToken);
            GolangGenerator.generateFieldMetaAttributeMethod(sb, containingTypeName, signalToken, prefix);
            switch (encodingToken.signal()) {
                case ENCODING: {
                    this.generateMinMaxNull(sb, containingTypeName, propertyName, encodingToken);
                    this.generateCharacterEncoding(sb, containingTypeName, propertyName, encodingToken);
                    continue block6;
                }
                case BEGIN_ENUM: {
                    continue block6;
                }
                case BEGIN_SET: {
                    continue block6;
                }
                case BEGIN_COMPOSITE: {
                    continue block6;
                }
            }
        }
    }

    private static void generateFieldMetaAttributeMethod(StringBuilder sb, String containingTypeName, Token token, String prefix) {
        Encoding encoding = token.encoding();
        String epoch = encoding.epoch() == null ? "" : encoding.epoch();
        String timeUnit = encoding.timeUnit() == null ? "" : encoding.timeUnit();
        String semanticType = encoding.semanticType() == null ? "" : encoding.semanticType();
        sb.append(String.format("\nfunc (%1$s %2$s) %3$sMetaAttribute(meta int) string {\n\tswitch meta {\n\tcase 1:\n\t\treturn \"%4$s\"\n\tcase 2:\n\t\treturn \"%5$s\"\n\tcase 3:\n\t\treturn \"%6$s\"\n\t}\n\treturn \"\"\n}\n", Character.valueOf(Character.toLowerCase(containingTypeName.charAt(0))), containingTypeName, GolangUtil.toUpperFirstChar(token.name()), epoch, timeUnit, semanticType));
    }

    private CharSequence generateMinValueLiteral(PrimitiveType primitiveType, Encoding encoding) {
        if (null == encoding.maxValue()) {
            switch (primitiveType) {
                case CHAR: {
                    return "byte(32)";
                }
                case INT8: {
                    this.imports.add("math");
                    return "math.MinInt8 + 1";
                }
                case INT16: {
                    this.imports.add("math");
                    return "math.MinInt16 + 1";
                }
                case INT32: {
                    this.imports.add("math");
                    return "math.MinInt32 + 1";
                }
                case INT64: {
                    this.imports.add("math");
                    return "math.MinInt64 + 1";
                }
                case UINT8: 
                case UINT16: 
                case UINT32: 
                case UINT64: {
                    return "0";
                }
                case FLOAT: {
                    this.imports.add("math");
                    return "-math.MaxFloat32";
                }
                case DOUBLE: {
                    this.imports.add("math");
                    return "-math.MaxFloat64";
                }
            }
        }
        return this.generateLiteral(primitiveType, encoding.applicableMinValue().toString());
    }

    private CharSequence generateMaxValueLiteral(PrimitiveType primitiveType, Encoding encoding) {
        if (null == encoding.maxValue()) {
            switch (primitiveType) {
                case CHAR: {
                    return "byte(126)";
                }
                case INT8: {
                    this.imports.add("math");
                    return "math.MaxInt8";
                }
                case INT16: {
                    this.imports.add("math");
                    return "math.MaxInt16";
                }
                case INT32: {
                    this.imports.add("math");
                    return "math.MaxInt32";
                }
                case INT64: {
                    this.imports.add("math");
                    return "math.MaxInt64";
                }
                case UINT8: {
                    this.imports.add("math");
                    return "math.MaxUint8 - 1";
                }
                case UINT16: {
                    this.imports.add("math");
                    return "math.MaxUint16 - 1";
                }
                case UINT32: {
                    this.imports.add("math");
                    return "math.MaxUint32 - 1";
                }
                case UINT64: {
                    this.imports.add("math");
                    return "math.MaxUint64 - 1";
                }
                case FLOAT: {
                    this.imports.add("math");
                    return "math.MaxFloat32";
                }
                case DOUBLE: {
                    this.imports.add("math");
                    return "math.MaxFloat64";
                }
            }
        }
        return this.generateLiteral(primitiveType, encoding.applicableMaxValue().toString());
    }

    private CharSequence generateNullValueLiteral(PrimitiveType primitiveType, Encoding encoding) {
        if (null == encoding.nullValue()) {
            switch (primitiveType) {
                case INT8: {
                    this.imports.add("math");
                    return "math.MinInt8";
                }
                case INT16: {
                    this.imports.add("math");
                    return "math.MinInt16";
                }
                case INT32: {
                    this.imports.add("math");
                    return "math.MinInt32";
                }
                case INT64: {
                    this.imports.add("math");
                    return "math.MinInt64";
                }
                case UINT8: {
                    this.imports.add("math");
                    return "math.MaxUint8";
                }
                case UINT16: {
                    this.imports.add("math");
                    return "math.MaxUint16";
                }
                case UINT32: {
                    this.imports.add("math");
                    return "math.MaxUint32";
                }
                case UINT64: {
                    this.imports.add("math");
                    return "math.MaxUint64";
                }
            }
        }
        return this.generateLiteral(primitiveType, encoding.applicableNullValue().toString());
    }

    private CharSequence generateLiteral(PrimitiveType type, String value) {
        String literal = "";
        String castType = GolangUtil.golangTypeName(type);
        switch (type) {
            case CHAR: 
            case INT8: 
            case INT16: 
            case INT32: 
            case UINT8: 
            case UINT16: 
            case UINT32: {
                literal = value;
                break;
            }
            case UINT64: {
                if (value.charAt(0) == '-') {
                    literal = Long.toUnsignedString(Long.parseLong(value));
                    break;
                }
                literal = castType + "(" + value + ")";
                break;
            }
            case INT64: {
                literal = castType + "(" + value + ")";
                break;
            }
            case FLOAT: {
                literal = "float32(" + (value.endsWith("NaN") ? "math.NaN()" : value) + ")";
                break;
            }
            case DOUBLE: {
                literal = value.endsWith("NaN") ? "math.NaN()" : value;
            }
        }
        return literal;
    }
}

