/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation;

import java.io.IOException;
import org.agrona.generation.OutputManager;
import org.agrona.generation.PackageOutputManager;
import uk.co.real_logic.sbe.SbeTool;
import uk.co.real_logic.sbe.generation.CodeGenerator;
import uk.co.real_logic.sbe.generation.cpp.CppGenerator;
import uk.co.real_logic.sbe.generation.cpp.NamespaceOutputManager;
import uk.co.real_logic.sbe.generation.java.JavaGenerator;
import uk.co.real_logic.sbe.ir.Ir;

public enum TargetCodeGenerator {
    JAVA{

        @Override
        public CodeGenerator newInstance(Ir ir, String outputDir) throws IOException {
            return new JavaGenerator(ir, System.getProperty("sbe.java.encoding.buffer.type", SbeTool.JAVA_DEFAULT_ENCODING_BUFFER_TYPE), System.getProperty("sbe.java.decoding.buffer.type", SbeTool.JAVA_DEFAULT_DECODING_BUFFER_TYPE), Boolean.getBoolean("sbe.java.generate.group-order.annotation"), Boolean.getBoolean("sbe.java.generate.interfaces"), (OutputManager)new PackageOutputManager(outputDir, ir.applicableNamespace()));
        }
    }
    ,
    CPP{

        @Override
        public CodeGenerator newInstance(Ir ir, String outputDir) throws IOException {
            return new CppGenerator(ir, new NamespaceOutputManager(outputDir, ir.applicableNamespace()));
        }
    };


    public abstract CodeGenerator newInstance(Ir var1, String var2) throws IOException;

    public static TargetCodeGenerator get(String name) {
        for (TargetCodeGenerator target : TargetCodeGenerator.values()) {
            if (!target.name().equalsIgnoreCase(name)) continue;
            return target;
        }
        throw new IllegalArgumentException("No code generator for name: " + name);
    }
}

