/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.xml;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.PrimitiveValue;
import uk.co.real_logic.sbe.xml.EnumType;
import uk.co.real_logic.sbe.xml.Presence;
import uk.co.real_logic.sbe.xml.Type;
import uk.co.real_logic.sbe.xml.XmlSchemaParser;

public class EncodedDataType
extends Type {
    public static final String ENCODED_DATA_TYPE = "type";
    private final PrimitiveType primitiveType;
    private final int length;
    private final PrimitiveValue constValue;
    private final PrimitiveValue minValue;
    private final PrimitiveValue maxValue;
    private final PrimitiveValue nullValue;
    private final String characterEncoding;
    private final String valueRef;
    private boolean varLen;

    public EncodedDataType(Node node) {
        this(node, null, null);
    }

    public EncodedDataType(Node node, String givenName, String referencedName) {
        super(node, givenName, referencedName);
        this.primitiveType = PrimitiveType.get(XmlSchemaParser.getAttributeValue(node, "primitiveType"));
        String lengthAttr = XmlSchemaParser.getAttributeValueOrNull(node, "length");
        this.length = Integer.parseInt(null == lengthAttr ? "1" : lengthAttr);
        this.varLen = Boolean.parseBoolean(XmlSchemaParser.getAttributeValue(node, "variableLength", "false"));
        this.valueRef = XmlSchemaParser.getAttributeValueOrNull(node, "valueRef");
        if (null != this.valueRef) {
            if (this.valueRef.indexOf(46) == -1) {
                XmlSchemaParser.handleError(node, "valueRef format not valid (enum-name.valid-value-name): " + this.valueRef);
            }
            if (this.presence() != Presence.CONSTANT) {
                XmlSchemaParser.handleError(node, "presence must be constant when valueRef is set: " + this.valueRef);
            }
        }
        if (PrimitiveType.CHAR == this.primitiveType) {
            this.characterEncoding = XmlSchemaParser.getAttributeValue(node, "characterEncoding", "US-ASCII").trim();
        } else {
            String configuredCharacterEncoding = XmlSchemaParser.getAttributeValueOrNull(node, "characterEncoding");
            String string = this.characterEncoding = configuredCharacterEncoding == null ? null : configuredCharacterEncoding.trim();
        }
        if (this.presence() == Presence.CONSTANT) {
            if (null == this.valueRef) {
                if (node.getFirstChild() == null) {
                    XmlSchemaParser.handleError(node, "type has declared presence as \"constant\" but XML node has no data");
                    this.constValue = null;
                } else {
                    String nodeValue = node.getFirstChild().getNodeValue();
                    this.constValue = PrimitiveType.CHAR == this.primitiveType ? this.processConstantChar(node, lengthAttr, nodeValue) : PrimitiveValue.parse(nodeValue, this.primitiveType);
                }
            } else {
                this.constValue = this.lookupValueRef(node);
            }
        } else {
            this.constValue = null;
        }
        String minValStr = XmlSchemaParser.getAttributeValueOrNull(node, "minValue");
        this.minValue = minValStr != null ? PrimitiveValue.parse(minValStr, this.primitiveType) : null;
        String maxValStr = XmlSchemaParser.getAttributeValueOrNull(node, "maxValue");
        this.maxValue = maxValStr != null ? PrimitiveValue.parse(maxValStr, this.primitiveType) : null;
        String nullValStr = XmlSchemaParser.getAttributeValueOrNull(node, "nullValue");
        if (nullValStr != null) {
            if (this.presence() != Presence.OPTIONAL) {
                XmlSchemaParser.handleWarning(node, "nullValue set, but presence is not optional");
            }
            this.nullValue = PrimitiveValue.parse(nullValStr, this.primitiveType);
        } else {
            this.nullValue = null;
        }
    }

    private PrimitiveValue lookupValueRef(Node node) {
        try {
            int periodIndex = this.valueRef.indexOf(46);
            String valueRefType = this.valueRef.substring(0, periodIndex);
            XPath xPath = XPathFactory.newInstance().newXPath();
            Node valueRefNode = (Node)xPath.compile("/*[local-name() = 'messageSchema']/types/enum[@name='" + valueRefType + "']").evaluate(node.getOwnerDocument(), XPathConstants.NODE);
            if (valueRefNode == null) {
                XmlSchemaParser.handleError(node, "valueRef not found: " + valueRefType);
                return null;
            }
            EnumType enumType = new EnumType(valueRefNode);
            if (enumType.encodingType() != this.primitiveType) {
                XmlSchemaParser.handleError(node, "valueRef does not match this type: " + this.valueRef);
                return null;
            }
            String validValueName = this.valueRef.substring(periodIndex + 1);
            EnumType.ValidValue validValue = enumType.getValidValue(validValueName);
            if (null == validValue) {
                XmlSchemaParser.handleError(node, "valueRef for validValue name not found: " + validValueName);
                return null;
            }
            return validValue.primitiveValue();
        }
        catch (XPathException ex) {
            throw new RuntimeException(ex);
        }
    }

    public EncodedDataType(String name, Presence presence, String description, String semanticType, PrimitiveType primitiveType, int length, boolean varLen) {
        this(name, null, presence, description, semanticType, primitiveType, length, varLen);
    }

    public EncodedDataType(String name, String packageName, Presence presence, String description, String semanticType, PrimitiveType primitiveType, int length, boolean varLen) {
        super(name, packageName, presence, description, 0, 0, semanticType);
        this.primitiveType = primitiveType;
        this.length = length;
        this.varLen = varLen;
        this.constValue = null;
        this.minValue = null;
        this.maxValue = null;
        this.nullValue = null;
        this.characterEncoding = null;
        this.valueRef = null;
    }

    public int length() {
        return this.length;
    }

    @Override
    public boolean isVariableLength() {
        return this.varLen;
    }

    public void variableLength(boolean variableLength) {
        this.varLen = variableLength;
    }

    public PrimitiveType primitiveType() {
        return this.primitiveType;
    }

    @Override
    public int encodedLength() {
        if (this.presence() == Presence.CONSTANT) {
            return 0;
        }
        if (this.varLen) {
            return -1;
        }
        return this.primitiveType.size() * this.length;
    }

    public PrimitiveValue constVal() {
        if (this.presence() != Presence.CONSTANT) {
            throw new IllegalStateException("type is not of constant presence");
        }
        return this.constValue;
    }

    public PrimitiveValue minValue() {
        return this.minValue;
    }

    public PrimitiveValue maxValue() {
        return this.maxValue;
    }

    public PrimitiveValue nullValue() {
        return this.nullValue;
    }

    public String characterEncoding() {
        return this.characterEncoding;
    }

    public String valueRef() {
        return this.valueRef;
    }

    private PrimitiveValue processConstantChar(Node node, String lengthAttr, String nodeValue) {
        int valueLength = nodeValue.length();
        if (null != lengthAttr && this.length < valueLength) {
            XmlSchemaParser.handleError(node, "length of " + this.length + " is less than provided value: " + nodeValue);
        }
        PrimitiveValue primitiveValue = valueLength == 1 ? (null == lengthAttr || this.length == 1 ? PrimitiveValue.parse(nodeValue, this.primitiveType, this.characterEncoding) : PrimitiveValue.parse(nodeValue, this.length, this.characterEncoding)) : (null == lengthAttr ? PrimitiveValue.parse(nodeValue, valueLength, this.characterEncoding) : PrimitiveValue.parse(nodeValue, this.length, this.characterEncoding));
        return primitiveValue;
    }

    public String toString() {
        return "EncodedDataType{primitiveType=" + String.valueOf((Object)this.primitiveType) + ", length=" + this.length + ", constValue=" + String.valueOf(this.constValue) + ", minValue=" + String.valueOf(this.minValue) + ", maxValue=" + String.valueOf(this.maxValue) + ", nullValue=" + String.valueOf(this.nullValue) + ", characterEncoding='" + this.characterEncoding + "', valueRef='" + this.valueRef + "', varLen=" + this.varLen + "}";
    }
}

