/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.otf;

import java.util.List;
import org.agrona.DirectBuffer;
import uk.co.real_logic.sbe.ir.Signal;
import uk.co.real_logic.sbe.ir.Token;
import uk.co.real_logic.sbe.otf.TokenListener;
import uk.co.real_logic.sbe.otf.Types;

public class OtfMessageDecoder {
    public static int decode(DirectBuffer buffer, int offset, int actingVersion, int blockLength, List<Token> msgTokens, TokenListener listener) {
        listener.onBeginMessage(msgTokens.get(0));
        int i = offset;
        int numTokens = msgTokens.size();
        int tokenIdx = OtfMessageDecoder.decodeFields(buffer, i, actingVersion, msgTokens, 1, numTokens, listener);
        long packedValues = OtfMessageDecoder.decodeGroups(buffer, i += blockLength, actingVersion, msgTokens, tokenIdx, numTokens, listener);
        i = OtfMessageDecoder.decodeData(buffer, OtfMessageDecoder.bufferOffset(packedValues), msgTokens, OtfMessageDecoder.tokenIndex(packedValues), numTokens, actingVersion, listener);
        listener.onEndMessage(msgTokens.get(numTokens - 1));
        return i;
    }

    private static int decodeFields(DirectBuffer buffer, int bufferOffset, int actingVersion, List<Token> tokens, int tokenIndex, int numTokens, TokenListener listener) {
        Token fieldToken;
        int i = tokenIndex;
        while (i < numTokens && Signal.BEGIN_FIELD == (fieldToken = tokens.get(i)).signal()) {
            int nextFieldIdx = i + fieldToken.componentTokenCount();
            Token typeToken = tokens.get(++i);
            int offset = typeToken.offset();
            switch (typeToken.signal()) {
                case BEGIN_COMPOSITE: {
                    OtfMessageDecoder.decodeComposite(fieldToken, buffer, bufferOffset + offset, tokens, i, nextFieldIdx - 2, actingVersion, listener);
                    break;
                }
                case BEGIN_ENUM: {
                    listener.onEnum(fieldToken, buffer, bufferOffset + offset, tokens, i, nextFieldIdx - 2, actingVersion);
                    break;
                }
                case BEGIN_SET: {
                    listener.onBitSet(fieldToken, buffer, bufferOffset + offset, tokens, i, nextFieldIdx - 2, actingVersion);
                    break;
                }
                case ENCODING: {
                    listener.onEncoding(fieldToken, buffer, bufferOffset + offset, typeToken, actingVersion);
                    break;
                }
            }
            i = nextFieldIdx;
        }
        return i;
    }

    private static long decodeGroups(DirectBuffer buffer, int bufferOffset, int actingVersion, List<Token> tokens, int tokenIdx, int numTokens, TokenListener listener) {
        Token token;
        while (tokenIdx < numTokens && Signal.BEGIN_GROUP == (token = tokens.get(tokenIdx)).signal()) {
            boolean isPresent = token.version() <= actingVersion;
            Token blockLengthToken = tokens.get(tokenIdx + 2);
            int blockLength = isPresent ? Types.getInt(buffer, bufferOffset + blockLengthToken.offset(), blockLengthToken.encoding().primitiveType(), blockLengthToken.encoding().byteOrder()) : 0;
            Token numInGroupToken = tokens.get(tokenIdx + 3);
            int numInGroup = isPresent ? Types.getInt(buffer, bufferOffset + numInGroupToken.offset(), numInGroupToken.encoding().primitiveType(), numInGroupToken.encoding().byteOrder()) : 0;
            Token dimensionTypeComposite = tokens.get(tokenIdx + 1);
            if (isPresent) {
                bufferOffset += dimensionTypeComposite.encodedLength();
            }
            int beginFieldsIdx = tokenIdx + dimensionTypeComposite.componentTokenCount() + 1;
            listener.onGroupHeader(token, numInGroup);
            for (int i = 0; i < numInGroup; ++i) {
                listener.onBeginGroup(token, i, numInGroup);
                int afterFieldsIdx = OtfMessageDecoder.decodeFields(buffer, bufferOffset, actingVersion, tokens, beginFieldsIdx, numTokens, listener);
                long packedValues = OtfMessageDecoder.decodeGroups(buffer, bufferOffset += blockLength, actingVersion, tokens, afterFieldsIdx, numTokens, listener);
                bufferOffset = OtfMessageDecoder.decodeData(buffer, OtfMessageDecoder.bufferOffset(packedValues), tokens, OtfMessageDecoder.tokenIndex(packedValues), numTokens, actingVersion, listener);
                listener.onEndGroup(token, i, numInGroup);
            }
            tokenIdx += token.componentTokenCount();
        }
        return OtfMessageDecoder.pack(bufferOffset, tokenIdx);
    }

    private static void decodeComposite(Token fieldToken, DirectBuffer buffer, int bufferOffset, List<Token> tokens, int tokenIdx, int toIndex, int actingVersion, TokenListener listener) {
        Token typeToken;
        listener.onBeginComposite(fieldToken, tokens, tokenIdx, toIndex);
        block6: for (int i = tokenIdx + 1; i < toIndex; i += typeToken.componentTokenCount()) {
            typeToken = tokens.get(i);
            int nextFieldIdx = i + typeToken.componentTokenCount();
            int offset = typeToken.offset();
            switch (typeToken.signal()) {
                case BEGIN_COMPOSITE: {
                    OtfMessageDecoder.decodeComposite(fieldToken, buffer, bufferOffset + offset, tokens, i, nextFieldIdx - 1, actingVersion, listener);
                    continue block6;
                }
                case BEGIN_ENUM: {
                    listener.onEnum(fieldToken, buffer, bufferOffset + offset, tokens, i, nextFieldIdx - 1, actingVersion);
                    continue block6;
                }
                case BEGIN_SET: {
                    listener.onBitSet(fieldToken, buffer, bufferOffset + offset, tokens, i, nextFieldIdx - 1, actingVersion);
                    continue block6;
                }
                case ENCODING: {
                    listener.onEncoding(typeToken, buffer, bufferOffset + offset, typeToken, actingVersion);
                    continue block6;
                }
            }
        }
        listener.onEndComposite(fieldToken, tokens, tokenIdx, toIndex);
    }

    private static int decodeData(DirectBuffer buffer, int bufferOffset, List<Token> tokens, int tokenIdx, int numTokens, int actingVersion, TokenListener listener) {
        Token token;
        while (tokenIdx < numTokens && Signal.BEGIN_VAR_DATA == (token = tokens.get(tokenIdx)).signal()) {
            boolean isPresent = token.version() <= actingVersion;
            Token lengthToken = tokens.get(tokenIdx + 2);
            int length = isPresent ? Types.getInt(buffer, bufferOffset + lengthToken.offset(), lengthToken.encoding().primitiveType(), lengthToken.encoding().byteOrder()) : 0;
            Token dataToken = tokens.get(tokenIdx + 3);
            if (isPresent) {
                bufferOffset += dataToken.offset();
            }
            listener.onVarData(token, buffer, bufferOffset, length, dataToken);
            bufferOffset += length;
            tokenIdx += token.componentTokenCount();
        }
        return bufferOffset;
    }

    private static long pack(int bufferOffset, int tokenIndex) {
        return (long)bufferOffset << 32 | (long)tokenIndex;
    }

    private static int bufferOffset(long packedValues) {
        return (int)(packedValues >>> 32);
    }

    private static int tokenIndex(long packedValues) {
        return (int)packedValues;
    }
}

