/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.java;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.agrona.Strings;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.ValidationUtil;
import uk.co.real_logic.sbe.generation.Generators;
import uk.co.real_logic.sbe.ir.Token;

public class JavaUtil {
    private static final Map<PrimitiveType, String> TYPE_NAME_BY_PRIMITIVE_TYPE_MAP = new EnumMap<PrimitiveType, String>(PrimitiveType.class);
    static final HashMap<String, String> STD_CHARSETS;

    public static String javaTypeName(PrimitiveType primitiveType) {
        return TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.get((Object)primitiveType);
    }

    public static String formatPropertyName(String value) {
        return JavaUtil.formatForJavaKeyword(Generators.toLowerFirstChar(value));
    }

    public static String formatForJavaKeyword(String value) {
        if (ValidationUtil.isJavaKeyword(value)) {
            String keywordAppendToken = System.getProperty("sbe.keyword.append.token");
            if (null == keywordAppendToken) {
                throw new IllegalStateException("Invalid property name='" + value + "' please correct the schema or consider setting system property: sbe.keyword.append.token");
            }
            return value + keywordAppendToken;
        }
        return value;
    }

    public static String formatGetterName(String propertyName) {
        return "get" + Generators.toUpperFirstChar(propertyName);
    }

    public static String formatClassName(String className) {
        return Generators.toUpperFirstChar(className);
    }

    public static void append(StringBuilder builder, String indent, String line) {
        builder.append(indent).append(line).append('\n');
    }

    public static String charset(String encoding) {
        String charsetName = STD_CHARSETS.get(encoding);
        if (null != charsetName) {
            return "java.nio.charset.StandardCharsets." + charsetName;
        }
        String canonicalName = Charset.isSupported(encoding) ? Charset.forName(encoding).name() : encoding;
        return "java.nio.charset.Charset.forName(\"" + canonicalName + "\")";
    }

    public static String charsetName(String encoding) {
        String charsetName = STD_CHARSETS.get(encoding);
        if (null != charsetName) {
            return "java.nio.charset.StandardCharsets." + charsetName + ".name()";
        }
        return "\"" + (Charset.isSupported(encoding) ? Charset.forName(encoding).name() : encoding) + "\"";
    }

    public static boolean isAsciiEncoding(String encoding) {
        return "US_ASCII".equals(STD_CHARSETS.get(encoding));
    }

    public static boolean isUtf8Encoding(String encoding) {
        return "UTF_8".equals(STD_CHARSETS.get(encoding));
    }

    public static String generateLiteral(PrimitiveType type, String value) {
        Object literal = "";
        String castType = JavaUtil.javaTypeName(type);
        switch (type) {
            case CHAR: 
            case UINT8: 
            case INT8: 
            case INT16: {
                literal = "(" + castType + ")" + value;
                break;
            }
            case UINT16: 
            case INT32: {
                literal = value;
                break;
            }
            case UINT32: {
                literal = value + "L";
                break;
            }
            case FLOAT: {
                literal = value.endsWith("NaN") ? "Float.NaN" : value + "f";
                break;
            }
            case INT64: {
                literal = value + "L";
                break;
            }
            case UINT64: {
                literal = "0x" + Long.toHexString(Long.parseLong(value)) + "L";
                break;
            }
            case DOUBLE: {
                literal = value.endsWith("NaN") ? "Double.NaN" : value + "d";
            }
        }
        return literal;
    }

    public static void generateTypeJavadoc(StringBuilder sb, String indent, Token typeToken) {
        String description = typeToken.description();
        if (Strings.isEmpty((String)description)) {
            return;
        }
        sb.append('\n').append(indent).append("/**\n").append(indent).append(" * ");
        JavaUtil.escapeJavadoc(sb, description);
        sb.append('\n').append(indent).append(" */\n");
    }

    public static void generateOptionDecodeJavadoc(Appendable out, String indent, Token optionToken) throws IOException {
        String description = optionToken.description();
        if (Strings.isEmpty((String)description)) {
            return;
        }
        out.append(indent).append("/**\n").append(indent).append(" * ");
        JavaUtil.escapeJavadoc(out, description);
        out.append('\n').append(indent).append(" *\n").append(indent).append(" * @return true if ").append(optionToken.name()).append(" set or false if not.\n").append(indent).append(" */\n");
    }

    public static void generateOptionEncodeJavadoc(Appendable out, String indent, Token optionToken) throws IOException {
        String description = optionToken.description();
        if (Strings.isEmpty((String)description)) {
            return;
        }
        out.append(indent).append("/**\n").append(indent).append(" * ");
        JavaUtil.escapeJavadoc(out, description);
        String name = optionToken.name();
        out.append('\n').append(indent).append(" *\n").append(indent).append(" * @param value true if ").append(name).append(" is set or false if not.\n").append(indent).append(" * @return this for a fluent API.\n").append(indent).append(" */\n");
    }

    public static void generateFlyweightPropertyJavadoc(StringBuilder sb, String indent, Token propertyToken, String typeName) {
        String description = propertyToken.description();
        if (Strings.isEmpty((String)description)) {
            return;
        }
        sb.append('\n').append(indent).append("/**\n").append(indent).append(" * ");
        JavaUtil.escapeJavadoc(sb, description);
        sb.append('\n').append(indent).append(" *\n").append(indent).append(" * @return ").append(typeName).append(" : ");
        JavaUtil.escapeJavadoc(sb, description);
        sb.append("\n").append(indent).append(" */");
    }

    public static void generateGroupEncodePropertyJavadoc(StringBuilder sb, String indent, Token propertyToken, String typeName) {
        String description = propertyToken.description();
        if (Strings.isEmpty((String)description)) {
            return;
        }
        sb.append('\n').append(indent).append("/**\n").append(indent).append(" * ");
        JavaUtil.escapeJavadoc(sb, description);
        sb.append("\n").append(indent).append(" *\n").append(indent).append(" * @param count of times the group will be encoded.\n").append(indent).append(" * @return ").append(typeName).append(" : encoder for the group.\n").append(indent).append(" */");
    }

    static String encoderName(String className) {
        return JavaUtil.formatClassName(className) + "Encoder";
    }

    static String decoderName(String className) {
        return JavaUtil.formatClassName(className) + "Decoder";
    }

    private static void escapeJavadoc(Appendable out, String doc) throws IOException {
        int length = doc.length();
        block4: for (int i = 0; i < length; ++i) {
            char c = doc.charAt(i);
            switch (c) {
                case '<': {
                    out.append("&lt;");
                    continue block4;
                }
                case '>': {
                    out.append("&gt;");
                    continue block4;
                }
                default: {
                    out.append(c);
                }
            }
        }
    }

    private static void escapeJavadoc(StringBuilder sb, String doc) {
        int length = doc.length();
        block5: for (int i = 0; i < length; ++i) {
            char c = doc.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block5;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block5;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
    }

    static {
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.CHAR, "byte");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.INT8, "byte");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.INT16, "short");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.INT32, "int");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.INT64, "long");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.UINT8, "short");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.UINT16, "int");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.UINT32, "long");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.UINT64, "long");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.FLOAT, "float");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.DOUBLE, "double");
        STD_CHARSETS = new HashMap();
        try {
            for (Field field : StandardCharsets.class.getDeclaredFields()) {
                if (!Charset.class.isAssignableFrom(field.getType()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers())) continue;
                Charset charset = (Charset)field.get(null);
                String name = field.getName();
                String oldName = STD_CHARSETS.put(charset.name(), name);
                if (null != oldName) {
                    throw new IllegalStateException("Duplicate charset alias: old=" + oldName + ", new=" + name);
                }
                for (String alias : charset.aliases()) {
                    oldName = STD_CHARSETS.put(alias, name);
                    if (null == oldName) continue;
                    throw new IllegalStateException("Duplicate charset alias: old=" + oldName + ", new=" + alias);
                }
            }
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    static enum Separator {
        BEGIN_GROUP('['),
        END_GROUP(']'),
        BEGIN_COMPOSITE('('),
        END_COMPOSITE(')'),
        BEGIN_SET('{'),
        END_SET('}'),
        BEGIN_ARRAY('['),
        END_ARRAY(']'),
        FIELD('|'),
        KEY_VALUE('='),
        ENTRY(',');

        private final char symbol;

        private Separator(char symbol) {
            this.symbol = symbol;
        }

        void appendToGeneratedBuilder(StringBuilder builder, String indent) {
            builder.append(indent).append("builder.append('").append(this.symbol).append("');").append('\n');
        }

        public String toString() {
            return String.valueOf(this.symbol);
        }
    }
}

