/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.ir;

import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.agrona.Verify;
import uk.co.real_logic.sbe.ir.HeaderStructure;
import uk.co.real_logic.sbe.ir.Signal;
import uk.co.real_logic.sbe.ir.Token;

public class Ir {
    private final String packageName;
    private final String namespaceName;
    private final int id;
    private final int version;
    private final String description;
    private final String semanticVersion;
    private final ByteOrder byteOrder;
    private final HeaderStructure headerStructure;
    private final Map<Long, List<Token>> messagesByIdMap = new HashMap<Long, List<Token>>();
    private final Map<String, List<Token>> typesByNameMap = new HashMap<String, List<Token>>();
    private final String[] namespaces;

    public Ir(String packageName, String namespaceName, int id, int version, String description, String semanticVersion, ByteOrder byteOrder, List<Token> headerTokens) {
        Verify.notNull((Object)packageName, (String)"packageName");
        Verify.notNull(headerTokens, (String)"headerTokens");
        this.packageName = packageName;
        this.namespaceName = namespaceName;
        this.id = id;
        this.version = version;
        this.description = description;
        this.semanticVersion = semanticVersion;
        this.byteOrder = byteOrder;
        this.headerStructure = new HeaderStructure(new ArrayList<Token>(headerTokens));
        this.captureTypes(headerTokens, 0, headerTokens.size() - 1);
        this.namespaces = "true".equals(System.getProperty("sbe.cpp.namespaces.collapse")) ? new String[]{(namespaceName == null ? packageName : namespaceName).replace(".", "_")} : Pattern.compile("\\.").split(namespaceName == null ? packageName : namespaceName);
    }

    public HeaderStructure headerStructure() {
        return this.headerStructure;
    }

    public void addMessage(long messageId, List<Token> messageTokens) {
        Verify.notNull(messageTokens, (String)"messageTokens");
        this.captureTypes(messageTokens, 0, messageTokens.size() - 1);
        Ir.updateComponentTokenCounts(messageTokens);
        this.messagesByIdMap.put(messageId, new ArrayList<Token>(messageTokens));
    }

    public List<Token> getMessage(long messageId) {
        return this.messagesByIdMap.get(messageId);
    }

    public List<Token> getType(String name) {
        return this.typesByNameMap.get(name);
    }

    public Collection<List<Token>> types() {
        return this.typesByNameMap.values();
    }

    public Collection<List<Token>> messages() {
        return this.messagesByIdMap.values();
    }

    public String packageName() {
        return this.packageName;
    }

    public String namespaceName() {
        return this.namespaceName;
    }

    public String[] namespaces() {
        return this.namespaces;
    }

    public int id() {
        return this.id;
    }

    public int version() {
        return this.version;
    }

    public String description() {
        return this.description;
    }

    public String semanticVersion() {
        return this.semanticVersion;
    }

    public ByteOrder byteOrder() {
        return this.byteOrder;
    }

    public String applicableNamespace() {
        return this.namespaceName == null ? this.packageName : this.namespaceName;
    }

    public static void updateComponentTokenCounts(List<Token> tokens) {
        HashMap<String, Deque> map = new HashMap<String, Deque>();
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            String componentType;
            Token token = tokens.get(i);
            Signal signal = token.signal();
            if (signal.name().startsWith("BEGIN_")) {
                componentType = signal.name().substring(6);
                map.computeIfAbsent(componentType, key -> new LinkedList()).push(i);
                continue;
            }
            if (!signal.name().startsWith("END_")) continue;
            componentType = signal.name().substring(4);
            int beginIndex = (Integer)((Deque)map.get(componentType)).pop();
            int componentTokenCount = i - beginIndex + 1;
            tokens.get(beginIndex).componentTokenCount(componentTokenCount);
            token.componentTokenCount(componentTokenCount);
        }
    }

    private void captureTypes(List<Token> tokens, int beginIndex, int endIndex) {
        block5: for (int i = beginIndex; i <= endIndex; ++i) {
            Token token = tokens.get(i);
            int typeBeginIndex = i;
            switch (token.signal()) {
                case BEGIN_COMPOSITE: {
                    i = this.captureType(tokens, i, Signal.END_COMPOSITE, token.name(), token.referencedName());
                    this.captureTypes(tokens, typeBeginIndex + 1, i - 1);
                    continue block5;
                }
                case BEGIN_ENUM: {
                    i = this.captureType(tokens, i, Signal.END_ENUM, token.name(), token.referencedName());
                    continue block5;
                }
                case BEGIN_SET: {
                    i = this.captureType(tokens, i, Signal.END_SET, token.name(), token.referencedName());
                    continue block5;
                }
            }
        }
    }

    private int captureType(List<Token> tokens, int index, Signal endSignal, String name, String referencedName) {
        ArrayList<Token> typeTokens = new ArrayList<Token>();
        int i = index;
        Token token = tokens.get(i);
        typeTokens.add(token);
        do {
            token = tokens.get(++i);
            typeTokens.add(token);
        } while (endSignal != token.signal() || !name.equals(token.name()));
        Ir.updateComponentTokenCounts(typeTokens);
        String typeName = null == referencedName ? name : referencedName;
        List<Token> existingTypeTokens = this.typesByNameMap.get(typeName);
        if (null == existingTypeTokens || existingTypeTokens.get(0).version() > ((Token)typeTokens.get(0)).version()) {
            this.typesByNameMap.put(typeName, typeTokens);
        }
        return i;
    }
}

