/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.csharp;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.agrona.Verify;
import org.agrona.generation.OutputManager;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.generation.CodeGenerator;
import uk.co.real_logic.sbe.generation.Generators;
import uk.co.real_logic.sbe.generation.csharp.CSharpUtil;
import uk.co.real_logic.sbe.ir.Encoding;
import uk.co.real_logic.sbe.ir.GenerationUtil;
import uk.co.real_logic.sbe.ir.Ir;
import uk.co.real_logic.sbe.ir.Signal;
import uk.co.real_logic.sbe.ir.Token;

public class CSharpDtoGenerator
implements CodeGenerator {
    private static final String INDENT = "    ";
    private static final String BASE_INDENT = "    ";
    private static final Predicate<Token> CANNOT_EXTEND = ignored -> false;
    private final Ir ir;
    private final OutputManager outputManager;

    public CSharpDtoGenerator(Ir ir, OutputManager outputManager) {
        Verify.notNull((Object)ir, (String)"ir");
        Verify.notNull((Object)outputManager, (String)"outputManager");
        this.ir = ir;
        this.outputManager = outputManager;
    }

    @Override
    public void generate() throws IOException {
        this.generateDtosForTypes();
        for (List<Token> tokens : this.ir.messages()) {
            Token msgToken = tokens.get(0);
            String codecClassName = CSharpUtil.formatClassName(msgToken.name());
            String dtoClassName = this.formatDtoClassName(msgToken.name());
            List<Token> messageBody = tokens.subList(1, tokens.size() - 1);
            int offset = 0;
            StringBuilder sb = new StringBuilder();
            StringBuilder ctorArgs = new StringBuilder();
            ArrayList<Token> fields = new ArrayList<Token>();
            offset = GenerationUtil.collectFields(messageBody, offset, fields);
            this.generateFields(sb, ctorArgs, codecClassName, fields, "        ");
            ArrayList<Token> groups = new ArrayList<Token>();
            offset = GenerationUtil.collectGroups(messageBody, offset, groups);
            this.generateGroups(sb, ctorArgs, dtoClassName, codecClassName, groups, "        ");
            ArrayList<Token> varData = new ArrayList<Token>();
            GenerationUtil.collectVarData(messageBody, offset, varData);
            this.generateVarData(sb, ctorArgs, varData, "        ");
            this.generateDecodeWith(sb, dtoClassName, codecClassName, fields, groups, varData, token -> token.version() > msgToken.version(), "        ");
            this.generateDecodeFrom(sb, dtoClassName, codecClassName, "        ");
            this.generateEncodeWith(sb, dtoClassName, codecClassName, fields, groups, varData, "        ");
            this.generateEncodeInto(sb, dtoClassName, codecClassName, "        ");
            this.generateDisplay(sb, codecClassName, "WrapForEncode", null, "        ");
            CSharpDtoGenerator.removeTrailingComma(ctorArgs);
            Writer out = this.outputManager.createOutput(dtoClassName);
            Throwable throwable = null;
            try {
                out.append(CSharpUtil.generateFileHeader(this.ir.applicableNamespace(), "#nullable enable\n\n", "using System.Collections.Generic;\n", "using System.Linq;\n"));
                out.append(CSharpUtil.generateDocumentation("    ", msgToken));
                out.append("    ").append("public sealed partial record ").append(dtoClassName).append("(\n").append(ctorArgs).append("    ").append(")\n").append("    ").append("{").append(sb).append("    ").append("}\n").append("}\n");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                out.close();
            }
        }
    }

    private void generateGroups(StringBuilder sb, StringBuilder ctorArgs, String qualifiedParentDtoClassName, String qualifiedParentCodecClassName, List<Token> tokens, String indent) {
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token groupToken = tokens.get(i);
            if (groupToken.signal() != Signal.BEGIN_GROUP) {
                throw new IllegalStateException("tokens must begin with BEGIN_GROUP: token=" + groupToken);
            }
            String groupName = groupToken.name();
            String groupClassName = this.formatDtoClassName(groupName);
            String formattedPropertyName = CSharpUtil.formatPropertyName(groupName);
            Token dimToken = tokens.get(i + 1);
            if (dimToken.signal() != Signal.BEGIN_COMPOSITE) {
                throw new IllegalStateException("groups must start with BEGIN_COMPOSITE: token=" + dimToken);
            }
            int sinceVersion = dimToken.version();
            ctorArgs.append(indent).append("IReadOnlyList<").append(qualifiedParentDtoClassName).append(".").append(groupClassName).append("> ").append(formattedPropertyName).append(",\n");
            sb.append("\n").append(CSharpUtil.generateDocumentation(indent, groupToken)).append(indent).append("public IReadOnlyList<").append(groupClassName).append("> ").append(formattedPropertyName).append(" { get; init; } = ").append(formattedPropertyName).append(";\n");
            StringBuilder groupCtorArgs = new StringBuilder();
            StringBuilder groupRecordBody = new StringBuilder();
            ++i;
            i += tokens.get(i).componentTokenCount();
            String qualifiedDtoClassName = qualifiedParentDtoClassName + "." + groupClassName;
            String qualifiedCodecClassName = qualifiedParentCodecClassName + "." + CSharpUtil.formatClassName(groupName) + "Group";
            ArrayList<Token> fields = new ArrayList<Token>();
            i = GenerationUtil.collectFields(tokens, i, fields);
            this.generateFields(groupRecordBody, groupCtorArgs, qualifiedCodecClassName, fields, indent + "    ");
            ArrayList<Token> groups = new ArrayList<Token>();
            i = GenerationUtil.collectGroups(tokens, i, groups);
            this.generateGroups(groupRecordBody, groupCtorArgs, qualifiedDtoClassName, qualifiedCodecClassName, groups, indent + "    ");
            ArrayList<Token> varData = new ArrayList<Token>();
            i = GenerationUtil.collectVarData(tokens, i, varData);
            this.generateVarData(groupRecordBody, groupCtorArgs, varData, indent + "    ");
            this.generateDecodeListWith(groupRecordBody, groupClassName, qualifiedCodecClassName, indent + "    ");
            Predicate<Token> wasAddedAfterGroup = token -> {
                boolean addedAfterParent;
                boolean bl = addedAfterParent = token.version() > sinceVersion;
                if (addedAfterParent && token.signal() == Signal.BEGIN_VAR_DATA) {
                    throw new IllegalStateException("Cannot extend var data inside a group.");
                }
                return addedAfterParent;
            };
            this.generateDecodeWith(groupRecordBody, groupClassName, qualifiedCodecClassName, fields, groups, varData, wasAddedAfterGroup, indent + "    ");
            this.generateEncodeWith(groupRecordBody, groupClassName, qualifiedCodecClassName, fields, groups, varData, indent + "    ");
            CSharpDtoGenerator.removeTrailingComma(groupCtorArgs);
            sb.append("\n").append(CSharpUtil.generateDocumentation(indent, groupToken)).append(indent).append("public sealed partial record ").append(groupClassName).append("(\n").append((CharSequence)groupCtorArgs).append(indent).append(")\n").append(indent).append("{\n").append((CharSequence)groupRecordBody).append(indent).append("}\n");
        }
    }

    private void generateCompositeDecodeWith(StringBuilder sb, String dtoClassName, String codecClassName, List<Token> tokens, String indent) {
        sb.append("\n").append(indent).append("public static ").append(dtoClassName).append(" DecodeWith(").append(codecClassName).append(" codec)\n").append(indent).append("{\n");
        sb.append(indent).append("    ").append("return new ").append(dtoClassName).append("(\n");
        for (int i = 0; i < tokens.size(); i += tokens.get(i).componentTokenCount()) {
            Token token = tokens.get(i);
            this.generateFieldDecodeWith(sb, CANNOT_EXTEND, token, token, codecClassName, indent + "    " + "    ");
        }
        CSharpDtoGenerator.removeTrailingComma(sb);
        sb.append(indent).append("    ").append(");\n");
        sb.append(indent).append("}\n");
    }

    private void generateCompositeEncodeWith(StringBuilder sb, String dtoClassName, String codecClassName, List<Token> tokens, String indent) {
        sb.append("\n").append(indent).append("public static void EncodeWith(").append(codecClassName).append(" codec, ").append(dtoClassName).append(" dto)\n").append(indent).append("{\n");
        for (int i = 0; i < tokens.size(); i += tokens.get(i).componentTokenCount()) {
            Token token = tokens.get(i);
            this.generateFieldEncodeWith(sb, codecClassName, token, token, indent + "    ");
        }
        sb.append(indent).append("}\n");
    }

    private void generateDecodeListWith(StringBuilder sb, String dtoClassName, String codecClassName, String indent) {
        sb.append("\n").append(indent).append("public static IReadOnlyList<").append(dtoClassName).append("> DecodeListWith(").append(codecClassName).append(" codec)\n").append(indent).append("{\n").append(indent).append("    ").append("var ").append("list = new List<").append(dtoClassName).append(">(codec.Count);\n").append(indent).append("    ").append("while (codec.HasNext)\n").append(indent).append("    ").append("{\n").append(indent).append("    ").append("    ").append("var element = ").append(dtoClassName).append(".DecodeWith(codec.Next());\n").append(indent).append("    ").append("    ").append("list.Add(element);\n").append(indent).append("    ").append("}\n").append(indent).append("    ").append("return list.AsReadOnly();\n").append(indent).append("}\n");
    }

    private void generateDecodeWith(StringBuilder sb, String dtoClassName, String codecClassName, List<Token> fields, List<Token> groups, List<Token> varData, Predicate<Token> wasAddedAfterParent, String indent) {
        sb.append("\n").append(indent).append("public static ").append(dtoClassName).append(" DecodeWith(").append(codecClassName).append(" codec)\n").append(indent).append("{\n");
        sb.append(indent).append("    ").append("return new ").append(dtoClassName).append("(\n");
        this.generateMessageFieldsDecodeWith(sb, wasAddedAfterParent, fields, codecClassName, indent + "    " + "    ");
        this.generateGroupsDecodeWith(sb, groups, indent + "    " + "    ");
        this.generateVarDataDecodeWith(sb, varData, wasAddedAfterParent, indent + "    " + "    ");
        CSharpDtoGenerator.removeTrailingComma(sb);
        sb.append(indent).append("    ").append(");\n");
        sb.append(indent).append("}\n");
    }

    private void generateDecodeFrom(StringBuilder sb, String dtoClassName, String codecClassName, String indent) {
        sb.append("\n").append(indent).append("public static ").append(dtoClassName).append(" DecodeFrom(DirectBuffer buffer, int offset, int length, ").append("int actingBlockLength, int actingVersion)\n").append(indent).append("{\n").append(indent).append("    ").append("var decoder = new ").append(codecClassName).append("();\n").append(indent).append("    ").append("decoder.WrapForDecode(buffer, offset, actingBlockLength, actingVersion);\n").append(indent).append("    ").append("return DecodeWith(decoder);\n").append(indent).append("}\n");
    }

    private void generateMessageFieldsDecodeWith(StringBuilder sb, Predicate<Token> wasAddedAfterParent, List<Token> tokens, String codecClassName, String indent) {
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token signalToken = tokens.get(i);
            if (signalToken.signal() != Signal.BEGIN_FIELD) continue;
            Token encodingToken = tokens.get(i + 1);
            this.generateFieldDecodeWith(sb, wasAddedAfterParent, signalToken, encodingToken, codecClassName, indent);
        }
    }

    private void generateFieldDecodeWith(StringBuilder sb, Predicate<Token> wasAddedAfterParent, Token fieldToken, Token typeToken, String codecClassName, String indent) {
        switch (typeToken.signal()) {
            case ENCODING: {
                this.generatePrimitiveDecodeWith(sb, fieldToken, typeToken, wasAddedAfterParent, codecClassName, indent);
                break;
            }
            case BEGIN_SET: {
                this.generatePropertyDecodeWith(sb, fieldToken, wasAddedAfterParent, "0", null, indent);
                break;
            }
            case BEGIN_ENUM: {
                String enumName = CSharpUtil.formatClassName(typeToken.applicableTypeName());
                String nullValue = CSharpUtil.formatNamespace(this.ir.packageName()) + "." + enumName + ".NULL_VALUE";
                this.generatePropertyDecodeWith(sb, fieldToken, wasAddedAfterParent, nullValue, null, indent);
                break;
            }
            case BEGIN_COMPOSITE: {
                this.generateComplexDecodeWith(sb, fieldToken, typeToken, indent);
                break;
            }
        }
    }

    private void generatePrimitiveDecodeWith(StringBuilder sb, Token fieldToken, Token typeToken, Predicate<Token> wasAddedAfterParent, String codecClassName, String indent) {
        if (typeToken.isConstantEncoding()) {
            return;
        }
        int arrayLength = typeToken.arrayLength();
        if (arrayLength == 1) {
            String codecNullValue = codecClassName + "." + CSharpUtil.formatPropertyName(fieldToken.name()) + "NullValue";
            this.generatePropertyDecodeWith(sb, fieldToken, wasAddedAfterParent, "null", codecNullValue, indent);
        } else if (arrayLength > 1) {
            this.generateArrayDecodeWith(sb, fieldToken, typeToken, wasAddedAfterParent, indent);
        }
    }

    private void generateArrayDecodeWith(StringBuilder sb, Token fieldToken, Token typeToken, Predicate<Token> wasAddedAfterParent, String indent) {
        if (fieldToken.isConstantEncoding()) {
            return;
        }
        String propertyName = fieldToken.name();
        String formattedPropertyName = CSharpUtil.formatPropertyName(propertyName);
        if (typeToken.encoding().primitiveType() == PrimitiveType.CHAR) {
            this.generateRecordPropertyAssignment(sb, fieldToken, wasAddedAfterParent, indent, "codec.Get" + formattedPropertyName + "()", "null", null);
        } else {
            this.generateRecordPropertyAssignment(sb, fieldToken, wasAddedAfterParent, indent, "codec." + formattedPropertyName + "AsSpan().ToArray()", "null", null);
        }
    }

    private void generatePropertyDecodeWith(StringBuilder sb, Token fieldToken, Predicate<Token> wasAddedAfterParent, String dtoNullValue, String codecNullValue, String indent) {
        if (fieldToken.isConstantEncoding()) {
            return;
        }
        String propertyName = fieldToken.name();
        String formattedPropertyName = CSharpUtil.formatPropertyName(propertyName);
        this.generateRecordPropertyAssignment(sb, fieldToken, wasAddedAfterParent, indent, "codec." + formattedPropertyName, dtoNullValue, codecNullValue);
    }

    private void generateComplexDecodeWith(StringBuilder sb, Token fieldToken, Token typeToken, String indent) {
        String propertyName = fieldToken.name();
        String formattedPropertyName = CSharpUtil.formatPropertyName(propertyName);
        String dtoClassName = this.formatDtoClassName(typeToken.applicableTypeName());
        sb.append(indent).append(formattedPropertyName).append(": ").append(dtoClassName).append(".DecodeWith(codec.").append(formattedPropertyName).append(")").append(",\n");
    }

    private void generateGroupsDecodeWith(StringBuilder sb, List<Token> tokens, String indent) {
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token groupToken = tokens.get(i);
            if (groupToken.signal() != Signal.BEGIN_GROUP) {
                throw new IllegalStateException("tokens must begin with BEGIN_GROUP: token=" + groupToken);
            }
            String groupName = groupToken.name();
            String formattedPropertyName = CSharpUtil.formatPropertyName(groupName);
            String groupDtoClassName = this.formatDtoClassName(groupName);
            Token dimToken = tokens.get(i + 1);
            if (dimToken.signal() != Signal.BEGIN_COMPOSITE) {
                throw new IllegalStateException("groups must start with BEGIN_COMPOSITE: token=" + dimToken);
            }
            int sinceVersion = dimToken.version();
            this.generateRecordPropertyAssignment(sb, groupToken, token -> token.version() > sinceVersion, indent, groupDtoClassName + ".DecodeListWith(codec." + formattedPropertyName + ")", "new List<" + groupDtoClassName + ">(0).AsReadOnly()", null);
            ++i;
            i += tokens.get(i).componentTokenCount();
            ArrayList<Token> fields = new ArrayList<Token>();
            i = GenerationUtil.collectFields(tokens, i, fields);
            ArrayList<Token> groups = new ArrayList<Token>();
            i = GenerationUtil.collectGroups(tokens, i, groups);
            ArrayList<Token> varData = new ArrayList<Token>();
            i = GenerationUtil.collectVarData(tokens, i, varData);
        }
    }

    private void generateVarDataDecodeWith(StringBuilder sb, List<Token> tokens, Predicate<Token> wasAddedAfterParent, String indent) {
        for (int i = 0; i < tokens.size(); ++i) {
            Token token = tokens.get(i);
            if (token.signal() != Signal.BEGIN_VAR_DATA) continue;
            String propertyName = token.name();
            Token varDataToken = Generators.findFirst("varData", tokens, i);
            String characterEncoding = varDataToken.encoding().characterEncoding();
            String formattedPropertyName = CSharpUtil.formatPropertyName(propertyName);
            String accessor = characterEncoding == null ? "Get" + formattedPropertyName + "Bytes" : "Get" + formattedPropertyName;
            String missingValue = characterEncoding == null ? "new byte[0]" : "\"\"";
            sb.append(indent).append(formattedPropertyName).append(": ");
            if (wasAddedAfterParent.test(token)) {
                sb.append("codec.").append(formattedPropertyName).append("InActingVersion()");
                sb.append(" ?\n");
                sb.append(indent).append("    ").append("codec.").append(accessor).append("()").append(" :\n").append(indent).append("    ").append(missingValue).append(",\n");
                continue;
            }
            sb.append("codec.").append(accessor).append("()").append(",\n");
        }
    }

    private void generateRecordPropertyAssignment(StringBuilder sb, Token token, Predicate<Token> wasAddedAfterParent, String indent, String presentExpression, String notPresentExpression, String nullCodecValueOrNull) {
        String propertyName = token.name();
        String formattedPropertyName = CSharpUtil.formatPropertyName(propertyName);
        sb.append(indent).append(formattedPropertyName).append(": ");
        boolean hasPresenceCondition = false;
        if (wasAddedAfterParent.test(token)) {
            sb.append("codec.").append(formattedPropertyName).append("InActingVersion()");
            hasPresenceCondition = true;
        }
        if (token.isOptionalEncoding() && null != nullCodecValueOrNull) {
            if (hasPresenceCondition) {
                sb.append(" && ");
            }
            sb.append("codec.").append(formattedPropertyName).append(" != ").append(nullCodecValueOrNull);
            hasPresenceCondition = true;
        }
        if (hasPresenceCondition) {
            sb.append(" ?\n");
            sb.append(indent).append("    ").append(presentExpression).append(" :\n").append(indent).append("    ").append(notPresentExpression).append(",\n");
        } else {
            sb.append(presentExpression).append(",\n");
        }
    }

    private void generateEncodeWith(StringBuilder sb, String dtoClassName, String codecClassName, List<Token> fields, List<Token> groups, List<Token> varData, String indent) {
        sb.append("\n").append(indent).append("public static void EncodeWith(").append(codecClassName).append(" codec, ").append(dtoClassName).append(" dto)\n").append(indent).append("{\n");
        this.generateFieldsEncodeWith(sb, codecClassName, fields, indent + "    ");
        this.generateGroupsEncodeWith(sb, groups, indent + "    ");
        this.generateVarDataEncodeWith(sb, varData, indent + "    ");
        sb.append(indent).append("}\n");
    }

    private void generateEncodeInto(StringBuilder sb, String dtoClassName, String codecClassName, String indent) {
        sb.append("\n").append(indent).append("public static int EncodeInto(").append("DirectBuffer buffer, int offset, ").append(dtoClassName).append(" dto)\n").append(indent).append("{\n").append(indent).append("    ").append("var encoder = new ").append(codecClassName).append("();\n").append(indent).append("    ").append("encoder.WrapForEncode(buffer, offset);\n").append(indent).append("    ").append("EncodeWith(encoder, dto);\n").append(indent).append("    ").append("return encoder.Limit - offset;\n").append(indent).append("}\n");
        sb.append("\n").append(indent).append("public static int EncodeWithHeaderInto(").append("DirectBuffer buffer, int offset, ").append(dtoClassName).append(" dto)\n").append(indent).append("{\n").append(indent).append("    ").append("var encoder = new ").append(codecClassName).append("();\n").append(indent).append("    ").append("encoder.WrapForEncodeAndApplyHeader(buffer, offset, new MessageHeader());\n").append(indent).append("    ").append("EncodeWith(encoder, dto);\n").append(indent).append("    ").append("return encoder.Limit - offset;\n").append(indent).append("}\n");
    }

    private void generateFieldsEncodeWith(StringBuilder sb, String codecClassName, List<Token> tokens, String indent) {
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token signalToken = tokens.get(i);
            if (signalToken.signal() != Signal.BEGIN_FIELD) continue;
            Token encodingToken = tokens.get(i + 1);
            this.generateFieldEncodeWith(sb, codecClassName, signalToken, encodingToken, indent);
        }
    }

    private void generateFieldEncodeWith(StringBuilder sb, String codecClassName, Token fieldToken, Token typeToken, String indent) {
        switch (typeToken.signal()) {
            case ENCODING: {
                this.generatePrimitiveEncodeWith(sb, codecClassName, fieldToken, typeToken, indent);
                break;
            }
            case BEGIN_SET: 
            case BEGIN_ENUM: {
                this.generateEnumEncodeWith(sb, fieldToken, indent);
                break;
            }
            case BEGIN_COMPOSITE: {
                this.generateComplexEncodeWith(sb, fieldToken, typeToken, indent);
                break;
            }
        }
    }

    private void generatePrimitiveEncodeWith(StringBuilder sb, String codecClassName, Token fieldToken, Token typeToken, String indent) {
        if (typeToken.isConstantEncoding()) {
            return;
        }
        int arrayLength = typeToken.arrayLength();
        if (arrayLength == 1) {
            this.generatePropertyEncodeWith(sb, codecClassName, fieldToken, indent);
        } else if (arrayLength > 1) {
            this.generateArrayEncodeWith(sb, fieldToken, typeToken, indent);
        }
    }

    private void generateArrayEncodeWith(StringBuilder sb, Token fieldToken, Token typeToken, String indent) {
        if (fieldToken.isConstantEncoding()) {
            return;
        }
        String propertyName = fieldToken.name();
        String formattedPropertyName = CSharpUtil.formatPropertyName(propertyName);
        if (typeToken.encoding().primitiveType() == PrimitiveType.CHAR) {
            String value = this.nullableConvertedExpression(fieldToken, "dto." + formattedPropertyName, "\"\"");
            sb.append(indent).append("codec.Set").append(formattedPropertyName).append("(").append(value).append(");\n");
        } else {
            String typeName = CSharpUtil.cSharpTypeName(typeToken.encoding().primitiveType());
            sb.append(indent).append("new Span<").append(typeName).append(">(dto.").append(formattedPropertyName).append("?.ToArray()).CopyTo(codec.").append(formattedPropertyName).append("AsSpan());\n");
        }
    }

    private String nullableConvertedExpression(Token fieldToken, String expression, String nullValue) {
        return fieldToken.isOptionalEncoding() ? expression + " ?? " + nullValue : expression;
    }

    private void generatePropertyEncodeWith(StringBuilder sb, String codecClassName, Token fieldToken, String indent) {
        if (fieldToken.isConstantEncoding()) {
            return;
        }
        String propertyName = fieldToken.name();
        String formattedPropertyName = CSharpUtil.formatPropertyName(propertyName);
        String value = this.nullableConvertedExpression(fieldToken, "dto." + formattedPropertyName, codecClassName + "." + formattedPropertyName + "NullValue");
        sb.append(indent).append("codec.").append(formattedPropertyName).append(" = ").append(value).append(";\n");
    }

    private void generateEnumEncodeWith(StringBuilder sb, Token fieldToken, String indent) {
        if (fieldToken.isConstantEncoding()) {
            return;
        }
        String propertyName = fieldToken.name();
        String formattedPropertyName = CSharpUtil.formatPropertyName(propertyName);
        sb.append(indent).append("codec.").append(formattedPropertyName).append(" = dto.").append(formattedPropertyName).append(";\n");
    }

    private void generateComplexEncodeWith(StringBuilder sb, Token fieldToken, Token typeToken, String indent) {
        String propertyName = fieldToken.name();
        String formattedPropertyName = CSharpUtil.formatPropertyName(propertyName);
        String dtoClassName = this.formatDtoClassName(typeToken.applicableTypeName());
        sb.append(indent).append(dtoClassName).append(".EncodeWith(codec.").append(formattedPropertyName).append(", dto.").append(formattedPropertyName).append(");\n");
    }

    private void generateGroupsEncodeWith(StringBuilder sb, List<Token> tokens, String indent) {
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token groupToken = tokens.get(i);
            if (groupToken.signal() != Signal.BEGIN_GROUP) {
                throw new IllegalStateException("tokens must begin with BEGIN_GROUP: token=" + groupToken);
            }
            String groupName = groupToken.name();
            String formattedPropertyName = CSharpUtil.formatPropertyName(groupName);
            String groupCodecVarName = groupName + "Codec";
            String groupDtoClassName = this.formatDtoClassName(groupName);
            sb.append("\n").append(indent).append("var ").append(groupCodecVarName).append(" = codec.").append(formattedPropertyName).append("Count(dto.").append(formattedPropertyName).append(".Count);\n\n").append(indent).append("foreach (var group in dto.").append(formattedPropertyName).append(")\n").append(indent).append("{\n").append(indent).append("    ").append(groupDtoClassName).append(".EncodeWith(").append(groupCodecVarName).append(".Next()").append(", group);\n").append(indent).append("}\n\n");
            ++i;
            i += tokens.get(i).componentTokenCount();
            ArrayList<Token> fields = new ArrayList<Token>();
            i = GenerationUtil.collectFields(tokens, i, fields);
            ArrayList<Token> groups = new ArrayList<Token>();
            i = GenerationUtil.collectGroups(tokens, i, groups);
            ArrayList<Token> varData = new ArrayList<Token>();
            i = GenerationUtil.collectVarData(tokens, i, varData);
        }
    }

    private void generateVarDataEncodeWith(StringBuilder sb, List<Token> tokens, String indent) {
        for (Token token : tokens) {
            if (token.signal() != Signal.BEGIN_VAR_DATA) continue;
            String propertyName = token.name();
            String formattedPropertyName = CSharpUtil.formatPropertyName(propertyName);
            sb.append(indent).append("codec.Set").append(formattedPropertyName).append("(dto.").append(formattedPropertyName).append(");\n");
        }
    }

    private void generateDisplay(StringBuilder sb, String codecClassName, String wrapMethod, String actingVersion, String indent) {
        sb.append("\n").append(indent).append("public string ToSbeString()\n").append(indent).append("{\n").append(indent).append("    ").append("var buffer = new DirectBuffer(new byte[128], (ignored, newSize) => new byte[newSize]);\n").append(indent).append("    ").append("var codec = new ").append(codecClassName).append("();\n").append(indent).append("    ").append("codec.");
        sb.append(wrapMethod).append("(buffer, 0");
        if (null != actingVersion) {
            sb.append(", ").append(actingVersion);
        }
        sb.append(");\n");
        sb.append(indent).append("    ").append("EncodeWith(codec, this);\n").append(indent).append("    ").append("StringBuilder sb = new StringBuilder();\n").append(indent).append("    ").append("codec.BuildString(sb);\n").append(indent).append("    ").append("return sb.ToString();\n").append(indent).append("}\n");
    }

    private void generateFields(StringBuilder sb, StringBuilder ctorArgs, String codecClassName, List<Token> tokens, String indent) {
        int size = tokens.size();
        block6: for (int i = 0; i < size; ++i) {
            Token signalToken = tokens.get(i);
            if (signalToken.signal() != Signal.BEGIN_FIELD) continue;
            Token encodingToken = tokens.get(i + 1);
            String propertyName = signalToken.name();
            switch (encodingToken.signal()) {
                case ENCODING: {
                    this.generatePrimitiveProperty(sb, ctorArgs, codecClassName, propertyName, signalToken, encodingToken, indent);
                    continue block6;
                }
                case BEGIN_ENUM: {
                    this.generateEnumProperty(sb, ctorArgs, propertyName, signalToken, encodingToken, indent);
                    continue block6;
                }
                case BEGIN_SET: {
                    this.generateBitSetProperty(sb, ctorArgs, propertyName, signalToken, encodingToken, indent);
                    continue block6;
                }
                case BEGIN_COMPOSITE: {
                    this.generateCompositeProperty(sb, ctorArgs, propertyName, signalToken, encodingToken, indent);
                    continue block6;
                }
            }
        }
    }

    private void generateCompositeProperty(StringBuilder sb, StringBuilder ctorArgs, String propertyName, Token fieldToken, Token typeToken, String indent) {
        String compositeName = this.formatDtoClassName(typeToken.applicableTypeName());
        String formattedPropertyName = CSharpUtil.formatPropertyName(propertyName);
        ctorArgs.append(indent).append(compositeName).append(" ").append(formattedPropertyName).append(",\n");
        sb.append("\n").append(CSharpUtil.generateDocumentation(indent, fieldToken)).append(indent).append("public ").append(compositeName).append(" ").append(formattedPropertyName).append(" { get; init; } = ").append(formattedPropertyName).append(";\n");
    }

    private void generateBitSetProperty(StringBuilder sb, StringBuilder ctorArgs, String propertyName, Token fieldToken, Token typeToken, String indent) {
        String enumName = CSharpUtil.formatClassName(typeToken.applicableTypeName());
        String formattedPropertyName = CSharpUtil.formatPropertyName(propertyName);
        ctorArgs.append(indent).append(enumName).append(" ").append(formattedPropertyName).append(",\n");
        sb.append("\n").append(CSharpUtil.generateDocumentation(indent, fieldToken)).append(indent).append("public ").append(enumName).append(" ").append(formattedPropertyName).append(" { get; init; } = ").append(formattedPropertyName).append(";\n");
    }

    private void generateEnumProperty(StringBuilder sb, StringBuilder ctorArgs, String propertyName, Token fieldToken, Token typeToken, String indent) {
        String enumName = CSharpUtil.formatClassName(typeToken.applicableTypeName());
        String formattedPropertyName = CSharpUtil.formatPropertyName(propertyName);
        if (fieldToken.isConstantEncoding()) {
            String constValue = fieldToken.encoding().constValue().toString();
            sb.append("\n").append(CSharpUtil.generateDocumentation(indent, fieldToken)).append(indent).append("public static ").append(enumName).append(" ").append(formattedPropertyName).append("\n").append(indent).append("{\n").append(indent).append("    ").append("get { return ").append(CSharpUtil.formatNamespace(this.ir.packageName())).append(".").append(constValue).append("; }\n").append(indent).append("}\n");
        } else {
            ctorArgs.append(indent).append(enumName).append(" ").append(formattedPropertyName).append(",\n");
            sb.append("\n").append(CSharpUtil.generateDocumentation(indent, fieldToken)).append(indent).append("public ").append(enumName).append(" ").append(formattedPropertyName).append(" { get; init; } = ").append(formattedPropertyName).append(";\n");
        }
    }

    private void generatePrimitiveProperty(StringBuilder sb, StringBuilder ctorArgs, String codecClassName, String propertyName, Token fieldToken, Token typeToken, String indent) {
        if (typeToken.isConstantEncoding()) {
            this.generateConstPropertyMethods(sb, propertyName, fieldToken, typeToken, indent);
        } else {
            this.generatePrimitivePropertyMethods(sb, ctorArgs, codecClassName, propertyName, fieldToken, typeToken, indent);
        }
    }

    private void generatePrimitivePropertyMethods(StringBuilder sb, StringBuilder ctorArgs, String codecClassName, String propertyName, Token fieldToken, Token typeToken, String indent) {
        int arrayLength = typeToken.arrayLength();
        if (arrayLength == 1) {
            this.generateSingleValueProperty(sb, ctorArgs, codecClassName, propertyName, fieldToken, typeToken, indent);
        } else if (arrayLength > 1) {
            this.generateArrayProperty(sb, ctorArgs, codecClassName, propertyName, fieldToken, typeToken, indent);
        }
    }

    private void generateArrayProperty(StringBuilder sb, StringBuilder ctorArgs, String codecClassName, String propertyName, Token fieldToken, Token typeToken, String indent) {
        String formattedPropertyName = CSharpUtil.formatPropertyName(propertyName);
        if (typeToken.encoding().primitiveType() == PrimitiveType.CHAR) {
            ctorArgs.append(indent).append("string ").append(formattedPropertyName).append(",\n");
            sb.append("\n").append(CSharpUtil.generateDocumentation(indent, fieldToken)).append(indent).append("public string ").append(formattedPropertyName).append(" { get; init; } = ").append(formattedPropertyName).append(";\n");
        } else {
            String typeName = CSharpUtil.cSharpTypeName(typeToken.encoding().primitiveType());
            String fieldName = "_" + CSharpUtil.toLowerFirstChar(propertyName);
            String nullableSuffix = fieldToken.isOptionalEncoding() ? "?" : "";
            String listTypeName = "IReadOnlyList<" + typeName + ">" + nullableSuffix;
            ctorArgs.append(indent).append(listTypeName).append(" ").append(formattedPropertyName).append(",\n");
            sb.append("\n").append(indent).append("private ").append(listTypeName).append(" ").append(fieldName).append(" = Validate").append(formattedPropertyName).append("(").append(formattedPropertyName).append(");\n");
            sb.append("\n").append(CSharpUtil.generateDocumentation(indent, fieldToken)).append(indent).append("public ").append(listTypeName).append(" ").append(formattedPropertyName).append("\n").append(indent).append("{\n").append(indent).append("    ").append("get => ").append(fieldName).append(";\n").append(indent).append("    ").append("init => ").append(fieldName).append(" = Validate").append(formattedPropertyName).append("(value);\n").append(indent).append("}\n");
            sb.append("\n").append(indent).append("private static ").append(listTypeName).append(" Validate").append(formattedPropertyName).append("(").append(listTypeName).append(" value)\n").append(indent).append("{\n");
            if (fieldToken.isOptionalEncoding()) {
                sb.append(indent).append("    ").append("if (value == null)\n").append(indent).append("    ").append("{\n").append(indent).append("    ").append("    ").append("return null;\n").append(indent).append("    ").append("}\n");
            }
            sb.append(indent).append("    ").append("if (value.Count > ").append(codecClassName).append(".").append(formattedPropertyName).append("Length)\n").append(indent).append("    ").append("{\n").append(indent).append("    ").append("    ").append("throw new ArgumentException(\"too many elements: \" + value.Count);\n").append(indent).append("    ").append("}\n").append(indent).append("    ").append("return value;\n").append(indent).append("}\n");
        }
    }

    private void generateSingleValueProperty(StringBuilder sb, StringBuilder ctorArgs, String codecClassName, String propertyName, Token fieldToken, Token typeToken, String indent) {
        boolean mustPreventGreater;
        boolean mustPreventLesser;
        String nullableSuffix = fieldToken.isOptionalEncoding() ? "?" : "";
        Encoding encoding = typeToken.encoding();
        String typeName = CSharpUtil.cSharpTypeName(encoding.primitiveType()) + nullableSuffix;
        String formattedPropertyName = CSharpUtil.formatPropertyName(propertyName);
        String fieldName = "_" + CSharpUtil.toLowerFirstChar(propertyName);
        ctorArgs.append(indent).append(typeName).append(" ").append(formattedPropertyName).append(",\n");
        sb.append("\n").append(indent).append("private ").append(typeName).append(" ").append(fieldName).append(" = Validate").append(formattedPropertyName).append("(").append(formattedPropertyName).append(");\n");
        sb.append("\n").append(CSharpUtil.generateDocumentation(indent, fieldToken)).append(indent).append("public ").append(typeName).append(" ").append(formattedPropertyName).append("\n").append(indent).append("{\n").append(indent).append("    ").append("get => ").append(fieldName).append(";\n").append(indent).append("    ").append("init => ").append(fieldName).append(" = Validate").append(formattedPropertyName).append("(value);\n").append(indent).append("}\n");
        sb.append("\n").append(indent).append("private static ").append(typeName).append(" Validate").append(formattedPropertyName).append("(").append(typeName).append(" value)\n").append(indent).append("{\n");
        if (fieldToken.isOptionalEncoding()) {
            sb.append(indent).append("    ").append("if (value == null)\n").append(indent).append("    ").append("{\n").append(indent).append("    ").append("    ").append("return null;\n").append(indent).append("    ").append("}\n");
            sb.append(indent).append("    ").append("if (value == ").append(codecClassName).append(".").append(formattedPropertyName).append("NullValue)\n").append(indent).append("    ").append("{\n").append(indent).append("    ").append("    ").append("throw new ArgumentException(\"null value is reserved: \" + value);\n").append(indent).append("    ").append("}\n");
        }
        boolean bl = mustPreventLesser = !encoding.applicableMinValue().equals(encoding.primitiveType().minValue());
        if (mustPreventLesser) {
            sb.append(indent).append("    ").append("if (value < ").append(codecClassName).append(".").append(formattedPropertyName).append("MinValue)\n").append(indent).append("    ").append("{\n").append(indent).append("    ").append("    ").append("throw new ArgumentException(\"value is less than minimum allowed: \" + value);\n").append(indent).append("    ").append("}\n");
        }
        boolean bl2 = mustPreventGreater = !encoding.applicableMaxValue().equals(encoding.primitiveType().maxValue());
        if (mustPreventGreater) {
            sb.append(indent).append("    ").append("if (value > ").append(codecClassName).append(".").append(formattedPropertyName).append("MaxValue)\n").append(indent).append("    ").append("{\n").append(indent).append("    ").append("    ").append("throw new ArgumentException(\"value is greater than maximum allowed: \" + value);\n").append(indent).append("    ").append("}\n");
        }
        sb.append(indent).append("    ").append("return value;\n").append(indent).append("}\n");
    }

    private void generateConstPropertyMethods(StringBuilder sb, String propertyName, Token fieldToken, Token typeToken, String indent) {
        if (typeToken.encoding().primitiveType() == PrimitiveType.CHAR) {
            sb.append("\n").append(CSharpUtil.generateDocumentation(indent, fieldToken)).append(indent).append("public static string ").append(CSharpUtil.toUpperFirstChar(propertyName)).append("\n").append(indent).append("{\n").append(indent).append("    ").append("get { return \"").append(typeToken.encoding().constValue().toString()).append("\"; }\n").append(indent).append("}\n");
        } else {
            String literalValue = CSharpUtil.generateLiteral(typeToken.encoding().primitiveType(), typeToken.encoding().constValue().toString());
            sb.append("\n").append(CSharpUtil.generateDocumentation(indent, fieldToken)).append(indent).append("public static ").append(CSharpUtil.cSharpTypeName(typeToken.encoding().primitiveType())).append(" ").append(CSharpUtil.formatPropertyName(propertyName)).append("\n").append(indent).append("{\n").append(indent).append("    ").append("get { return ").append(literalValue).append("; }\n").append(indent).append("}\n");
        }
    }

    private void generateVarData(StringBuilder sb, StringBuilder ctorArgs, List<Token> tokens, String indent) {
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token token = tokens.get(i);
            if (token.signal() != Signal.BEGIN_VAR_DATA) continue;
            String propertyName = token.name();
            Token varDataToken = Generators.findFirst("varData", tokens, i);
            String characterEncoding = varDataToken.encoding().characterEncoding();
            String dtoType = characterEncoding == null ? "byte[]" : "string";
            String formattedPropertyName = CSharpUtil.formatPropertyName(propertyName);
            ctorArgs.append(indent).append(dtoType).append(" ").append(formattedPropertyName).append(",\n");
            sb.append("\n").append(indent).append("public ").append(dtoType).append(" ").append(formattedPropertyName).append(" { get; init; } = ").append(formattedPropertyName).append(";\n");
        }
    }

    private String formatDtoClassName(String name) {
        return CSharpUtil.formatClassName(name + "Dto");
    }

    private void generateDtosForTypes() throws IOException {
        for (List<Token> tokens : this.ir.types()) {
            switch (tokens.get(0).signal()) {
                case BEGIN_COMPOSITE: {
                    this.generateComposite(tokens);
                    break;
                }
            }
        }
    }

    private void generateComposite(List<Token> tokens) throws IOException {
        String name = tokens.get(0).applicableTypeName();
        String className = this.formatDtoClassName(name);
        String codecClassName = CSharpUtil.formatClassName(name);
        try (Writer out = this.outputManager.createOutput(className);){
            out.append(CSharpUtil.generateFileHeader(this.ir.applicableNamespace(), "#nullable enable\n", "using System.Collections.Generic;\n", "using System.Linq;\n"));
            out.append(CSharpUtil.generateDocumentation("    ", tokens.get(0)));
            StringBuilder sb = new StringBuilder();
            StringBuilder ctorArgs = new StringBuilder();
            List<Token> compositeTokens = tokens.subList(1, tokens.size() - 1);
            this.generateCompositePropertyElements(sb, ctorArgs, codecClassName, compositeTokens, "        ");
            this.generateCompositeDecodeWith(sb, className, codecClassName, compositeTokens, "        ");
            this.generateCompositeEncodeWith(sb, className, codecClassName, compositeTokens, "        ");
            this.generateDisplay(sb, codecClassName, "Wrap", codecClassName + ".SbeSchemaVersion", "        ");
            CSharpDtoGenerator.removeTrailingComma(ctorArgs);
            out.append("    ").append("public sealed partial record ").append(className).append("(\n").append(ctorArgs).append("    ").append(")\n").append("    ").append("{").append(sb).append("    ").append("}\n").append("}\n");
        }
    }

    private static void removeTrailingComma(StringBuilder ctorArgs) {
        if (ctorArgs.length() < 2) {
            return;
        }
        if (ctorArgs.charAt(ctorArgs.length() - 1) != '\n') {
            return;
        }
        if (ctorArgs.charAt(ctorArgs.length() - 2) != ',') {
            return;
        }
        ctorArgs.setLength(ctorArgs.length() - 2);
        ctorArgs.append("\n");
    }

    private void generateCompositePropertyElements(StringBuilder sb, StringBuilder ctorArgs, String codecClassName, List<Token> tokens, String indent) {
        block6: for (int i = 0; i < tokens.size(); i += tokens.get(i).componentTokenCount()) {
            Token token = tokens.get(i);
            String propertyName = CSharpUtil.formatPropertyName(token.name());
            switch (token.signal()) {
                case ENCODING: {
                    this.generatePrimitiveProperty(sb, ctorArgs, codecClassName, propertyName, token, token, indent);
                    continue block6;
                }
                case BEGIN_ENUM: {
                    this.generateEnumProperty(sb, ctorArgs, propertyName, token, token, indent);
                    continue block6;
                }
                case BEGIN_SET: {
                    this.generateBitSetProperty(sb, ctorArgs, propertyName, token, token, indent);
                    continue block6;
                }
                case BEGIN_COMPOSITE: {
                    this.generateCompositeProperty(sb, ctorArgs, propertyName, token, token, indent);
                    continue block6;
                }
            }
        }
    }
}

