/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe;

import java.io.BufferedInputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.xml.sax.InputSource;
import uk.co.real_logic.sbe.generation.CodeGenerator;
import uk.co.real_logic.sbe.generation.TargetCodeGenerator;
import uk.co.real_logic.sbe.generation.TargetCodeGeneratorLoader;
import uk.co.real_logic.sbe.ir.Ir;
import uk.co.real_logic.sbe.ir.IrDecoder;
import uk.co.real_logic.sbe.ir.IrEncoder;
import uk.co.real_logic.sbe.xml.IrGenerator;
import uk.co.real_logic.sbe.xml.MessageSchema;
import uk.co.real_logic.sbe.xml.ParserOptions;
import uk.co.real_logic.sbe.xml.SchemaTransformerFactory;
import uk.co.real_logic.sbe.xml.XmlSchemaParser;

public class SbeTool {
    public static final String JAVA_INTERFACE_PACKAGE = "org.agrona.sbe";
    public static final String JAVA_DEFAULT_ENCODING_BUFFER_TYPE = MutableDirectBuffer.class.getName();
    public static final String JAVA_DEFAULT_DECODING_BUFFER_TYPE = DirectBuffer.class.getName();
    public static final String VALIDATION_STOP_ON_ERROR = "sbe.validation.stop.on.error";
    public static final String VALIDATION_WARNINGS_FATAL = "sbe.validation.warnings.fatal";
    public static final String VALIDATION_XSD = "sbe.validation.xsd";
    public static final String VALIDATION_SUPPRESS_OUTPUT = "sbe.validation.suppress.output";
    public static final String GENERATE_STUBS = "sbe.generate.stubs";
    public static final String XINCLUDE_AWARE = "sbe.xinclude.aware";
    public static final String TYPES_PACKAGE_OVERRIDE = "sbe.types.package.override";
    public static final String TARGET_LANGUAGE = "sbe.target.language";
    public static final String GENERATE_IR = "sbe.generate.ir";
    public static final String OUTPUT_DIR = "sbe.output.dir";
    public static final String TARGET_NAMESPACE = "sbe.target.namespace";
    public static final String CPP_NAMESPACES_COLLAPSE = "sbe.cpp.namespaces.collapse";
    public static final String RUST_CRATE_VERSION = "sbe.rust.crate.version";
    public static final String RUST_DEFAULT_CRATE_VERSION = "0.1.0";
    public static final String JAVA_GENERATE_INTERFACES = "sbe.java.generate.interfaces";
    public static final String JAVA_ENCODING_BUFFER_TYPE = "sbe.java.encoding.buffer.type";
    public static final String JAVA_DECODING_BUFFER_TYPE = "sbe.java.decoding.buffer.type";
    public static final String JAVA_GROUP_ORDER_ANNOTATION = "sbe.java.generate.group-order.annotation";
    public static final String CSHARP_GENERATE_NAMESPACE_DIR = "sbe.csharp.generate.namespace.dir";
    public static final String KEYWORD_APPEND_TOKEN = "sbe.keyword.append.token";
    public static final String DECODE_UNKNOWN_ENUM_VALUES = "sbe.decode.unknown.enum.values";
    public static final String CPP_GENERATE_DTOS = "sbe.cpp.generate.dtos";
    public static final String JAVA_GENERATE_DTOS = "sbe.java.generate.dtos";
    public static final String SCHEMA_TRANSFORM_VERSION = "sbe.schema.transform.version";
    public static final String GENERATE_PRECEDENCE_CHECKS = "sbe.generate.precedence.checks";
    public static final String PRECEDENCE_CHECKS_FLAG_NAME = "sbe.precedence.checks.flag.name";
    public static final String JAVA_PRECEDENCE_CHECKS_PROPERTY_NAME = "sbe.java.precedence.checks.property.name";

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.format("Usage: %s <filenames>...%n", SbeTool.class.getName());
            System.exit(-1);
        }
        for (String fileName : args) {
            Ir ir;
            Object schema;
            if (fileName.endsWith(".xml")) {
                String xsdFilename = System.getProperty(VALIDATION_XSD);
                if (xsdFilename != null) {
                    SbeTool.validateAgainstSchema(fileName, xsdFilename);
                }
                schema = SbeTool.parseSchema(fileName);
                SchemaTransformerFactory transformer = new SchemaTransformerFactory(System.getProperty(SCHEMA_TRANSFORM_VERSION));
                ir = new IrGenerator().generate(transformer.transform((MessageSchema)schema), System.getProperty(TARGET_NAMESPACE));
            } else if (fileName.endsWith(".sbeir")) {
                IrDecoder irDecoder = new IrDecoder(fileName);
                schema = null;
                try {
                    ir = irDecoder.decode();
                }
                catch (Throwable transformer) {
                    schema = transformer;
                    throw transformer;
                }
                finally {
                    if (irDecoder != null) {
                        if (schema != null) {
                            try {
                                irDecoder.close();
                            }
                            catch (Throwable transformer) {
                                ((Throwable)schema).addSuppressed(transformer);
                            }
                        } else {
                            irDecoder.close();
                        }
                    }
                }
            } else {
                System.err.println("Input file format not supported: " + fileName);
                System.exit(-1);
                return;
            }
            String outputDirName = System.getProperty(OUTPUT_DIR, ".");
            if (Boolean.parseBoolean(System.getProperty(GENERATE_STUBS, "true"))) {
                String targetLanguage = System.getProperty(TARGET_LANGUAGE, "Java");
                SbeTool.generate(ir, outputDirName, targetLanguage);
            }
            if (!Boolean.parseBoolean(System.getProperty(GENERATE_IR, "false"))) continue;
            File inputFile = new File(fileName);
            String inputFilename = inputFile.getName();
            int nameEnd = inputFilename.lastIndexOf(46);
            String namePart = inputFilename.substring(0, nameEnd);
            File fullPath = new File(outputDirName, namePart + ".sbeir");
            try (IrEncoder irEncoder = new IrEncoder(fullPath.getAbsolutePath(), ir);){
                irEncoder.encode();
            }
        }
    }

    public static void validateAgainstSchema(String sbeSchemaFilename, String xsdFilename) throws Exception {
        ParserOptions.Builder optionsBuilder = ParserOptions.builder().xsdFilename(System.getProperty(VALIDATION_XSD)).xIncludeAware(Boolean.parseBoolean(System.getProperty(XINCLUDE_AWARE))).stopOnError(Boolean.parseBoolean(System.getProperty(VALIDATION_STOP_ON_ERROR))).warningsFatal(Boolean.parseBoolean(System.getProperty(VALIDATION_WARNINGS_FATAL))).suppressOutput(Boolean.parseBoolean(System.getProperty(VALIDATION_SUPPRESS_OUTPUT)));
        Path path = Paths.get(sbeSchemaFilename, new String[0]);
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            InputSource inputSource = new InputSource(in);
            if (path.toAbsolutePath().getParent() != null) {
                inputSource.setSystemId(path.toUri().toString());
            }
            XmlSchemaParser.validate(xsdFilename, inputSource, optionsBuilder.build());
        }
    }

    public static MessageSchema parseSchema(String sbeSchemaFilename) throws Exception {
        ParserOptions.Builder optionsBuilder = ParserOptions.builder().xsdFilename(System.getProperty(VALIDATION_XSD)).xIncludeAware(Boolean.parseBoolean(System.getProperty(XINCLUDE_AWARE))).stopOnError(Boolean.parseBoolean(System.getProperty(VALIDATION_STOP_ON_ERROR))).warningsFatal(Boolean.parseBoolean(System.getProperty(VALIDATION_WARNINGS_FATAL))).suppressOutput(Boolean.parseBoolean(System.getProperty(VALIDATION_SUPPRESS_OUTPUT)));
        Path path = Paths.get(sbeSchemaFilename, new String[0]);
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            InputSource inputSource = new InputSource(in);
            if (path.toAbsolutePath().getParent() != null) {
                inputSource.setSystemId(path.toUri().toString());
            }
            MessageSchema messageSchema = XmlSchemaParser.parse(inputSource, optionsBuilder.build());
            return messageSchema;
        }
    }

    public static void generate(Ir ir, String outputDirName, String targetLanguage) throws Exception {
        TargetCodeGenerator targetCodeGenerator = TargetCodeGeneratorLoader.get(targetLanguage);
        CodeGenerator codeGenerator = targetCodeGenerator.newInstance(ir, outputDirName);
        codeGenerator.generate();
    }
}

