/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.xml;

import org.w3c.dom.Node;
import uk.co.real_logic.sbe.xml.Presence;
import uk.co.real_logic.sbe.xml.XmlSchemaParser;

public abstract class Type {
    private final String name;
    private final Presence presence;
    private final String description;
    private final String semanticType;
    private int offsetAttribute;

    public Type(Node node) {
        this.name = XmlSchemaParser.getAttributeValue(node, "name");
        XmlSchemaParser.checkForValidName(node, this.name);
        this.presence = Presence.get(XmlSchemaParser.getAttributeValue(node, "presence", "required"));
        this.description = XmlSchemaParser.getAttributeValueOrNull(node, "description");
        this.semanticType = XmlSchemaParser.getAttributeValueOrNull(node, "semanticType");
        this.offsetAttribute = Integer.parseInt(XmlSchemaParser.getAttributeValue(node, "offset", "-1"));
    }

    public Type(String name, Presence presence, String description, String semanticType) {
        this.name = name;
        this.presence = presence;
        this.description = description;
        this.semanticType = semanticType;
        this.offsetAttribute = -1;
    }

    public String name() {
        return this.name;
    }

    public Presence presence() {
        return this.presence;
    }

    public abstract int encodedLength();

    public String description() {
        return this.description;
    }

    public String semanticType() {
        return this.semanticType;
    }

    public abstract boolean isVariableLength();

    public int offsetAttribute() {
        return this.offsetAttribute;
    }

    public void offsetAttribute(int offsetAttribute) {
        this.offsetAttribute = offsetAttribute;
    }
}

