/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.ir.generated;

import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import uk.co.real_logic.agrona.DirectBuffer;
import uk.co.real_logic.agrona.MutableDirectBuffer;
import uk.co.real_logic.sbe.ir.generated.ByteOrderCodec;
import uk.co.real_logic.sbe.ir.generated.MetaAttribute;
import uk.co.real_logic.sbe.ir.generated.PresenceCodec;
import uk.co.real_logic.sbe.ir.generated.PrimitiveTypeCodec;
import uk.co.real_logic.sbe.ir.generated.SignalCodec;

public class TokenCodecEncoder {
    public static final int BLOCK_LENGTH = 24;
    public static final int TEMPLATE_ID = 2;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    private final TokenCodecEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    protected int offset;
    protected int limit;
    protected int actingBlockLength;
    protected int actingVersion;

    public int sbeBlockLength() {
        return 24;
    }

    public int sbeTemplateId() {
        return 2;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public int offset() {
        return this.offset;
    }

    public TokenCodecEncoder wrap(MutableDirectBuffer buffer, int offset) {
        this.buffer = buffer;
        this.offset = offset;
        this.limit(offset + 24);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int tokenOffsetNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int tokenOffsetMinValue() {
        return -2147483647;
    }

    public static int tokenOffsetMaxValue() {
        return Integer.MAX_VALUE;
    }

    public TokenCodecEncoder tokenOffset(int value) {
        this.buffer.putInt(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int tokenSizeNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int tokenSizeMinValue() {
        return -2147483647;
    }

    public static int tokenSizeMaxValue() {
        return Integer.MAX_VALUE;
    }

    public TokenCodecEncoder tokenSize(int value) {
        this.buffer.putInt(this.offset + 4, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int fieldIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int fieldIdMinValue() {
        return -2147483647;
    }

    public static int fieldIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public TokenCodecEncoder fieldId(int value) {
        this.buffer.putInt(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int tokenVersionNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int tokenVersionMinValue() {
        return -2147483647;
    }

    public static int tokenVersionMaxValue() {
        return Integer.MAX_VALUE;
    }

    public TokenCodecEncoder tokenVersion(int value) {
        this.buffer.putInt(this.offset + 12, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int componentTokenCountNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int componentTokenCountMinValue() {
        return -2147483647;
    }

    public static int componentTokenCountMaxValue() {
        return Integer.MAX_VALUE;
    }

    public TokenCodecEncoder componentTokenCount(int value) {
        this.buffer.putInt(this.offset + 16, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public TokenCodecEncoder signal(SignalCodec value) {
        this.buffer.putByte(this.offset + 20, (byte)value.value());
        return this;
    }

    public TokenCodecEncoder primitiveType(PrimitiveTypeCodec value) {
        this.buffer.putByte(this.offset + 21, (byte)value.value());
        return this;
    }

    public TokenCodecEncoder byteOrder(ByteOrderCodec value) {
        this.buffer.putByte(this.offset + 22, (byte)value.value());
        return this;
    }

    public TokenCodecEncoder presence(PresenceCodec value) {
        this.buffer.putByte(this.offset + 23, (byte)value.value());
        return this;
    }

    public static int nameId() {
        return 20;
    }

    public static String nameCharacterEncoding() {
        return "UTF-8";
    }

    public static String nameMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public int putName(DirectBuffer src, int srcOffset, int length) {
        boolean sizeOfLengthField = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        short l = (short)length;
        this.buffer.putByte(limit, (byte)l);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return length;
    }

    public int putName(byte[] src, int srcOffset, int length) {
        boolean sizeOfLengthField = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        short l = (short)length;
        this.buffer.putByte(limit, (byte)l);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return length;
    }

    public TokenCodecEncoder name(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        boolean sizeOfLengthField = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        short l = (short)length;
        this.buffer.putByte(limit, (byte)l);
        this.buffer.putBytes(limit + 1, bytes, 0, length);
        return this;
    }

    public static int constValueId() {
        return 21;
    }

    public static String constValueCharacterEncoding() {
        return "UTF-8";
    }

    public static String constValueMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public int putConstValue(DirectBuffer src, int srcOffset, int length) {
        boolean sizeOfLengthField = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        short l = (short)length;
        this.buffer.putByte(limit, (byte)l);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return length;
    }

    public int putConstValue(byte[] src, int srcOffset, int length) {
        boolean sizeOfLengthField = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        short l = (short)length;
        this.buffer.putByte(limit, (byte)l);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return length;
    }

    public TokenCodecEncoder constValue(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        boolean sizeOfLengthField = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        short l = (short)length;
        this.buffer.putByte(limit, (byte)l);
        this.buffer.putBytes(limit + 1, bytes, 0, length);
        return this;
    }

    public static int minValueId() {
        return 22;
    }

    public static String minValueCharacterEncoding() {
        return "UTF-8";
    }

    public static String minValueMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public int putMinValue(DirectBuffer src, int srcOffset, int length) {
        boolean sizeOfLengthField = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        short l = (short)length;
        this.buffer.putByte(limit, (byte)l);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return length;
    }

    public int putMinValue(byte[] src, int srcOffset, int length) {
        boolean sizeOfLengthField = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        short l = (short)length;
        this.buffer.putByte(limit, (byte)l);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return length;
    }

    public TokenCodecEncoder minValue(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        boolean sizeOfLengthField = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        short l = (short)length;
        this.buffer.putByte(limit, (byte)l);
        this.buffer.putBytes(limit + 1, bytes, 0, length);
        return this;
    }

    public static int maxValueId() {
        return 23;
    }

    public static String maxValueCharacterEncoding() {
        return "UTF-8";
    }

    public static String maxValueMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public int putMaxValue(DirectBuffer src, int srcOffset, int length) {
        boolean sizeOfLengthField = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        short l = (short)length;
        this.buffer.putByte(limit, (byte)l);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return length;
    }

    public int putMaxValue(byte[] src, int srcOffset, int length) {
        boolean sizeOfLengthField = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        short l = (short)length;
        this.buffer.putByte(limit, (byte)l);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return length;
    }

    public TokenCodecEncoder maxValue(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        boolean sizeOfLengthField = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        short l = (short)length;
        this.buffer.putByte(limit, (byte)l);
        this.buffer.putBytes(limit + 1, bytes, 0, length);
        return this;
    }

    public static int nullValueId() {
        return 24;
    }

    public static String nullValueCharacterEncoding() {
        return "UTF-8";
    }

    public static String nullValueMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public int putNullValue(DirectBuffer src, int srcOffset, int length) {
        boolean sizeOfLengthField = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        short l = (short)length;
        this.buffer.putByte(limit, (byte)l);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return length;
    }

    public int putNullValue(byte[] src, int srcOffset, int length) {
        boolean sizeOfLengthField = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        short l = (short)length;
        this.buffer.putByte(limit, (byte)l);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return length;
    }

    public TokenCodecEncoder nullValue(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        boolean sizeOfLengthField = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        short l = (short)length;
        this.buffer.putByte(limit, (byte)l);
        this.buffer.putBytes(limit + 1, bytes, 0, length);
        return this;
    }

    public static int characterEncodingId() {
        return 25;
    }

    public static String characterEncodingCharacterEncoding() {
        return "UTF-8";
    }

    public static String characterEncodingMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public int putCharacterEncoding(DirectBuffer src, int srcOffset, int length) {
        boolean sizeOfLengthField = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        short l = (short)length;
        this.buffer.putByte(limit, (byte)l);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return length;
    }

    public int putCharacterEncoding(byte[] src, int srcOffset, int length) {
        boolean sizeOfLengthField = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        short l = (short)length;
        this.buffer.putByte(limit, (byte)l);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return length;
    }

    public TokenCodecEncoder characterEncoding(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        boolean sizeOfLengthField = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        short l = (short)length;
        this.buffer.putByte(limit, (byte)l);
        this.buffer.putBytes(limit + 1, bytes, 0, length);
        return this;
    }

    public static int epochId() {
        return 26;
    }

    public static String epochCharacterEncoding() {
        return "UTF-8";
    }

    public static String epochMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public int putEpoch(DirectBuffer src, int srcOffset, int length) {
        boolean sizeOfLengthField = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        short l = (short)length;
        this.buffer.putByte(limit, (byte)l);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return length;
    }

    public int putEpoch(byte[] src, int srcOffset, int length) {
        boolean sizeOfLengthField = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        short l = (short)length;
        this.buffer.putByte(limit, (byte)l);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return length;
    }

    public TokenCodecEncoder epoch(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        boolean sizeOfLengthField = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        short l = (short)length;
        this.buffer.putByte(limit, (byte)l);
        this.buffer.putBytes(limit + 1, bytes, 0, length);
        return this;
    }

    public static int timeUnitId() {
        return 27;
    }

    public static String timeUnitCharacterEncoding() {
        return "UTF-8";
    }

    public static String timeUnitMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public int putTimeUnit(DirectBuffer src, int srcOffset, int length) {
        boolean sizeOfLengthField = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        short l = (short)length;
        this.buffer.putByte(limit, (byte)l);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return length;
    }

    public int putTimeUnit(byte[] src, int srcOffset, int length) {
        boolean sizeOfLengthField = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        short l = (short)length;
        this.buffer.putByte(limit, (byte)l);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return length;
    }

    public TokenCodecEncoder timeUnit(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        boolean sizeOfLengthField = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        short l = (short)length;
        this.buffer.putByte(limit, (byte)l);
        this.buffer.putBytes(limit + 1, bytes, 0, length);
        return this;
    }

    public static int semanticTypeId() {
        return 28;
    }

    public static String semanticTypeCharacterEncoding() {
        return "UTF-8";
    }

    public static String semanticTypeMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public int putSemanticType(DirectBuffer src, int srcOffset, int length) {
        boolean sizeOfLengthField = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        short l = (short)length;
        this.buffer.putByte(limit, (byte)l);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return length;
    }

    public int putSemanticType(byte[] src, int srcOffset, int length) {
        boolean sizeOfLengthField = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        short l = (short)length;
        this.buffer.putByte(limit, (byte)l);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return length;
    }

    public TokenCodecEncoder semanticType(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        boolean sizeOfLengthField = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        short l = (short)length;
        this.buffer.putByte(limit, (byte)l);
        this.buffer.putBytes(limit + 1, bytes, 0, length);
        return this;
    }

    public static int descriptionId() {
        return 29;
    }

    public static String descriptionCharacterEncoding() {
        return "UTF-8";
    }

    public static String descriptionMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public int putDescription(DirectBuffer src, int srcOffset, int length) {
        boolean sizeOfLengthField = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        short l = (short)length;
        this.buffer.putByte(limit, (byte)l);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return length;
    }

    public int putDescription(byte[] src, int srcOffset, int length) {
        boolean sizeOfLengthField = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        short l = (short)length;
        this.buffer.putByte(limit, (byte)l);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return length;
    }

    public TokenCodecEncoder description(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        boolean sizeOfLengthField = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        short l = (short)length;
        this.buffer.putByte(limit, (byte)l);
        this.buffer.putBytes(limit + 1, bytes, 0, length);
        return this;
    }
}

