/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.cpp;

import java.nio.ByteOrder;
import java.util.EnumMap;
import java.util.Map;
import uk.co.real_logic.sbe.PrimitiveType;

public class CppUtil {
    private static Map<PrimitiveType, String> typeNameByPrimitiveTypeMap = new EnumMap<PrimitiveType, String>(PrimitiveType.class);

    public static String cppTypeName(PrimitiveType primitiveType) {
        return typeNameByPrimitiveTypeMap.get((Object)primitiveType);
    }

    public static String toUpperFirstChar(String str) {
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public static String toLowerFirstChar(String str) {
        return Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }

    public static String formatPropertyName(String str) {
        return CppUtil.toLowerFirstChar(str);
    }

    public static String formatClassName(String str) {
        return CppUtil.toUpperFirstChar(str);
    }

    public static String formatByteOrderEncoding(ByteOrder byteOrder, PrimitiveType primitiveType) {
        switch (primitiveType.size()) {
            case 2: {
                return "SBE_" + byteOrder + "_ENCODE_16";
            }
            case 4: {
                return "SBE_" + byteOrder + "_ENCODE_32";
            }
            case 8: {
                return "SBE_" + byteOrder + "_ENCODE_64";
            }
        }
        return "";
    }

    static {
        typeNameByPrimitiveTypeMap.put(PrimitiveType.CHAR, "char");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.INT8, "std::int8_t");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.INT16, "std::int16_t");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.INT32, "std::int32_t");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.INT64, "std::int64_t");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.UINT8, "std::uint8_t");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.UINT16, "std::uint16_t");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.UINT32, "std::uint32_t");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.UINT64, "std::uint64_t");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.FLOAT, "float");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.DOUBLE, "double");
    }
}

