/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.json;

import java.io.UnsupportedEncodingException;
import java.util.List;
import org.agrona.DirectBuffer;
import org.agrona.PrintBufferUtil;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.PrimitiveValue;
import uk.co.real_logic.sbe.ir.Encoding;
import uk.co.real_logic.sbe.ir.Token;
import uk.co.real_logic.sbe.otf.TokenListener;
import uk.co.real_logic.sbe.otf.Types;

public class JsonTokenListener
implements TokenListener {
    private final StringBuilder output;
    private int indentation = 0;
    private int compositeLevel = 0;

    public JsonTokenListener(StringBuilder output) {
        this.output = output;
    }

    @Override
    public void onBeginMessage(Token token) {
        this.startObject();
    }

    @Override
    public void onEndMessage(Token token) {
        this.endObject();
    }

    @Override
    public void onEncoding(Token fieldToken, DirectBuffer buffer, int bufferIndex, Token typeToken, int actingVersion) {
        this.property(this.compositeLevel > 0 ? typeToken.name() : fieldToken.name());
        this.appendEncodingAsString(buffer, bufferIndex, fieldToken, typeToken, actingVersion);
        this.next();
    }

    @Override
    public void onEnum(Token fieldToken, DirectBuffer buffer, int bufferIndex, List<Token> tokens, int fromIndex, int toIndex, int actingVersion) {
        Token typeToken = tokens.get(fromIndex + 1);
        long encodedValue = JsonTokenListener.readEncodingAsLong(buffer, bufferIndex, typeToken, fieldToken, actingVersion);
        String value = null;
        if (fieldToken.isConstantEncoding()) {
            String refValue = fieldToken.encoding().constValue().toString();
            int indexOfDot = refValue.indexOf(46);
            value = -1 == indexOfDot ? refValue : refValue.substring(indexOfDot + 1);
        } else {
            for (int i = fromIndex + 1; i < toIndex; ++i) {
                if (encodedValue != tokens.get(i).encoding().constValue().longValue()) continue;
                value = tokens.get(i).name();
                break;
            }
        }
        this.property(this.determineName(0, fieldToken, tokens, fromIndex));
        this.doubleQuote();
        this.output.append(value);
        this.doubleQuote();
        this.next();
    }

    @Override
    public void onBitSet(Token fieldToken, DirectBuffer buffer, int bufferIndex, List<Token> tokens, int fromIndex, int toIndex, int actingVersion) {
        Token typeToken = tokens.get(fromIndex + 1);
        long encodedValue = JsonTokenListener.readEncodingAsLong(buffer, bufferIndex, typeToken, fieldToken, actingVersion);
        this.property(this.determineName(0, fieldToken, tokens, fromIndex));
        this.output.append("{ ");
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            this.output.append('\"').append(tokens.get(i).name()).append("\": ");
            long bitPosition = tokens.get(i).encoding().constValue().longValue();
            boolean flag = (encodedValue & 1L << (int)bitPosition) != 0L;
            this.output.append(flag);
            if (i >= toIndex - 1) continue;
            this.output.append(", ");
        }
        this.output.append(" }");
        this.next();
    }

    @Override
    public void onBeginComposite(Token fieldToken, List<Token> tokens, int fromIndex, int toIndex) {
        ++this.compositeLevel;
        this.property(this.determineName(1, fieldToken, tokens, fromIndex));
        this.output.append('\n');
        this.startObject();
    }

    @Override
    public void onEndComposite(Token fieldToken, List<Token> tokens, int fromIndex, int toIndex) {
        --this.compositeLevel;
        this.endObject();
    }

    @Override
    public void onGroupHeader(Token token, int numInGroup) {
        this.property(token.name());
        if (numInGroup > 0) {
            this.output.append("[\n");
        } else {
            this.output.append("[],\n");
        }
    }

    @Override
    public void onBeginGroup(Token token, int groupIndex, int numInGroup) {
        this.startObject();
    }

    @Override
    public void onEndGroup(Token token, int groupIndex, int numInGroup) {
        this.endObject();
        if (JsonTokenListener.isLastGroup(groupIndex, numInGroup)) {
            this.backup();
            this.output.append("],\n");
        }
    }

    @Override
    public void onVarData(Token fieldToken, DirectBuffer buffer, int bufferIndex, int length, Token typeToken) {
        try {
            this.property(fieldToken.name());
            this.doubleQuote();
            byte[] tempBuffer = new byte[length];
            buffer.getBytes(bufferIndex, tempBuffer, 0, length);
            String charsetName = typeToken.encoding().characterEncoding();
            String str = charsetName != null ? new String(tempBuffer, 0, length, charsetName) : PrintBufferUtil.hexDump((byte[])tempBuffer);
            this.escape(str);
            this.doubleQuote();
            this.next();
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
    }

    private static boolean isLastGroup(int groupIndex, int numInGroup) {
        return groupIndex == numInGroup - 1;
    }

    private void next() {
        this.output.append(",\n");
    }

    private void property(String name) {
        this.indent();
        this.doubleQuote();
        this.output.append(name);
        this.output.append("\": ");
    }

    /*
     * Unable to fully structure code
     */
    private void appendEncodingAsString(DirectBuffer buffer, int index, Token fieldToken, Token typeToken, int actingVersion) {
        arrayLength = typeToken.arrayLength();
        encoding = typeToken.encoding();
        constOrNotPresentValue = JsonTokenListener.constOrNotPresentValue(typeToken, fieldToken, actingVersion);
        if (null != constOrNotPresentValue) {
            characterEncoding = encoding.characterEncoding();
            if (null != characterEncoding) {
                this.doubleQuote();
                if (PrimitiveValue.Representation.LONG == constOrNotPresentValue.representation()) {
                    try {
                        longValue = constOrNotPresentValue.longValue();
                        if (0L == longValue) ** GOTO lbl17
                        this.escape(new String(new byte[]{(byte)longValue}, characterEncoding));
                    }
                    catch (UnsupportedEncodingException ex) {
                        throw new RuntimeException(ex);
                    }
                } else {
                    this.escape(constOrNotPresentValue.toString());
                }
lbl17:
                // 3 sources

                this.doubleQuote();
            } else if (arrayLength < 2) {
                Types.appendAsJsonString(this.output, constOrNotPresentValue, encoding);
            } else {
                this.output.append('[');
                for (i = 0; i < arrayLength; ++i) {
                    if (i > 0) {
                        this.output.append(", ");
                    }
                    Types.appendAsJsonString(this.output, constOrNotPresentValue, encoding);
                }
                this.output.append(']');
            }
        } else {
            elementSize = encoding.primitiveType().size();
            size = typeToken.arrayLength();
            if (size > 1 && encoding.primitiveType() == PrimitiveType.CHAR) {
                this.doubleQuote();
                for (i = 0; i < size; ++i) {
                    this.escape((char)buffer.getByte(index + i * elementSize));
                }
                this.doubleQuote();
            } else if (1 == size) {
                Types.appendAsJsonString(this.output, buffer, index, encoding);
            } else {
                this.output.append('[');
                for (i = 0; i < size; ++i) {
                    if (i > 0) {
                        this.output.append(", ");
                    }
                    Types.appendAsJsonString(this.output, buffer, index + i * elementSize, encoding);
                }
                this.output.append(']');
            }
        }
    }

    private void backup() {
        int newLength = this.output.length() - 2;
        if (this.output.charAt(newLength) == ',') {
            this.output.setLength(newLength);
        }
    }

    private void indent() {
        for (int i = 0; i < this.indentation; ++i) {
            this.output.append("    ");
        }
    }

    private void doubleQuote() {
        this.output.append('\"');
    }

    private void startObject() {
        this.indent();
        this.output.append("{\n");
        ++this.indentation;
    }

    private void endObject() {
        this.backup();
        this.output.append('\n');
        --this.indentation;
        this.indent();
        this.output.append('}');
        if (this.indentation > 0) {
            this.next();
        }
    }

    private String determineName(int thresholdLevel, Token fieldToken, List<Token> tokens, int fromIndex) {
        if (this.compositeLevel > thresholdLevel) {
            return tokens.get(fromIndex).name();
        }
        return fieldToken.name();
    }

    private static PrimitiveValue constOrNotPresentValue(Token typeToken, Token fieldToken, int actingVersion) {
        Encoding encoding = typeToken.encoding();
        if (typeToken.isConstantEncoding()) {
            return encoding.constValue();
        }
        if (fieldToken.isOptionalEncoding() && actingVersion < fieldToken.version()) {
            return encoding.applicableNullValue();
        }
        return null;
    }

    private static long readEncodingAsLong(DirectBuffer buffer, int bufferIndex, Token typeToken, Token fieldToken, int actingVersion) {
        PrimitiveValue constOrNotPresentValue = JsonTokenListener.constOrNotPresentValue(typeToken, fieldToken, actingVersion);
        if (null != constOrNotPresentValue) {
            return constOrNotPresentValue.longValue();
        }
        return Types.getLong(buffer, bufferIndex, typeToken.encoding());
    }

    private void escape(String str) {
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            this.escape(str.charAt(i));
        }
    }

    private void escape(char c) {
        if ('\"' == c || '\\' == c || '\b' == c || '\f' == c || '\n' == c || '\r' == c || '\t' == c) {
            this.output.append('\\');
        }
        this.output.append(c);
    }
}

