/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.xml;

import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Map;
import org.agrona.Verify;
import org.w3c.dom.Node;
import uk.co.real_logic.sbe.xml.CompositeType;
import uk.co.real_logic.sbe.xml.Message;
import uk.co.real_logic.sbe.xml.Type;
import uk.co.real_logic.sbe.xml.XmlSchemaParser;

public class MessageSchema {
    public static final String HEADER_TYPE_DEFAULT = "messageHeader";
    private final String packageName;
    private final String description;
    private final int id;
    private final int version;
    private final String semanticVersion;
    private final ByteOrder byteOrder;
    private final String headerType;
    private final Map<String, Type> typeByNameMap;
    private final Map<Long, Message> messageByIdMap;

    MessageSchema(Node schemaNode, Map<String, Type> typeByNameMap, Map<Long, Message> messageByIdMap) {
        this.packageName = XmlSchemaParser.getAttributeValue(schemaNode, "package");
        this.description = XmlSchemaParser.getAttributeValueOrNull(schemaNode, "description");
        this.id = Integer.parseInt(XmlSchemaParser.getAttributeValue(schemaNode, "id"));
        this.version = Integer.parseInt(XmlSchemaParser.getAttributeValue(schemaNode, "version", "0"));
        this.semanticVersion = XmlSchemaParser.getAttributeValueOrNull(schemaNode, "semanticVersion");
        this.byteOrder = XmlSchemaParser.getByteOrder(XmlSchemaParser.getAttributeValue(schemaNode, "byteOrder", "littleEndian"));
        this.typeByNameMap = typeByNameMap;
        this.messageByIdMap = messageByIdMap;
        String headerType = XmlSchemaParser.getAttributeValueOrNull(schemaNode, "headerType");
        this.headerType = null == headerType ? HEADER_TYPE_DEFAULT : headerType;
        Verify.present(typeByNameMap, (Object)this.headerType, (String)"Message header");
        ((CompositeType)typeByNameMap.get(this.headerType)).checkForWellFormedMessageHeader(schemaNode);
    }

    public CompositeType messageHeader() {
        return (CompositeType)this.typeByNameMap.get(this.headerType);
    }

    public String packageName() {
        return this.packageName;
    }

    public String description() {
        return this.description;
    }

    public int id() {
        return this.id;
    }

    public int version() {
        return this.version;
    }

    public String semanticVersion() {
        return this.semanticVersion;
    }

    public Message getMessage(long messageId) {
        return this.messageByIdMap.get(messageId);
    }

    public Type getType(String typeName) {
        return this.typeByNameMap.get(typeName);
    }

    public Collection<Message> messages() {
        return this.messageByIdMap.values();
    }

    public ByteOrder byteOrder() {
        return this.byteOrder;
    }
}

