/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.otf;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.ir.HeaderStructure;
import uk.co.real_logic.sbe.ir.Token;
import uk.co.real_logic.sbe.otf.Types;

public class OtfHeaderDecoder {
    private final int length;
    private int blockLengthOffset;
    private int templateIdOffset;
    private int schemaIdOffset;
    private int schemaVersionOffset;
    private PrimitiveType blockLengthType;
    private PrimitiveType templateIdType;
    private PrimitiveType schemaIdType;
    private PrimitiveType schemaVersionType;
    private ByteOrder blockLengthByteOrder;
    private ByteOrder templateIdByteOrder;
    private ByteOrder schemaIdByteOrder;
    private ByteOrder schemaVersionByteOrder;

    public OtfHeaderDecoder(HeaderStructure headerStructure) {
        this.length = headerStructure.tokens().get(0).encodedLength();
        for (Token token : headerStructure.tokens()) {
            switch (token.name()) {
                case "blockLength": {
                    this.blockLengthOffset = token.offset();
                    this.blockLengthType = token.encoding().primitiveType();
                    this.blockLengthByteOrder = token.encoding().byteOrder();
                    break;
                }
                case "templateId": {
                    this.templateIdOffset = token.offset();
                    this.templateIdType = token.encoding().primitiveType();
                    this.templateIdByteOrder = token.encoding().byteOrder();
                    break;
                }
                case "schemaId": {
                    this.schemaIdOffset = token.offset();
                    this.schemaIdType = token.encoding().primitiveType();
                    this.schemaIdByteOrder = token.encoding().byteOrder();
                    break;
                }
                case "version": {
                    this.schemaVersionOffset = token.offset();
                    this.schemaVersionType = token.encoding().primitiveType();
                    this.schemaVersionByteOrder = token.encoding().byteOrder();
                }
            }
        }
    }

    public int encodedLength() {
        return this.length;
    }

    public int getBlockLength(DirectBuffer buffer, int bufferOffset) {
        return Types.getInt(buffer, bufferOffset + this.blockLengthOffset, this.blockLengthType, this.blockLengthByteOrder);
    }

    public int getTemplateId(DirectBuffer buffer, int bufferOffset) {
        return Types.getInt(buffer, bufferOffset + this.templateIdOffset, this.templateIdType, this.templateIdByteOrder);
    }

    public int getSchemaId(DirectBuffer buffer, int bufferOffset) {
        return Types.getInt(buffer, bufferOffset + this.schemaIdOffset, this.schemaIdType, this.schemaIdByteOrder);
    }

    public int getSchemaVersion(DirectBuffer buffer, int bufferOffset) {
        return Types.getInt(buffer, bufferOffset + this.schemaVersionOffset, this.schemaVersionType, this.schemaVersionByteOrder);
    }
}

